% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/servicecatalog_operations.R
\name{servicecatalog_describe_portfolio_shares}
\alias{servicecatalog_describe_portfolio_shares}
\title{Returns a summary of each of the portfolio shares that were created for
the specified portfolio}
\usage{
servicecatalog_describe_portfolio_shares(
  PortfolioId,
  Type,
  PageToken = NULL,
  PageSize = NULL
)
}
\arguments{
\item{PortfolioId}{[required] The unique identifier of the portfolio for which shares will be
retrieved.}

\item{Type}{[required] The type of portfolio share to summarize. This field acts as a filter on
the type of portfolio share, which can be one of the following:

1\. \code{ACCOUNT} - Represents an external account to account share.

2\. \code{ORGANIZATION} - Represents a share to an organization. This share
is available to every account in the organization.

3\. \code{ORGANIZATIONAL_UNIT} - Represents a share to an organizational
unit.

4\. \code{ORGANIZATION_MEMBER_ACCOUNT} - Represents a share to an account in
the organization.}

\item{PageToken}{The page token for the next set of results. To retrieve the first set of
results, use null.}

\item{PageSize}{The maximum number of items to return with this call.}
}
\description{
Returns a summary of each of the portfolio shares that were created for the specified portfolio.

See \url{https://paws-r.github.io/docs/servicecatalog/describe_portfolio_shares.html} for full documentation.
}
\keyword{internal}
