% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/servicecatalog_operations.R
\name{servicecatalog_list_portfolio_access}
\alias{servicecatalog_list_portfolio_access}
\title{Lists the account IDs that have access to the specified portfolio}
\usage{
servicecatalog_list_portfolio_access(
  AcceptLanguage = NULL,
  PortfolioId,
  OrganizationParentId = NULL,
  PageToken = NULL,
  PageSize = NULL
)
}
\arguments{
\item{AcceptLanguage}{The language code.
\itemize{
\item \code{en} - English (default)
\item \code{jp} - Japanese
\item \code{zh} - Chinese
}}

\item{PortfolioId}{[required] The portfolio identifier.}

\item{OrganizationParentId}{The ID of an organization node the portfolio is shared with. All
children of this node with an inherited portfolio share will be
returned.}

\item{PageToken}{The page token for the next set of results. To retrieve the first set of
results, use null.}

\item{PageSize}{The maximum number of items to return with this call.}
}
\description{
Lists the account IDs that have access to the specified portfolio.

See \url{https://paws-r.github.io/docs/servicecatalog/list_portfolio_access.html} for full documentation.
}
\keyword{internal}
