% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssm_operations.R
\name{ssm_list_command_invocations}
\alias{ssm_list_command_invocations}
\title{An invocation is copy of a command sent to a specific managed node}
\usage{
ssm_list_command_invocations(
  CommandId = NULL,
  InstanceId = NULL,
  MaxResults = NULL,
  NextToken = NULL,
  Filters = NULL,
  Details = NULL
)
}
\arguments{
\item{CommandId}{(Optional) The invocations for a specific command ID.}

\item{InstanceId}{(Optional) The command execution details for a specific managed node ID.}

\item{MaxResults}{(Optional) The maximum number of items to return for this call. The call
also returns a token that you can specify in a subsequent call to get
the next set of results.}

\item{NextToken}{(Optional) The token for the next set of items to return. (You received
this token from a previous call.)}

\item{Filters}{(Optional) One or more filters. Use a filter to return a more specific
list of results.}

\item{Details}{(Optional) If set this returns the response of the command executions
and any command output. The default value is \code{false}.}
}
\description{
An invocation is copy of a command sent to a specific managed node. A command can apply to one or more managed nodes. A command invocation applies to one managed node. For example, if a user runs \code{\link[=ssm_send_command]{send_command}} against three managed nodes, then a command invocation is created for each requested managed node ID. \code{\link[=ssm_list_command_invocations]{list_command_invocations}} provide status about command execution.

See \url{https://paws-r.github.io/docs/ssm/list_command_invocations.html} for full documentation.
}
\keyword{internal}
