% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudwatchlogs_operations.R
\name{cloudwatchlogs_create_log_group}
\alias{cloudwatchlogs_create_log_group}
\title{Creates a log group with the specified name}
\usage{
cloudwatchlogs_create_log_group(logGroupName, kmsKeyId = NULL, tags = NULL)
}
\arguments{
\item{logGroupName}{[required] The name of the log group.}

\item{kmsKeyId}{The Amazon Resource Name (ARN) of the KMS key to use when encrypting log
data. For more information, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html#arn-syntax-kms}{Amazon Resource Names}.}

\item{tags}{The key-value pairs to use for the tags.

You can grant users access to certain log groups while preventing them
from accessing other log groups. To do so, tag your groups and use IAM
policies that refer to those tags. To assign tags when you create a log
group, you must have either the \code{logs:TagResource} or \code{logs:TagLogGroup}
permission. For more information about tagging, see \href{https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html}{Tagging Amazon Web Services resources}.
For more information about using tags to control access, see
\href{https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html}{Controlling access to Amazon Web Services resources using tags}.}
}
\description{
Creates a log group with the specified name. You can create up to 20,000 log groups per account.

See \url{https://www.paws-r-sdk.com/docs/cloudwatchlogs_create_log_group/} for full documentation.
}
\keyword{internal}
