% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudwatchrum_operations.R
\name{cloudwatchrum_batch_create_rum_metric_definitions}
\alias{cloudwatchrum_batch_create_rum_metric_definitions}
\title{Specifies the extended metrics and custom metrics that you want a
CloudWatch RUM app monitor to send to a destination}
\usage{
cloudwatchrum_batch_create_rum_metric_definitions(
  AppMonitorName,
  Destination,
  DestinationArn = NULL,
  MetricDefinitions
)
}
\arguments{
\item{AppMonitorName}{[required] The name of the CloudWatch RUM app monitor that is to send the metrics.}

\item{Destination}{[required] The destination to send the metrics to. Valid values are \code{CloudWatch}
and \code{Evidently}. If you specify \code{Evidently}, you must also specify the
ARN of the CloudWatchEvidently experiment that will receive the metrics
and an IAM role that has permission to write to the experiment.}

\item{DestinationArn}{This parameter is required if \code{Destination} is \code{Evidently}. If
\code{Destination} is \code{CloudWatch}, do not use this parameter.

This parameter specifies the ARN of the Evidently experiment that is to
receive the metrics. You must have already defined this experiment as a
valid destination. For more information, see
\code{\link[=cloudwatchrum_put_rum_metrics_destination]{put_rum_metrics_destination}}.}

\item{MetricDefinitions}{[required] An array of structures which define the metrics that you want to send.}
}
\description{
Specifies the extended metrics and custom metrics that you want a CloudWatch RUM app monitor to send to a destination. Valid destinations include CloudWatch and Evidently.

See \url{https://www.paws-r-sdk.com/docs/cloudwatchrum_batch_create_rum_metric_definitions/} for full documentation.
}
\keyword{internal}
