% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opsworks_operations.R
\name{opsworks_set_load_based_auto_scaling}
\alias{opsworks_set_load_based_auto_scaling}
\title{Specify the load-based auto scaling configuration for a specified layer}
\usage{
opsworks_set_load_based_auto_scaling(
  LayerId,
  Enable = NULL,
  UpScaling = NULL,
  DownScaling = NULL
)
}
\arguments{
\item{LayerId}{[required] The layer ID.}

\item{Enable}{Enables load-based auto scaling for the layer.}

\item{UpScaling}{An \code{AutoScalingThresholds} object with the upscaling threshold
configuration. If the load exceeds these thresholds for a specified
amount of time, AWS OpsWorks Stacks starts a specified number of
instances.}

\item{DownScaling}{An \code{AutoScalingThresholds} object with the downscaling threshold
configuration. If the load falls below these thresholds for a specified
amount of time, AWS OpsWorks Stacks stops a specified number of
instances.}
}
\description{
Specify the load-based auto scaling configuration for a specified layer. For more information, see \href{https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-autoscaling.html}{Managing Load with Time-based and Load-based Instances}.

See \url{https://www.paws-r-sdk.com/docs/opsworks_set_load_based_auto_scaling/} for full documentation.
}
\keyword{internal}
