% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resourcegroups_service.R
\name{resourcegroups}
\alias{resourcegroups}
\title{AWS Resource Groups}
\usage{
resourcegroups(
  config = list(),
  credentials = list(),
  endpoint = NULL,
  region = NULL
)
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.
\itemize{
\item{\strong{credentials}:} {\itemize{
\item{\strong{creds}:} {\itemize{
\item{\strong{access_key_id}:} {AWS access key ID}
\item{\strong{secret_access_key}:} {AWS secret access key}
\item{\strong{session_token}:} {AWS temporary session token}
}}
\item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}:} {Set anonymous credentials.}
\item{\strong{endpoint}:} {The complete URL to use for the constructed client.}
\item{\strong{region}:} {The AWS Region used in instantiating the client.}
}}
\item{\strong{close_connection}:} {Immediately close all HTTP connections.}
\item{\strong{timeout}:} {The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
\item{\strong{s3_force_path_style}:} {Set this to \code{true} to force the request to use path-style addressing, i.e. \verb{http://s3.amazonaws.com/BUCKET/KEY}.}
\item{\strong{sts_regional_endpoint}:} {Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
}}

\item{credentials}{Optional credentials shorthand for the config parameter
\itemize{
\item{\strong{creds}:} {\itemize{
\item{\strong{access_key_id}:} {AWS access key ID}
\item{\strong{secret_access_key}:} {AWS secret access key}
\item{\strong{session_token}:} {AWS temporary session token}
}}
\item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}:} {Set anonymous credentials.}
}}

\item{endpoint}{Optional shorthand for complete URL to use for the constructed client.}

\item{region}{Optional shorthand for AWS Region used in instantiating the client.}
}
\value{
A client for the service. You can call the service's operations using
syntax like \code{svc$operation(...)}, where \code{svc} is the name you've assigned
to the client. The available operations are listed in the
Operations section.
}
\description{
Resource Groups lets you organize Amazon Web Services resources such as
Amazon Elastic Compute Cloud instances, Amazon Relational Database
Service databases, and Amazon Simple Storage Service buckets into groups
using criteria that you define as tags. A resource group is a collection
of resources that match the resource types specified in a query, and
share one or more tags or portions of tags. You can create a group of
resources based on their roles in your cloud infrastructure, lifecycle
stages, regions, application layers, or virtually any criteria. Resource
Groups enable you to automate management tasks, such as those in Amazon
Web Services Systems Manager Automation documents, on tag-related
resources in Amazon Web Services Systems Manager. Groups of tagged
resources also let you quickly view a custom console in Amazon Web
Services Systems Manager that shows Config compliance and other
monitoring data about member resources.

To create a resource group, build a resource query, and specify tags
that identify the criteria that members of the group have in common.
Tags are key-value pairs.

For more information about Resource Groups, see the \href{https://docs.aws.amazon.com/ARG/latest/userguide/}{Resource Groups User Guide}.

Resource Groups uses a REST-compliant API that you can use to perform
the following types of operations.
\itemize{
\item Create, Read, Update, and Delete (CRUD) operations on resource
groups and resource query entities
\item Applying, editing, and removing tags from resource groups
\item Resolving resource group member ARNs so they can be returned as
search results
\item Getting data about resources that are members of a group
\item Searching Amazon Web Services resources based on a resource query
}
}
\section{Service syntax}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{svc <- resourcegroups(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string",
      anonymous = "logical"
    ),
    endpoint = "string",
    region = "string",
    close_connection = "logical",
    timeout = "numeric",
    s3_force_path_style = "logical",
    sts_regional_endpoint = "string"
  ),
  credentials = list(
    creds = list(
      access_key_id = "string",
      secret_access_key = "string",
      session_token = "string"
    ),
    profile = "string",
    anonymous = "logical"
  ),
  endpoint = "string",
  region = "string"
)
}\if{html}{\out{</div>}}
}

\section{Operations}{

\tabular{ll}{
\link[=resourcegroups_create_group]{create_group} \tab Creates a resource group with the specified name and description\cr
\link[=resourcegroups_delete_group]{delete_group} \tab Deletes the specified resource group\cr
\link[=resourcegroups_get_account_settings]{get_account_settings} \tab Retrieves the current status of optional features in Resource Groups\cr
\link[=resourcegroups_get_group]{get_group} \tab Returns information about a specified resource group\cr
\link[=resourcegroups_get_group_configuration]{get_group_configuration} \tab Retrieves the service configuration associated with the specified resource group\cr
\link[=resourcegroups_get_group_query]{get_group_query} \tab Retrieves the resource query associated with the specified resource group\cr
\link[=resourcegroups_get_tags]{get_tags} \tab Returns a list of tags that are associated with a resource group, specified by an ARN\cr
\link[=resourcegroups_group_resources]{group_resources} \tab Adds the specified resources to the specified group\cr
\link[=resourcegroups_list_group_resources]{list_group_resources} \tab Returns a list of ARNs of the resources that are members of a specified resource group\cr
\link[=resourcegroups_list_groups]{list_groups} \tab Returns a list of existing Resource Groups in your account\cr
\link[=resourcegroups_put_group_configuration]{put_group_configuration} \tab Attaches a service configuration to the specified group\cr
\link[=resourcegroups_search_resources]{search_resources} \tab Returns a list of Amazon Web Services resource identifiers that matches the specified query\cr
\link[=resourcegroups_tag]{tag} \tab Adds tags to a resource group with the specified ARN\cr
\link[=resourcegroups_ungroup_resources]{ungroup_resources} \tab Removes the specified resources from the specified group\cr
\link[=resourcegroups_untag]{untag} \tab Deletes tags from a specified resource group\cr
\link[=resourcegroups_update_account_settings]{update_account_settings} \tab Turns on or turns off optional features in Resource Groups\cr
\link[=resourcegroups_update_group]{update_group} \tab Updates the description for an existing group\cr
\link[=resourcegroups_update_group_query]{update_group_query} \tab Updates the resource query of a group
}
}

\examples{
\dontrun{
svc <- resourcegroups()
svc$create_group(
  Foo = 123
)
}

}
