# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config merge_config
NULL

#' CloudWatch Observability Access Manager
#'
#' @description
#' Use Amazon CloudWatch Observability Access Manager to create and manage
#' links between source accounts and monitoring accounts by using
#' *CloudWatch cross-account observability*. With CloudWatch cross-account
#' observability, you can monitor and troubleshoot applications that span
#' multiple accounts within a Region. Seamlessly search, visualize, and
#' analyze your metrics, logs, traces, and Application Insights
#' applications in any of the linked accounts without account boundaries.
#' 
#' Set up one or more Amazon Web Services accounts as *monitoring accounts*
#' and link them with multiple *source accounts*. A monitoring account is a
#' central Amazon Web Services account that can view and interact with
#' observability data generated from source accounts. A source account is
#' an individual Amazon Web Services account that generates observability
#' data for the resources that reside in it. Source accounts share their
#' observability data with the monitoring account. The shared observability
#' data can include metrics in Amazon CloudWatch, logs in Amazon CloudWatch
#' Logs, traces in X-Ray, and applications in Amazon CloudWatch Application
#' Insights.
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{credentials}: \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }}
#' \item{\strong{endpoint}: The complete URL to use for the constructed client.}
#' \item{\strong{region}: The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}: Immediately close all HTTP connections.}
#' \item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}: Set this to `true` to force the request to use path-style addressing, i.e. `http://s3.amazonaws.com/BUCKET/KEY`.}
#' \item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
#' }
#' @param
#' credentials
#' Optional credentials shorthand for the config parameter
#' \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }
#' @param
#' endpoint
#' Optional shorthand for complete URL to use for the constructed client.
#' @param
#' region
#' Optional shorthand for AWS Region used in instantiating the client.
#'
#' @section Service syntax:
#' ```
#' svc <- cloudwatchobservabilityaccessmanager(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical",
#'     sts_regional_endpoint = "string"
#'   ),
#'   credentials = list(
#'     creds = list(
#'       access_key_id = "string",
#'       secret_access_key = "string",
#'       session_token = "string"
#'     ),
#'     profile = "string",
#'     anonymous = "logical"
#'   ),
#'   endpoint = "string",
#'   region = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- cloudwatchobservabilityaccessmanager()
#' svc$create_link(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=cloudwatchobservabilityaccessmanager_create_link]{create_link} \tab Creates a link between a source account and a sink that you have created in a monitoring account\cr
#'  \link[=cloudwatchobservabilityaccessmanager_create_sink]{create_sink} \tab Use this to create a sink in the current account, so that it can be used as a monitoring account in CloudWatch cross-account observability\cr
#'  \link[=cloudwatchobservabilityaccessmanager_delete_link]{delete_link} \tab Deletes a link between a monitoring account sink and a source account\cr
#'  \link[=cloudwatchobservabilityaccessmanager_delete_sink]{delete_sink} \tab Deletes a sink\cr
#'  \link[=cloudwatchobservabilityaccessmanager_get_link]{get_link} \tab Returns complete information about one link\cr
#'  \link[=cloudwatchobservabilityaccessmanager_get_sink]{get_sink} \tab Returns complete information about one monitoring account sink\cr
#'  \link[=cloudwatchobservabilityaccessmanager_get_sink_policy]{get_sink_policy} \tab Returns the current sink policy attached to this sink\cr
#'  \link[=cloudwatchobservabilityaccessmanager_list_attached_links]{list_attached_links} \tab Returns a list of source account links that are linked to this monitoring account sink\cr
#'  \link[=cloudwatchobservabilityaccessmanager_list_links]{list_links} \tab Use this operation in a source account to return a list of links to monitoring account sinks that this source account has\cr
#'  \link[=cloudwatchobservabilityaccessmanager_list_sinks]{list_sinks} \tab Use this operation in a monitoring account to return the list of sinks created in that account\cr
#'  \link[=cloudwatchobservabilityaccessmanager_list_tags_for_resource]{list_tags_for_resource} \tab Displays the tags associated with a resource\cr
#'  \link[=cloudwatchobservabilityaccessmanager_put_sink_policy]{put_sink_policy} \tab Creates or updates the resource policy that grants permissions to source accounts to link to the monitoring account sink\cr
#'  \link[=cloudwatchobservabilityaccessmanager_tag_resource]{tag_resource} \tab Assigns one or more tags (key-value pairs) to the specified resource\cr
#'  \link[=cloudwatchobservabilityaccessmanager_untag_resource]{untag_resource} \tab Removes one or more tags from the specified resource\cr
#'  \link[=cloudwatchobservabilityaccessmanager_update_link]{update_link} \tab Use this operation to change what types of data are shared from a source account to its linked monitoring account sink
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname cloudwatchobservabilityaccessmanager
#' @export
cloudwatchobservabilityaccessmanager <- function(config = list(), credentials = list(), endpoint = NULL, region = NULL) {
  config <- merge_config(
    config,
    list(
      credentials = credentials,
      endpoint = endpoint,
      region = region
    )
  )
  svc <- .cloudwatchobservabilityaccessmanager$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.cloudwatchobservabilityaccessmanager <- list()

.cloudwatchobservabilityaccessmanager$operations <- list()

.cloudwatchobservabilityaccessmanager$metadata <- list(
  service_name = "cloudwatchobservabilityaccessmanager",
  endpoints = list("*" = list(endpoint = "oam.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "oam.{region}.amazonaws.com.cn", global = FALSE), "eu-isoe-*" = list(endpoint = "oam.{region}.cloud.adc-e.uk", global = FALSE), "us-iso-*" = list(endpoint = "oam.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "oam.{region}.sc2s.sgov.gov", global = FALSE), "us-isof-*" = list(endpoint = "oam.{region}.csp.hci.ic.gov", global = FALSE)),
  service_id = "OAM",
  api_version = "2022-06-10",
  signing_name = "oam",
  json_version = "1.1",
  target_prefix = ""
)

.cloudwatchobservabilityaccessmanager$service <- function(config = list(), op = NULL) {
  handlers <- new_handlers("restjson", "v4")
  new_service(.cloudwatchobservabilityaccessmanager$metadata, handlers, config, op)
}
