# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config merge_config
NULL

#' AWS Support
#'
#' @description
#' Amazon Web Services Support
#' 
#' The *Amazon Web Services Support API Reference* is intended for
#' programmers who need detailed information about the Amazon Web Services
#' Support operations and data types. You can use the API to manage your
#' support cases programmatically. The Amazon Web Services Support API uses
#' HTTP methods that return results in JSON format.
#' 
#' -   You must have a Business, Enterprise On-Ramp, or Enterprise Support
#'     plan to use the Amazon Web Services Support API.
#' 
#' -   If you call the Amazon Web Services Support API from an account that
#'     doesn't have a Business, Enterprise On-Ramp, or Enterprise Support
#'     plan, the `SubscriptionRequiredException` error message appears. For
#'     information about changing your support plan, see [Amazon Web
#'     Services Support](https://aws.amazon.com/premiumsupport/).
#' 
#' You can also use the Amazon Web Services Support API to access features
#' for [Trusted
#' Advisor](https://aws.amazon.com/premiumsupport/technology/trusted-advisor/).
#' You can return a list of checks and their descriptions, get check
#' results, specify checks to refresh, and get the refresh status of
#' checks.
#' 
#' You can manage your support cases with the following Amazon Web Services
#' Support API operations:
#' 
#' -   The [`create_case`][support_create_case],
#'     [`describe_cases`][support_describe_cases],
#'     [`describe_attachment`][support_describe_attachment], and
#'     [`resolve_case`][support_resolve_case] operations create Amazon Web
#'     Services Support cases, retrieve information about cases, and
#'     resolve cases.
#' 
#' -   The [`describe_communications`][support_describe_communications],
#'     [`add_communication_to_case`][support_add_communication_to_case],
#'     and [`add_attachments_to_set`][support_add_attachments_to_set]
#'     operations retrieve and add communications and attachments to Amazon
#'     Web Services Support cases.
#' 
#' -   The [`describe_services`][support_describe_services] and
#'     [`describe_severity_levels`][support_describe_severity_levels]
#'     operations return Amazon Web Service names, service codes, service
#'     categories, and problem severity levels. You use these values when
#'     you call the [`create_case`][support_create_case] operation.
#' 
#' You can also use the Amazon Web Services Support API to call the Trusted
#' Advisor operations. For more information, see [Trusted
#' Advisor](https://docs.aws.amazon.com/awssupport/latest/user/trusted-advisor.html)
#' in the *Amazon Web Services Support User Guide*.
#' 
#' For authentication of requests, Amazon Web Services Support uses
#' [Signature Version 4 Signing
#' Process](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html).
#' 
#' For more information about this service and the endpoints to use, see
#' [About the Amazon Web Services Support
#' API](https://docs.aws.amazon.com/awssupport/latest/user/about-support-api.html)
#' in the *Amazon Web Services Support User Guide*.
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{credentials}: \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }}
#' \item{\strong{endpoint}: The complete URL to use for the constructed client.}
#' \item{\strong{region}: The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}: Immediately close all HTTP connections.}
#' \item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}: Set this to `true` to force the request to use path-style addressing, i.e. `http://s3.amazonaws.com/BUCKET/KEY`.}
#' \item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
#' }
#' @param
#' credentials
#' Optional credentials shorthand for the config parameter
#' \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }
#' @param
#' endpoint
#' Optional shorthand for complete URL to use for the constructed client.
#' @param
#' region
#' Optional shorthand for AWS Region used in instantiating the client.
#'
#' @section Service syntax:
#' ```
#' svc <- support(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical",
#'     sts_regional_endpoint = "string"
#'   ),
#'   credentials = list(
#'     creds = list(
#'       access_key_id = "string",
#'       secret_access_key = "string",
#'       session_token = "string"
#'     ),
#'     profile = "string",
#'     anonymous = "logical"
#'   ),
#'   endpoint = "string",
#'   region = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- support()
#' svc$add_attachments_to_set(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=support_add_attachments_to_set]{add_attachments_to_set} \tab Adds one or more attachments to an attachment set\cr
#'  \link[=support_add_communication_to_case]{add_communication_to_case} \tab Adds additional customer communication to an Amazon Web Services Support case\cr
#'  \link[=support_create_case]{create_case} \tab Creates a case in the Amazon Web Services Support Center\cr
#'  \link[=support_describe_attachment]{describe_attachment} \tab Returns the attachment that has the specified ID\cr
#'  \link[=support_describe_cases]{describe_cases} \tab Returns a list of cases that you specify by passing one or more case IDs\cr
#'  \link[=support_describe_communications]{describe_communications} \tab Returns communications and attachments for one or more support cases\cr
#'  \link[=support_describe_create_case_options]{describe_create_case_options} \tab Returns a list of CreateCaseOption types along with the corresponding supported hours and language availability\cr
#'  \link[=support_describe_services]{describe_services} \tab Returns the current list of Amazon Web Services services and a list of service categories for each service\cr
#'  \link[=support_describe_severity_levels]{describe_severity_levels} \tab Returns the list of severity levels that you can assign to a support case\cr
#'  \link[=support_describe_supported_languages]{describe_supported_languages} \tab Returns a list of supported languages for a specified categoryCode, issueType and serviceCode\cr
#'  \link[=support_describe_trusted_advisor_check_refresh_statuses]{describe_trusted_advisor_check_refresh_statuses} \tab Returns the refresh status of the Trusted Advisor checks that have the specified check IDs\cr
#'  \link[=support_describe_trusted_advisor_check_result]{describe_trusted_advisor_check_result} \tab Returns the results of the Trusted Advisor check that has the specified check ID\cr
#'  \link[=support_describe_trusted_advisor_checks]{describe_trusted_advisor_checks} \tab Returns information about all available Trusted Advisor checks, including the name, ID, category, description, and metadata\cr
#'  \link[=support_describe_trusted_advisor_check_summaries]{describe_trusted_advisor_check_summaries} \tab Returns the results for the Trusted Advisor check summaries for the check IDs that you specified\cr
#'  \link[=support_refresh_trusted_advisor_check]{refresh_trusted_advisor_check} \tab Refreshes the Trusted Advisor check that you specify using the check ID\cr
#'  \link[=support_resolve_case]{resolve_case} \tab Resolves a support case
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname support
#' @export
support <- function(config = list(), credentials = list(), endpoint = NULL, region = NULL) {
  config <- merge_config(
    config,
    list(
      credentials = credentials,
      endpoint = endpoint,
      region = region
    )
  )
  svc <- .support$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.support <- list()

.support$operations <- list()

.support$metadata <- list(
  service_name = "support",
  endpoints = list("*" = list(endpoint = "support.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "support.{region}.amazonaws.com.cn", global = FALSE), "eu-isoe-*" = list(endpoint = "support.{region}.cloud.adc-e.uk", global = FALSE), "us-iso-*" = list(endpoint = "support.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "support.{region}.sc2s.sgov.gov", global = FALSE), "us-isof-*" = list(endpoint = "support.{region}.csp.hci.ic.gov", global = FALSE)),
  service_id = "Support",
  api_version = "2013-04-15",
  signing_name = "support",
  json_version = "1.1",
  target_prefix = "AWSSupport_20130415"
)

.support$service <- function(config = list(), op = NULL) {
  handlers <- new_handlers("jsonrpc", "v4")
  new_service(.support$metadata, handlers, config, op)
}
