% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resiliencehub_operations.R
\name{resiliencehub_remove_draft_app_version_resource_mappings}
\alias{resiliencehub_remove_draft_app_version_resource_mappings}
\title{Removes resource mappings from a draft application version}
\usage{
resiliencehub_remove_draft_app_version_resource_mappings(
  appArn,
  appRegistryAppNames = NULL,
  eksSourceNames = NULL,
  logicalStackNames = NULL,
  resourceGroupNames = NULL,
  resourceNames = NULL,
  terraformSourceNames = NULL
)
}
\arguments{
\item{appArn}{[required] Amazon Resource Name (ARN) of the Resilience Hub application. The format
for this ARN is:
arn:\code{partition}:resiliencehub:\code{region}:\code{account}:app/\code{app-id}. For more
information about ARNs, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html}{Amazon Resource Names (ARNs)}
in the \emph{Amazon Web Services General Reference} guide.}

\item{appRegistryAppNames}{The names of the registered applications you want to remove from the
resource mappings.}

\item{eksSourceNames}{The names of the Amazon Elastic Kubernetes Service clusters and
namespaces you want to remove from the resource mappings.

This parameter accepts values in "eks-cluster/namespace" format.}

\item{logicalStackNames}{The names of the CloudFormation stacks you want to remove from the
resource mappings.}

\item{resourceGroupNames}{The names of the resource groups you want to remove from the resource
mappings.}

\item{resourceNames}{The names of the resources you want to remove from the resource
mappings.}

\item{terraformSourceNames}{The names of the Terraform sources you want to remove from the resource
mappings.}
}
\description{
Removes resource mappings from a draft application version.

See \url{https://www.paws-r-sdk.com/docs/resiliencehub_remove_draft_app_version_resource_mappings/} for full documentation.
}
\keyword{internal}
