% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudfront_operations.R
\name{cloudfront_create_monitoring_subscription}
\alias{cloudfront_create_monitoring_subscription}
\title{Enables additional CloudWatch metrics for the specified CloudFront
distribution}
\usage{
cloudfront_create_monitoring_subscription(DistributionId,
  MonitoringSubscription)
}
\arguments{
\item{DistributionId}{[required] The ID of the distribution that you are enabling metrics for.}

\item{MonitoringSubscription}{[required] A monitoring subscription. This structure contains information about
whether additional CloudWatch metrics are enabled for a given CloudFront
distribution.}
}
\description{
Enables additional CloudWatch metrics for the specified CloudFront
distribution. The additional metrics incur an additional cost.

For more information, see \href{https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/viewing-cloudfront-metrics.html#monitoring-console.distributions-additional}{Viewing additional CloudFront distribution metrics}
in the \emph{Amazon CloudFront Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$create_monitoring_subscription(
  DistributionId = "string",
  MonitoringSubscription = list(
    RealtimeMetricsSubscriptionConfig = list(
      RealtimeMetricsSubscriptionStatus = "Enabled"|"Disabled"
    )
  )
)
}
}

\keyword{internal}
