% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudfront_operations.R
\name{cloudfront_list_distributions_by_cache_policy_id}
\alias{cloudfront_list_distributions_by_cache_policy_id}
\title{Gets a list of distribution IDs for distributions that have a cache
behavior that’s associated with the specified cache policy}
\usage{
cloudfront_list_distributions_by_cache_policy_id(Marker, MaxItems,
  CachePolicyId)
}
\arguments{
\item{Marker}{Use this field when paginating results to indicate where to begin in
your list of distribution IDs. The response includes distribution IDs in
the list that occur after the marker. To get the next page of the list,
set this field’s value to the value of \code{NextMarker} from the current
page’s response.}

\item{MaxItems}{The maximum number of distribution IDs that you want in the response.}

\item{CachePolicyId}{[required] The ID of the cache policy whose associated distribution IDs you want to
list.}
}
\description{
Gets a list of distribution IDs for distributions that have a cache
behavior that’s associated with the specified cache policy.

You can optionally specify the maximum number of items to receive in the
response. If the total number of items in the list exceeds the maximum
that you specify, or the default maximum, the response is paginated. To
get the next page of items, send a subsequent request that specifies the
\code{NextMarker} value from the current response as the \code{Marker} value in
the subsequent request.
}
\section{Request syntax}{
\preformatted{svc$list_distributions_by_cache_policy_id(
  Marker = "string",
  MaxItems = "string",
  CachePolicyId = "string"
)
}
}

\keyword{internal}
