% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elb_service.R
\name{elb}
\alias{elb}
\title{Elastic Load Balancing}
\usage{
elb(config = list())
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.}
}
\description{
A load balancer can distribute incoming traffic across your EC2
instances. This enables you to increase the availability of your
application. The load balancer also monitors the health of its
registered instances and ensures that it routes traffic only to healthy
instances. You configure your load balancer to accept incoming traffic
by specifying one or more listeners, which are configured with a
protocol and port number for connections from clients to the load
balancer and a protocol and port number for connections from the load
balancer to the instances.

Elastic Load Balancing supports three types of load balancers:
Application Load Balancers, Network Load Balancers, and Classic Load
Balancers. You can select a load balancer based on your application
needs. For more information, see the \href{https://docs.aws.amazon.com/elasticloadbalancing/latest/userguide/}{Elastic Load Balancing User Guide}.

This reference covers the 2012-06-01 API, which supports Classic Load
Balancers. The 2015-12-01 API supports Application Load Balancers and
Network Load Balancers.

To get started, create a load balancer with one or more listeners using
\code{\link[=elb_create_load_balancer]{create_load_balancer}}. Register your
instances with the load balancer using
\code{\link[=elb_register_instances_with_load_balancer]{register_instances_with_load_balancer}}.

All Elastic Load Balancing operations are \emph{idempotent}, which means that
they complete at most one time. If you repeat an operation, it succeeds
with a 200 OK response code.
}
\section{Service syntax}{
\preformatted{svc <- elb(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string"
    ),
    endpoint = "string",
    region = "string"
  )
)
}
}

\section{Operations}{

\tabular{ll}{
\link[=elb_add_tags]{add_tags} \tab Adds the specified tags to the specified load balancer\cr
\link[=elb_apply_security_groups_to_load_balancer]{apply_security_groups_to_load_balancer} \tab Associates one or more security groups with your load balancer in a virtual private cloud (VPC)\cr
\link[=elb_attach_load_balancer_to_subnets]{attach_load_balancer_to_subnets} \tab Adds one or more subnets to the set of configured subnets for the specified load balancer\cr
\link[=elb_configure_health_check]{configure_health_check} \tab Specifies the health check settings to use when evaluating the health state of your EC2 instances\cr
\link[=elb_create_app_cookie_stickiness_policy]{create_app_cookie_stickiness_policy} \tab Generates a stickiness policy with sticky session lifetimes that follow that of an application-generated cookie\cr
\link[=elb_create_lb_cookie_stickiness_policy]{create_lb_cookie_stickiness_policy} \tab Generates a stickiness policy with sticky session lifetimes controlled by the lifetime of the browser (user-agent) or a specified expiration period\cr
\link[=elb_create_load_balancer]{create_load_balancer} \tab Creates a Classic Load Balancer\cr
\link[=elb_create_load_balancer_listeners]{create_load_balancer_listeners} \tab Creates one or more listeners for the specified load balancer\cr
\link[=elb_create_load_balancer_policy]{create_load_balancer_policy} \tab Creates a policy with the specified attributes for the specified load balancer\cr
\link[=elb_delete_load_balancer]{delete_load_balancer} \tab Deletes the specified load balancer\cr
\link[=elb_delete_load_balancer_listeners]{delete_load_balancer_listeners} \tab Deletes the specified listeners from the specified load balancer\cr
\link[=elb_delete_load_balancer_policy]{delete_load_balancer_policy} \tab Deletes the specified policy from the specified load balancer\cr
\link[=elb_deregister_instances_from_load_balancer]{deregister_instances_from_load_balancer} \tab Deregisters the specified instances from the specified load balancer\cr
\link[=elb_describe_account_limits]{describe_account_limits} \tab Describes the current Elastic Load Balancing resource limits for your AWS account\cr
\link[=elb_describe_instance_health]{describe_instance_health} \tab Describes the state of the specified instances with respect to the specified load balancer\cr
\link[=elb_describe_load_balancer_attributes]{describe_load_balancer_attributes} \tab Describes the attributes for the specified load balancer\cr
\link[=elb_describe_load_balancer_policies]{describe_load_balancer_policies} \tab Describes the specified policies\cr
\link[=elb_describe_load_balancer_policy_types]{describe_load_balancer_policy_types} \tab Describes the specified load balancer policy types or all load balancer policy types\cr
\link[=elb_describe_load_balancers]{describe_load_balancers} \tab Describes the specified the load balancers\cr
\link[=elb_describe_tags]{describe_tags} \tab Describes the tags associated with the specified load balancers\cr
\link[=elb_detach_load_balancer_from_subnets]{detach_load_balancer_from_subnets} \tab Removes the specified subnets from the set of configured subnets for the load balancer\cr
\link[=elb_disable_availability_zones_for_load_balancer]{disable_availability_zones_for_load_balancer} \tab Removes the specified Availability Zones from the set of Availability Zones for the specified load balancer in EC2-Classic or a default VPC\cr
\link[=elb_enable_availability_zones_for_load_balancer]{enable_availability_zones_for_load_balancer} \tab Adds the specified Availability Zones to the set of Availability Zones for the specified load balancer in EC2-Classic or a default VPC\cr
\link[=elb_modify_load_balancer_attributes]{modify_load_balancer_attributes} \tab Modifies the attributes of the specified load balancer\cr
\link[=elb_register_instances_with_load_balancer]{register_instances_with_load_balancer} \tab Adds the specified instances to the specified load balancer\cr
\link[=elb_remove_tags]{remove_tags} \tab Removes one or more tags from the specified load balancer\cr
\link[=elb_set_load_balancer_listener_ssl_certificate]{set_load_balancer_listener_ssl_certificate} \tab Sets the certificate that terminates the specified listener's SSL connections\cr
\link[=elb_set_load_balancer_policies_for_backend_server]{set_load_balancer_policies_for_backend_server} \tab Replaces the set of policies associated with the specified port on which the EC2 instance is listening with a new set of policies\cr
\link[=elb_set_load_balancer_policies_of_listener]{set_load_balancer_policies_of_listener} \tab Replaces the current set of policies for the specified load balancer port with the specified set of policies
}
}

\examples{
\dontrun{
svc <- elb()
# This example adds two tags to the specified load balancer.
svc$add_tags(
  LoadBalancerNames = list(
    "my-load-balancer"
  ),
  Tags = list(
    list(
      Key = "project",
      Value = "lima"
    ),
    list(
      Key = "department",
      Value = "digital-media"
    )
  )
)
}

}
