% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elbv2_operations.R
\name{elbv2_modify_rule}
\alias{elbv2_modify_rule}
\title{Replaces the specified properties of the specified rule}
\usage{
elbv2_modify_rule(RuleArn, Conditions, Actions)
}
\arguments{
\item{RuleArn}{[required] The Amazon Resource Name (ARN) of the rule.}

\item{Conditions}{The conditions.}

\item{Actions}{The actions.}
}
\value{
A list with the following syntax:\preformatted{list(
  Rules = list(
    list(
      RuleArn = "string",
      Priority = "string",
      Conditions = list(
        list(
          Field = "string",
          Values = list(
            "string"
          ),
          HostHeaderConfig = list(
            Values = list(
              "string"
            )
          ),
          PathPatternConfig = list(
            Values = list(
              "string"
            )
          ),
          HttpHeaderConfig = list(
            HttpHeaderName = "string",
            Values = list(
              "string"
            )
          ),
          QueryStringConfig = list(
            Values = list(
              list(
                Key = "string",
                Value = "string"
              )
            )
          ),
          HttpRequestMethodConfig = list(
            Values = list(
              "string"
            )
          ),
          SourceIpConfig = list(
            Values = list(
              "string"
            )
          )
        )
      ),
      Actions = list(
        list(
          Type = "forward"|"authenticate-oidc"|"authenticate-cognito"|"redirect"|"fixed-response",
          TargetGroupArn = "string",
          AuthenticateOidcConfig = list(
            Issuer = "string",
            AuthorizationEndpoint = "string",
            TokenEndpoint = "string",
            UserInfoEndpoint = "string",
            ClientId = "string",
            ClientSecret = "string",
            SessionCookieName = "string",
            Scope = "string",
            SessionTimeout = 123,
            AuthenticationRequestExtraParams = list(
              "string"
            ),
            OnUnauthenticatedRequest = "deny"|"allow"|"authenticate",
            UseExistingClientSecret = TRUE|FALSE
          ),
          AuthenticateCognitoConfig = list(
            UserPoolArn = "string",
            UserPoolClientId = "string",
            UserPoolDomain = "string",
            SessionCookieName = "string",
            Scope = "string",
            SessionTimeout = 123,
            AuthenticationRequestExtraParams = list(
              "string"
            ),
            OnUnauthenticatedRequest = "deny"|"allow"|"authenticate"
          ),
          Order = 123,
          RedirectConfig = list(
            Protocol = "string",
            Port = "string",
            Host = "string",
            Path = "string",
            Query = "string",
            StatusCode = "HTTP_301"|"HTTP_302"
          ),
          FixedResponseConfig = list(
            MessageBody = "string",
            StatusCode = "string",
            ContentType = "string"
          ),
          ForwardConfig = list(
            TargetGroups = list(
              list(
                TargetGroupArn = "string",
                Weight = 123
              )
            ),
            TargetGroupStickinessConfig = list(
              Enabled = TRUE|FALSE,
              DurationSeconds = 123
            )
          )
        )
      ),
      IsDefault = TRUE|FALSE
    )
  )
)
}
}
\description{
Replaces the specified properties of the specified rule. Any properties
that you do not specify are unchanged.

To add an item to a list, remove an item from a list, or update an item
in a list, you must provide the entire list. For example, to add an
action, specify a list with the current actions plus the new action.
}
\section{Request syntax}{
\preformatted{svc$modify_rule(
  RuleArn = "string",
  Conditions = list(
    list(
      Field = "string",
      Values = list(
        "string"
      ),
      HostHeaderConfig = list(
        Values = list(
          "string"
        )
      ),
      PathPatternConfig = list(
        Values = list(
          "string"
        )
      ),
      HttpHeaderConfig = list(
        HttpHeaderName = "string",
        Values = list(
          "string"
        )
      ),
      QueryStringConfig = list(
        Values = list(
          list(
            Key = "string",
            Value = "string"
          )
        )
      ),
      HttpRequestMethodConfig = list(
        Values = list(
          "string"
        )
      ),
      SourceIpConfig = list(
        Values = list(
          "string"
        )
      )
    )
  ),
  Actions = list(
    list(
      Type = "forward"|"authenticate-oidc"|"authenticate-cognito"|"redirect"|"fixed-response",
      TargetGroupArn = "string",
      AuthenticateOidcConfig = list(
        Issuer = "string",
        AuthorizationEndpoint = "string",
        TokenEndpoint = "string",
        UserInfoEndpoint = "string",
        ClientId = "string",
        ClientSecret = "string",
        SessionCookieName = "string",
        Scope = "string",
        SessionTimeout = 123,
        AuthenticationRequestExtraParams = list(
          "string"
        ),
        OnUnauthenticatedRequest = "deny"|"allow"|"authenticate",
        UseExistingClientSecret = TRUE|FALSE
      ),
      AuthenticateCognitoConfig = list(
        UserPoolArn = "string",
        UserPoolClientId = "string",
        UserPoolDomain = "string",
        SessionCookieName = "string",
        Scope = "string",
        SessionTimeout = 123,
        AuthenticationRequestExtraParams = list(
          "string"
        ),
        OnUnauthenticatedRequest = "deny"|"allow"|"authenticate"
      ),
      Order = 123,
      RedirectConfig = list(
        Protocol = "string",
        Port = "string",
        Host = "string",
        Path = "string",
        Query = "string",
        StatusCode = "HTTP_301"|"HTTP_302"
      ),
      FixedResponseConfig = list(
        MessageBody = "string",
        StatusCode = "string",
        ContentType = "string"
      ),
      ForwardConfig = list(
        TargetGroups = list(
          list(
            TargetGroupArn = "string",
            Weight = 123
          )
        ),
        TargetGroupStickinessConfig = list(
          Enabled = TRUE|FALSE,
          DurationSeconds = 123
        )
      )
    )
  )
)
}
}

\examples{
\dontrun{
# This example modifies the condition for the specified rule.
svc$modify_rule(
  Conditions = list(
    list(
      Field = "path-pattern",
      Values = list(
        "/images/*"
      )
    )
  ),
  RuleArn = "arn:aws:elasticloadbalancing:us-west-2:123456789012:listener-r..."
)
}

}
\keyword{internal}
