% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elbv2_operations.R
\name{elbv2_remove_listener_certificates}
\alias{elbv2_remove_listener_certificates}
\title{Removes the specified certificate from the certificate list for the
specified HTTPS listener}
\usage{
elbv2_remove_listener_certificates(ListenerArn, Certificates)
}
\arguments{
\item{ListenerArn}{[required] The Amazon Resource Name (ARN) of the listener.}

\item{Certificates}{[required] The certificate to remove. You can specify one certificate per call. Set
\code{CertificateArn} to the certificate ARN but do not set \code{IsDefault}.}
}
\description{
Removes the specified certificate from the certificate list for the
specified HTTPS listener.
}
\details{
You can't remove the default certificate for a listener. To replace the
default certificate, call ModifyListener.

To list the certificates for your listener, use
DescribeListenerCertificates.
}
\section{Request syntax}{
\preformatted{svc$remove_listener_certificates(
  ListenerArn = "string",
  Certificates = list(
    list(
      CertificateArn = "string",
      IsDefault = TRUE|FALSE
    )
  )
)
}
}

\keyword{internal}
