% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elbv2_operations.R
\name{elbv2_create_listener}
\alias{elbv2_create_listener}
\title{Creates a listener for the specified Application Load Balancer or
Network Load Balancer}
\usage{
elbv2_create_listener(LoadBalancerArn, Protocol, Port, SslPolicy,
  Certificates, DefaultActions)
}
\arguments{
\item{LoadBalancerArn}{[required] The Amazon Resource Name (ARN) of the load balancer.}

\item{Protocol}{[required] The protocol for connections from clients to the load balancer. For
Application Load Balancers, the supported protocols are HTTP and HTTPS.
For Network Load Balancers, the supported protocols are TCP, TLS, UDP,
and TCP\\_UDP.}

\item{Port}{[required] The port on which the load balancer is listening.}

\item{SslPolicy}{[HTTPS and TLS listeners] The security policy that defines which
ciphers and protocols are supported. The default is the current
predefined security policy.}

\item{Certificates}{[HTTPS and TLS listeners] The default certificate for the listener.
You must provide exactly one certificate. Set \code{CertificateArn} to the
certificate ARN but do not set \code{IsDefault}.

To create a certificate list for the listener, use
AddListenerCertificates.}

\item{DefaultActions}{[required] The actions for the default rule. The rule must include one forward
action or one or more fixed-response actions.

If the action type is \code{forward}, you specify one or more target groups.
The protocol of the target group must be HTTP or HTTPS for an
Application Load Balancer. The protocol of the target group must be TCP,
TLS, UDP, or TCP\\_UDP for a Network Load Balancer.

[HTTPS listeners] If the action type is \code{authenticate-oidc}, you
authenticate users through an identity provider that is OpenID Connect
(OIDC) compliant.

[HTTPS listeners] If the action type is \code{authenticate-cognito}, you
authenticate users through the user pools supported by Amazon Cognito.

[Application Load Balancer] If the action type is \code{redirect}, you
redirect specified client requests from one URL to another.

[Application Load Balancer] If the action type is \code{fixed-response},
you drop specified client requests and return a custom HTTP response.}
}
\description{
Creates a listener for the specified Application Load Balancer or
Network Load Balancer.
}
\details{
To update a listener, use ModifyListener. When you are finished with a
listener, you can delete it using DeleteListener. If you are finished
with both the listener and the load balancer, you can delete them both
using DeleteLoadBalancer.

This operation is idempotent, which means that it completes at most one
time. If you attempt to create multiple listeners with the same
settings, each call succeeds.

For more information, see \href{https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html}{Listeners for Your Application Load Balancers}
in the \emph{Application Load Balancers Guide} and \href{https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-listeners.html}{Listeners for Your Network Load Balancers}
in the \emph{Network Load Balancers Guide}.
}
\section{Request syntax}{
\preformatted{svc$create_listener(
  LoadBalancerArn = "string",
  Protocol = "HTTP"|"HTTPS"|"TCP"|"TLS"|"UDP"|"TCP_UDP",
  Port = 123,
  SslPolicy = "string",
  Certificates = list(
    list(
      CertificateArn = "string",
      IsDefault = TRUE|FALSE
    )
  ),
  DefaultActions = list(
    list(
      Type = "forward"|"authenticate-oidc"|"authenticate-cognito"|"redirect"|"fixed-response",
      TargetGroupArn = "string",
      AuthenticateOidcConfig = list(
        Issuer = "string",
        AuthorizationEndpoint = "string",
        TokenEndpoint = "string",
        UserInfoEndpoint = "string",
        ClientId = "string",
        ClientSecret = "string",
        SessionCookieName = "string",
        Scope = "string",
        SessionTimeout = 123,
        AuthenticationRequestExtraParams = list(
          "string"
        ),
        OnUnauthenticatedRequest = "deny"|"allow"|"authenticate",
        UseExistingClientSecret = TRUE|FALSE
      ),
      AuthenticateCognitoConfig = list(
        UserPoolArn = "string",
        UserPoolClientId = "string",
        UserPoolDomain = "string",
        SessionCookieName = "string",
        Scope = "string",
        SessionTimeout = 123,
        AuthenticationRequestExtraParams = list(
          "string"
        ),
        OnUnauthenticatedRequest = "deny"|"allow"|"authenticate"
      ),
      Order = 123,
      RedirectConfig = list(
        Protocol = "string",
        Port = "string",
        Host = "string",
        Path = "string",
        Query = "string",
        StatusCode = "HTTP_301"|"HTTP_302"
      ),
      FixedResponseConfig = list(
        MessageBody = "string",
        StatusCode = "string",
        ContentType = "string"
      ),
      ForwardConfig = list(
        TargetGroups = list(
          list(
            TargetGroupArn = "string",
            Weight = 123
          )
        ),
        TargetGroupStickinessConfig = list(
          Enabled = TRUE|FALSE,
          DurationSeconds = 123
        )
      )
    )
  )
)
}
}

\examples{
# This example creates an HTTP listener for the specified load balancer
# that forwards requests to the specified target group.
\dontrun{svc$create_listener(
  DefaultActions = list(
    list(
      TargetGroupArn = "arn:aws:elasticloadbalancing:us-west-2:123456789012:targetgroup/my-t...",
      Type = "forward"
    )
  ),
  LoadBalancerArn = "arn:aws:elasticloadbalancing:us-west-2:123456789012:loadbalancer/app/my...",
  Port = 80L,
  Protocol = "HTTP"
)}

# This example creates an HTTPS listener for the specified load balancer
# that forwards requests to the specified target group. Note that you must
# specify an SSL certificate for an HTTPS listener. You can create and
# manage certificates using AWS Certificate Manager (ACM). Alternatively,
# you can create a certificate using SSL/TLS tools, get the certificate
# signed by a certificate authority (CA), and upload the certificate to
# AWS Identity and Access Management (IAM).
\dontrun{svc$create_listener(
  Certificates = list(
    list(
      CertificateArn = "arn:aws:iam::123456789012:server-certificate/my-server-cert"
    )
  ),
  DefaultActions = list(
    list(
      TargetGroupArn = "arn:aws:elasticloadbalancing:us-west-2:123456789012:targetgroup/my-t...",
      Type = "forward"
    )
  ),
  LoadBalancerArn = "arn:aws:elasticloadbalancing:us-west-2:123456789012:loadbalancer/app/my...",
  Port = 443L,
  Protocol = "HTTPS",
  SslPolicy = "ELBSecurityPolicy-2015-05"
)}

}
\keyword{internal}
