% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elbv2_operations.R
\name{elbv2_modify_target_group}
\alias{elbv2_modify_target_group}
\title{Modifies the health checks used when evaluating the health state of the
targets in the specified target group}
\usage{
elbv2_modify_target_group(TargetGroupArn, HealthCheckProtocol,
  HealthCheckPort, HealthCheckPath, HealthCheckEnabled,
  HealthCheckIntervalSeconds, HealthCheckTimeoutSeconds,
  HealthyThresholdCount, UnhealthyThresholdCount, Matcher)
}
\arguments{
\item{TargetGroupArn}{[required] The Amazon Resource Name (ARN) of the target group.}

\item{HealthCheckProtocol}{The protocol the load balancer uses when performing health checks on
targets. The TCP protocol is supported for health checks only if the
protocol of the target group is TCP, TLS, UDP, or TCP\\_UDP. The TLS,
UDP, and TCP\\_UDP protocols are not supported for health checks.

With Network Load Balancers, you can\'t modify this setting.}

\item{HealthCheckPort}{The port the load balancer uses when performing health checks on
targets.}

\item{HealthCheckPath}{[HTTP/HTTPS health checks] The ping path that is the destination for
the health check request.}

\item{HealthCheckEnabled}{Indicates whether health checks are enabled.}

\item{HealthCheckIntervalSeconds}{The approximate amount of time, in seconds, between health checks of an
individual target. For Application Load Balancers, the range is 5 to 300
seconds. For Network Load Balancers, the supported values are 10 or 30
seconds.

With Network Load Balancers, you can\'t modify this setting.}

\item{HealthCheckTimeoutSeconds}{[HTTP/HTTPS health checks] The amount of time, in seconds, during
which no response means a failed health check.

With Network Load Balancers, you can\'t modify this setting.}

\item{HealthyThresholdCount}{The number of consecutive health checks successes required before
considering an unhealthy target healthy.}

\item{UnhealthyThresholdCount}{The number of consecutive health check failures required before
considering the target unhealthy. For Network Load Balancers, this value
must be the same as the healthy threshold count.}

\item{Matcher}{[HTTP/HTTPS health checks] The HTTP codes to use when checking for a
successful response from a target.

With Network Load Balancers, you can\'t modify this setting.}
}
\description{
Modifies the health checks used when evaluating the health state of the
targets in the specified target group.
}
\details{
To monitor the health of the targets, use DescribeTargetHealth.
}
\section{Request syntax}{
\preformatted{svc$modify_target_group(
  TargetGroupArn = "string",
  HealthCheckProtocol = "HTTP"|"HTTPS"|"TCP"|"TLS"|"UDP"|"TCP_UDP",
  HealthCheckPort = "string",
  HealthCheckPath = "string",
  HealthCheckEnabled = TRUE|FALSE,
  HealthCheckIntervalSeconds = 123,
  HealthCheckTimeoutSeconds = 123,
  HealthyThresholdCount = 123,
  UnhealthyThresholdCount = 123,
  Matcher = list(
    HttpCode = "string"
  )
)
}
}

\examples{
\dontrun{
# This example changes the configuration of the health checks used to
# evaluate the health of the targets for the specified target group.
svc$modify_target_group(
  HealthCheckPort = "443",
  HealthCheckProtocol = "HTTPS",
  TargetGroupArn = "arn:aws:elasticloadbalancing:us-west-2:123456789012:targetgroup/my-https..."
)
}

}
\keyword{internal}
