% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apigateway_operations.R
\name{apigateway_put_integration}
\alias{apigateway_put_integration}
\title{Sets up a method's integration}
\usage{
apigateway_put_integration(
  restApiId,
  resourceId,
  httpMethod,
  type,
  integrationHttpMethod = NULL,
  uri = NULL,
  connectionType = NULL,
  connectionId = NULL,
  credentials = NULL,
  requestParameters = NULL,
  requestTemplates = NULL,
  passthroughBehavior = NULL,
  cacheNamespace = NULL,
  cacheKeyParameters = NULL,
  contentHandling = NULL,
  timeoutInMillis = NULL,
  tlsConfig = NULL
)
}
\arguments{
\item{restApiId}{[required] The string identifier of the associated RestApi.}

\item{resourceId}{[required] Specifies a put integration request's resource ID.}

\item{httpMethod}{[required] Specifies the HTTP method for the integration.}

\item{type}{[required] Specifies a put integration input's type.}

\item{integrationHttpMethod}{The HTTP method for the integration.}

\item{uri}{Specifies Uniform Resource Identifier (URI) of the integration endpoint.
For HTTP or \code{HTTP_PROXY} integrations, the URI must be a fully formed,
encoded HTTP(S) URL according to the RFC-3986 specification, for either
standard integration, where \code{connectionType} is not \code{VPC_LINK}, or
private integration, where \code{connectionType} is \code{VPC_LINK}. For a private
HTTP integration, the URI is not used for routing. For \code{AWS} or
\code{AWS_PROXY} integrations, the URI is of the form
\verb{arn:aws:apigateway:\\\{region\\\}:\\\{subdomain.service|service\\\}:path|action/\\\{service_api}\}.
Here, \{Region\} is the API Gateway region (e.g., us-east-1);
\{service\} is the name of the integrated Amazon Web Services service
(e.g., s3); and \{subdomain\} is a designated subdomain supported by
certain Amazon Web Services service for fast host-name lookup. action
can be used for an Amazon Web Services service action-based API, using
an Action=\{name\}&\{p1\}=\{v1\}&p2=\{v2\}... query string. The
ensuing \{service_api\} refers to a supported action \{name\} plus
any required input parameters. Alternatively, path can be used for an
Amazon Web Services service path-based API. The ensuing service_api
refers to the path to an Amazon Web Services service resource, including
the region of the integrated Amazon Web Services service, if applicable.
For example, for integration with the S3 API of \code{GetObject}, the \code{uri}
can be either
\code{arn:aws:apigateway:us-west-2:s3:action/GetObject&Bucket={bucket}&Key={key}}
or \code{arn:aws:apigateway:us-west-2:s3:path/{bucket}/{key}}.}

\item{connectionType}{The type of the network connection to the integration endpoint. The
valid value is \code{INTERNET} for connections through the public routable
internet or \code{VPC_LINK} for private connections between API Gateway and a
network load balancer in a VPC. The default value is \code{INTERNET}.}

\item{connectionId}{The ID of the VpcLink used for the integration. Specify this value only
if you specify \code{VPC_LINK} as the connection type.}

\item{credentials}{Specifies whether credentials are required for a put integration.}

\item{requestParameters}{A key-value map specifying request parameters that are passed from the
method request to the back end. The key is an integration request
parameter name and the associated value is a method request parameter
value or static value that must be enclosed within single quotes and
pre-encoded as required by the back end. The method request parameter
value must match the pattern of \verb{method.request.\{location\}.\{name\}},
where \code{location} is \code{querystring}, \code{path}, or \code{header} and \code{name} must
be a valid and unique method request parameter name.}

\item{requestTemplates}{Represents a map of Velocity templates that are applied on the request
payload based on the value of the Content-Type header sent by the
client. The content type value is the key in this map, and the template
(as a String) is the value.}

\item{passthroughBehavior}{Specifies the pass-through behavior for incoming requests based on the
Content-Type header in the request, and the available mapping templates
specified as the \code{requestTemplates} property on the Integration
resource. There are three valid values: \code{WHEN_NO_MATCH},
\code{WHEN_NO_TEMPLATES}, and \code{NEVER}.}

\item{cacheNamespace}{Specifies a group of related cached parameters. By default, API Gateway
uses the resource ID as the \code{cacheNamespace}. You can specify the same
\code{cacheNamespace} across resources to return the same cached data for
requests to different resources.}

\item{cacheKeyParameters}{A list of request parameters whose values API Gateway caches. To be
valid values for \code{cacheKeyParameters}, these parameters must also be
specified for Method \code{requestParameters}.}

\item{contentHandling}{Specifies how to handle request payload content type conversions.
Supported values are \code{CONVERT_TO_BINARY} and \code{CONVERT_TO_TEXT}, with the
following behaviors:

If this property is not defined, the request payload will be passed
through from the method request to integration request without
modification, provided that the \code{passthroughBehavior} is configured to
support payload pass-through.}

\item{timeoutInMillis}{Custom timeout between 50 and 29,000 milliseconds. The default value is
29,000 milliseconds or 29 seconds.}

\item{tlsConfig}{}
}
\description{
Sets up a method's integration.

See \url{https://paws-r.github.io/docs/apigateway/put_integration.html} for full documentation.
}
\keyword{internal}
