% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/networkfirewall_operations.R
\name{networkfirewall_list_firewalls}
\alias{networkfirewall_list_firewalls}
\title{Retrieves the metadata for the firewalls that you have defined}
\usage{
networkfirewall_list_firewalls(
  NextToken = NULL,
  VpcIds = NULL,
  MaxResults = NULL
)
}
\arguments{
\item{NextToken}{When you request a list of objects with a \code{MaxResults} setting, if the
number of objects that are still available for retrieval exceeds the
maximum you requested, Network Firewall returns a \code{NextToken} value in
the response. To retrieve the next batch of objects, use the token
returned from the prior request in your next request.}

\item{VpcIds}{The unique identifiers of the VPCs that you want Network Firewall to
retrieve the firewalls for. Leave this blank to retrieve all firewalls
that you have defined.}

\item{MaxResults}{The maximum number of objects that you want Network Firewall to return
for this request. If more objects are available, in the response,
Network Firewall provides a \code{NextToken} value that you can use in a
subsequent call to get the next batch of objects.}
}
\description{
Retrieves the metadata for the firewalls that you have defined. If you provide VPC identifiers in your request, this returns only the firewalls for those VPCs.

See \url{https://paws-r.github.io/docs/networkfirewall/list_firewalls.html} for full documentation.
}
\keyword{internal}
