% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/networkfirewall_operations.R
\name{networkfirewall_list_rule_groups}
\alias{networkfirewall_list_rule_groups}
\title{Retrieves the metadata for the rule groups that you have defined}
\usage{
networkfirewall_list_rule_groups(
  NextToken = NULL,
  MaxResults = NULL,
  Scope = NULL,
  ManagedType = NULL,
  Type = NULL
)
}
\arguments{
\item{NextToken}{When you request a list of objects with a \code{MaxResults} setting, if the
number of objects that are still available for retrieval exceeds the
maximum you requested, Network Firewall returns a \code{NextToken} value in
the response. To retrieve the next batch of objects, use the token
returned from the prior request in your next request.}

\item{MaxResults}{The maximum number of objects that you want Network Firewall to return
for this request. If more objects are available, in the response,
Network Firewall provides a \code{NextToken} value that you can use in a
subsequent call to get the next batch of objects.}

\item{Scope}{The scope of the request. The default setting of \code{ACCOUNT} or a setting
of \code{NULL} returns all of the rule groups in your account. A setting of
\code{MANAGED} returns all available managed rule groups.}

\item{ManagedType}{Indicates the general category of the Amazon Web Services managed rule
group.}

\item{Type}{Indicates whether the rule group is stateless or stateful. If the rule
group is stateless, it contains stateless rules. If it is stateful, it
contains stateful rules.}
}
\description{
Retrieves the metadata for the rule groups that you have defined. Depending on your setting for max results and the number of rule groups, a single call might not return the full list.

See \url{https://paws-r.github.io/docs/networkfirewall/list_rule_groups.html} for full documentation.
}
\keyword{internal}
