% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/route53_operations.R
\name{route53_list_resource_record_sets}
\alias{route53_list_resource_record_sets}
\title{Lists the resource record sets in a specified hosted zone}
\usage{
route53_list_resource_record_sets(
  HostedZoneId,
  StartRecordName = NULL,
  StartRecordType = NULL,
  StartRecordIdentifier = NULL,
  MaxItems = NULL
)
}
\arguments{
\item{HostedZoneId}{[required] The ID of the hosted zone that contains the resource record sets that
you want to list.}

\item{StartRecordName}{The first name in the lexicographic ordering of resource record sets
that you want to list. If the specified record name doesn't exist, the
results begin with the first resource record set that has a name greater
than the value of \code{name}.}

\item{StartRecordType}{The type of resource record set to begin the record listing from.

Valid values for basic resource record sets: \code{A} | \code{AAAA} | \code{CAA} |
\code{CNAME} | \code{MX} | \code{NAPTR} | \code{NS} | \code{PTR} | \code{SOA} | \code{SPF} | \code{SRV} | \code{TXT}

Values for weighted, latency, geolocation, and failover resource record
sets: \code{A} | \code{AAAA} | \code{CAA} | \code{CNAME} | \code{MX} | \code{NAPTR} | \code{PTR} | \code{SPF} |
\code{SRV} | \code{TXT}

Values for alias resource record sets:
\itemize{
\item \strong{API Gateway custom regional API or edge-optimized API}: A
\item \strong{CloudFront distribution}: A or AAAA
\item \strong{Elastic Beanstalk environment that has a regionalized subdomain}:
A
\item \strong{Elastic Load Balancing load balancer}: A | AAAA
\item \strong{S3 bucket}: A
\item \strong{VPC interface VPC endpoint}: A
\item \strong{Another resource record set in this hosted zone:} The type of the
resource record set that the alias references.
}

Constraint: Specifying \code{type} without specifying \code{name} returns an
\code{InvalidInput} error.}

\item{StartRecordIdentifier}{\emph{Resource record sets that have a routing policy other than simple:} If
results were truncated for a given DNS name and type, specify the value
of \code{NextRecordIdentifier} from the previous response to get the next
resource record set that has the current DNS name and type.}

\item{MaxItems}{(Optional) The maximum number of resource records sets to include in the
response body for this request. If the response includes more than
\code{maxitems} resource record sets, the value of the \code{IsTruncated} element
in the response is \code{true}, and the values of the \code{NextRecordName} and
\code{NextRecordType} elements in the response identify the first resource
record set in the next group of \code{maxitems} resource record sets.}
}
\description{
Lists the resource record sets in a specified hosted zone.

See \url{https://paws-r.github.io/docs/route53/list_resource_record_sets.html} for full documentation.
}
\keyword{internal}
