# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include elbv2_service.R
NULL

#' Adds the specified SSL server certificate to the certificate list for
#' the specified HTTPS or TLS listener
#'
#' @description
#' Adds the specified SSL server certificate to the certificate list for the specified HTTPS or TLS listener.
#'
#' See [https://www.paws-r-sdk.com/docs/elbv2_add_listener_certificates/](https://www.paws-r-sdk.com/docs/elbv2_add_listener_certificates/) for full documentation.
#'
#' @param ListenerArn &#91;required&#93; The Amazon Resource Name (ARN) of the listener.
#' @param Certificates &#91;required&#93; The certificate to add. You can specify one certificate per call. Set
#' `CertificateArn` to the certificate ARN but do not set `IsDefault`.
#'
#' @keywords internal
#'
#' @rdname elbv2_add_listener_certificates
elbv2_add_listener_certificates <- function(ListenerArn, Certificates) {
  op <- new_operation(
    name = "AddListenerCertificates",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elbv2$add_listener_certificates_input(ListenerArn = ListenerArn, Certificates = Certificates)
  output <- .elbv2$add_listener_certificates_output()
  config <- get_config()
  svc <- .elbv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elbv2$operations$add_listener_certificates <- elbv2_add_listener_certificates

#' Adds the specified tags to the specified Elastic Load Balancing resource
#'
#' @description
#' Adds the specified tags to the specified Elastic Load Balancing resource. You can tag your Application Load Balancers, Network Load Balancers, Gateway Load Balancers, target groups, listeners, and rules.
#'
#' See [https://www.paws-r-sdk.com/docs/elbv2_add_tags/](https://www.paws-r-sdk.com/docs/elbv2_add_tags/) for full documentation.
#'
#' @param ResourceArns &#91;required&#93; The Amazon Resource Name (ARN) of the resource.
#' @param Tags &#91;required&#93; The tags.
#'
#' @keywords internal
#'
#' @rdname elbv2_add_tags
elbv2_add_tags <- function(ResourceArns, Tags) {
  op <- new_operation(
    name = "AddTags",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elbv2$add_tags_input(ResourceArns = ResourceArns, Tags = Tags)
  output <- .elbv2$add_tags_output()
  config <- get_config()
  svc <- .elbv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elbv2$operations$add_tags <- elbv2_add_tags

#' Creates a listener for the specified Application Load Balancer, Network
#' Load Balancer, or Gateway Load Balancer
#'
#' @description
#' Creates a listener for the specified Application Load Balancer, Network Load Balancer, or Gateway Load Balancer.
#'
#' See [https://www.paws-r-sdk.com/docs/elbv2_create_listener/](https://www.paws-r-sdk.com/docs/elbv2_create_listener/) for full documentation.
#'
#' @param LoadBalancerArn &#91;required&#93; The Amazon Resource Name (ARN) of the load balancer.
#' @param Protocol The protocol for connections from clients to the load balancer. For
#' Application Load Balancers, the supported protocols are HTTP and HTTPS.
#' For Network Load Balancers, the supported protocols are TCP, TLS, UDP,
#' and TCP_UDP. You can’t specify the UDP or TCP_UDP protocol if dual-stack
#' mode is enabled. You cannot specify a protocol for a Gateway Load
#' Balancer.
#' @param Port The port on which the load balancer is listening. You cannot specify a
#' port for a Gateway Load Balancer.
#' @param SslPolicy \[HTTPS and TLS listeners\] The security policy that defines which
#' protocols and ciphers are supported.
#' 
#' For more information, see [Security
#' policies](https://docs.aws.amazon.com/elasticloadbalancing/latest/application/create-https-listener.html#describe-ssl-policies)
#' in the *Application Load Balancers Guide* and [Security
#' policies](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html#describe-ssl-policies)
#' in the *Network Load Balancers Guide*.
#' @param Certificates \[HTTPS and TLS listeners\] The default certificate for the listener.
#' You must provide exactly one certificate. Set `CertificateArn` to the
#' certificate ARN but do not set `IsDefault`.
#' @param DefaultActions &#91;required&#93; The actions for the default rule.
#' @param AlpnPolicy \[TLS listeners\] The name of the Application-Layer Protocol Negotiation
#' (ALPN) policy. You can specify one policy name. The following are the
#' possible values:
#' 
#' -   `HTTP1Only`
#' 
#' -   `HTTP2Only`
#' 
#' -   `HTTP2Optional`
#' 
#' -   `HTTP2Preferred`
#' 
#' -   `None`
#' 
#' For more information, see [ALPN
#' policies](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html#alpn-policies)
#' in the *Network Load Balancers Guide*.
#' @param Tags The tags to assign to the listener.
#'
#' @keywords internal
#'
#' @rdname elbv2_create_listener
elbv2_create_listener <- function(LoadBalancerArn, Protocol = NULL, Port = NULL, SslPolicy = NULL, Certificates = NULL, DefaultActions, AlpnPolicy = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateListener",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elbv2$create_listener_input(LoadBalancerArn = LoadBalancerArn, Protocol = Protocol, Port = Port, SslPolicy = SslPolicy, Certificates = Certificates, DefaultActions = DefaultActions, AlpnPolicy = AlpnPolicy, Tags = Tags)
  output <- .elbv2$create_listener_output()
  config <- get_config()
  svc <- .elbv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elbv2$operations$create_listener <- elbv2_create_listener

#' Creates an Application Load Balancer, Network Load Balancer, or Gateway
#' Load Balancer
#'
#' @description
#' Creates an Application Load Balancer, Network Load Balancer, or Gateway Load Balancer.
#'
#' See [https://www.paws-r-sdk.com/docs/elbv2_create_load_balancer/](https://www.paws-r-sdk.com/docs/elbv2_create_load_balancer/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the load balancer.
#' 
#' This name must be unique per region per account, can have a maximum of
#' 32 characters, must contain only alphanumeric characters or hyphens,
#' must not begin or end with a hyphen, and must not begin with
#' "internal-".
#' @param Subnets The IDs of the public subnets. You can specify only one subnet per
#' Availability Zone. You must specify either subnets or subnet mappings,
#' but not both. To specify an Elastic IP address, specify subnet mappings
#' instead of subnets.
#' 
#' \[Application Load Balancers\] You must specify subnets from at least
#' two Availability Zones.
#' 
#' \[Application Load Balancers on Outposts\] You must specify one Outpost
#' subnet.
#' 
#' \[Application Load Balancers on Local Zones\] You can specify subnets
#' from one or more Local Zones.
#' 
#' \[Network Load Balancers\] You can specify subnets from one or more
#' Availability Zones.
#' 
#' \[Gateway Load Balancers\] You can specify subnets from one or more
#' Availability Zones.
#' @param SubnetMappings The IDs of the public subnets. You can specify only one subnet per
#' Availability Zone. You must specify either subnets or subnet mappings,
#' but not both.
#' 
#' \[Application Load Balancers\] You must specify subnets from at least
#' two Availability Zones. You cannot specify Elastic IP addresses for your
#' subnets.
#' 
#' \[Application Load Balancers on Outposts\] You must specify one Outpost
#' subnet.
#' 
#' \[Application Load Balancers on Local Zones\] You can specify subnets
#' from one or more Local Zones.
#' 
#' \[Network Load Balancers\] You can specify subnets from one or more
#' Availability Zones. You can specify one Elastic IP address per subnet if
#' you need static IP addresses for your internet-facing load balancer. For
#' internal load balancers, you can specify one private IP address per
#' subnet from the IPv4 range of the subnet. For internet-facing load
#' balancer, you can specify one IPv6 address per subnet.
#' 
#' \[Gateway Load Balancers\] You can specify subnets from one or more
#' Availability Zones. You cannot specify Elastic IP addresses for your
#' subnets.
#' @param SecurityGroups \[Application Load Balancers\] The IDs of the security groups for the
#' load balancer.
#' @param Scheme The nodes of an Internet-facing load balancer have public IP addresses.
#' The DNS name of an Internet-facing load balancer is publicly resolvable
#' to the public IP addresses of the nodes. Therefore, Internet-facing load
#' balancers can route requests from clients over the internet.
#' 
#' The nodes of an internal load balancer have only private IP addresses.
#' The DNS name of an internal load balancer is publicly resolvable to the
#' private IP addresses of the nodes. Therefore, internal load balancers
#' can route requests only from clients with access to the VPC for the load
#' balancer.
#' 
#' The default is an Internet-facing load balancer.
#' 
#' You cannot specify a scheme for a Gateway Load Balancer.
#' @param Tags The tags to assign to the load balancer.
#' @param Type The type of load balancer. The default is `application`.
#' @param IpAddressType The type of IP addresses used by the subnets for your load balancer. The
#' possible values are `ipv4` (for IPv4 addresses) and `dualstack` (for
#' IPv4 and IPv6 addresses).
#' @param CustomerOwnedIpv4Pool \[Application Load Balancers on Outposts\] The ID of the customer-owned
#' address pool (CoIP pool).
#'
#' @keywords internal
#'
#' @rdname elbv2_create_load_balancer
elbv2_create_load_balancer <- function(Name, Subnets = NULL, SubnetMappings = NULL, SecurityGroups = NULL, Scheme = NULL, Tags = NULL, Type = NULL, IpAddressType = NULL, CustomerOwnedIpv4Pool = NULL) {
  op <- new_operation(
    name = "CreateLoadBalancer",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elbv2$create_load_balancer_input(Name = Name, Subnets = Subnets, SubnetMappings = SubnetMappings, SecurityGroups = SecurityGroups, Scheme = Scheme, Tags = Tags, Type = Type, IpAddressType = IpAddressType, CustomerOwnedIpv4Pool = CustomerOwnedIpv4Pool)
  output <- .elbv2$create_load_balancer_output()
  config <- get_config()
  svc <- .elbv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elbv2$operations$create_load_balancer <- elbv2_create_load_balancer

#' Creates a rule for the specified listener
#'
#' @description
#' Creates a rule for the specified listener. The listener must be associated with an Application Load Balancer.
#'
#' See [https://www.paws-r-sdk.com/docs/elbv2_create_rule/](https://www.paws-r-sdk.com/docs/elbv2_create_rule/) for full documentation.
#'
#' @param ListenerArn &#91;required&#93; The Amazon Resource Name (ARN) of the listener.
#' @param Conditions &#91;required&#93; The conditions.
#' @param Priority &#91;required&#93; The rule priority. A listener can't have multiple rules with the same
#' priority.
#' @param Actions &#91;required&#93; The actions.
#' @param Tags The tags to assign to the rule.
#'
#' @keywords internal
#'
#' @rdname elbv2_create_rule
elbv2_create_rule <- function(ListenerArn, Conditions, Priority, Actions, Tags = NULL) {
  op <- new_operation(
    name = "CreateRule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elbv2$create_rule_input(ListenerArn = ListenerArn, Conditions = Conditions, Priority = Priority, Actions = Actions, Tags = Tags)
  output <- .elbv2$create_rule_output()
  config <- get_config()
  svc <- .elbv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elbv2$operations$create_rule <- elbv2_create_rule

#' Creates a target group
#'
#' @description
#' Creates a target group.
#'
#' See [https://www.paws-r-sdk.com/docs/elbv2_create_target_group/](https://www.paws-r-sdk.com/docs/elbv2_create_target_group/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the target group.
#' 
#' This name must be unique per region per account, can have a maximum of
#' 32 characters, must contain only alphanumeric characters or hyphens, and
#' must not begin or end with a hyphen.
#' @param Protocol The protocol to use for routing traffic to the targets. For Application
#' Load Balancers, the supported protocols are HTTP and HTTPS. For Network
#' Load Balancers, the supported protocols are TCP, TLS, UDP, or TCP_UDP.
#' For Gateway Load Balancers, the supported protocol is GENEVE. A TCP_UDP
#' listener must be associated with a TCP_UDP target group. If the target
#' is a Lambda function, this parameter does not apply.
#' @param ProtocolVersion \[HTTP/HTTPS protocol\] The protocol version. Specify `GRPC` to send
#' requests to targets using gRPC. Specify `HTTP2` to send requests to
#' targets using HTTP/2. The default is `HTTP1`, which sends requests to
#' targets using HTTP/1.1.
#' @param Port The port on which the targets receive traffic. This port is used unless
#' you specify a port override when registering the target. If the target
#' is a Lambda function, this parameter does not apply. If the protocol is
#' GENEVE, the supported port is 6081.
#' @param VpcId The identifier of the virtual private cloud (VPC). If the target is a
#' Lambda function, this parameter does not apply. Otherwise, this
#' parameter is required.
#' @param HealthCheckProtocol The protocol the load balancer uses when performing health checks on
#' targets. For Application Load Balancers, the default is HTTP. For
#' Network Load Balancers and Gateway Load Balancers, the default is TCP.
#' The TCP protocol is not supported for health checks if the protocol of
#' the target group is HTTP or HTTPS. The GENEVE, TLS, UDP, and TCP_UDP
#' protocols are not supported for health checks.
#' @param HealthCheckPort The port the load balancer uses when performing health checks on
#' targets. If the protocol is HTTP, HTTPS, TCP, TLS, UDP, or TCP_UDP, the
#' default is `traffic-port`, which is the port on which each target
#' receives traffic from the load balancer. If the protocol is GENEVE, the
#' default is port 80.
#' @param HealthCheckEnabled Indicates whether health checks are enabled. If the target type is
#' `lambda`, health checks are disabled by default but can be enabled. If
#' the target type is `instance`, `ip`, or `alb`, health checks are always
#' enabled and cannot be disabled.
#' @param HealthCheckPath \[HTTP/HTTPS health checks\] The destination for health checks on the
#' targets.
#' 
#' \[HTTP1 or HTTP2 protocol version\] The ping path. The default is /.
#' 
#' \[GRPC protocol version\] The path of a custom health check method with
#' the format /package.service/method. The default is /Amazon Web
#' Services.ALB/healthcheck.
#' @param HealthCheckIntervalSeconds The approximate amount of time, in seconds, between health checks of an
#' individual target. The range is 5-300. If the target group protocol is
#' TCP, TLS, UDP, TCP_UDP, HTTP or HTTPS, the default is 30 seconds. If the
#' target group protocol is GENEVE, the default is 10 seconds. If the
#' target type is `lambda`, the default is 35 seconds.
#' @param HealthCheckTimeoutSeconds The amount of time, in seconds, during which no response from a target
#' means a failed health check. The range is 2–120 seconds. For target
#' groups with a protocol of HTTP, the default is 6 seconds. For target
#' groups with a protocol of TCP, TLS or HTTPS, the default is 10 seconds.
#' For target groups with a protocol of GENEVE, the default is 5 seconds.
#' If the target type is `lambda`, the default is 30 seconds.
#' @param HealthyThresholdCount The number of consecutive health check successes required before
#' considering a target healthy. The range is 2-10. If the target group
#' protocol is TCP, TCP_UDP, UDP, TLS, HTTP or HTTPS, the default is 5. For
#' target groups with a protocol of GENEVE, the default is 5. If the target
#' type is `lambda`, the default is 5.
#' @param UnhealthyThresholdCount The number of consecutive health check failures required before
#' considering a target unhealthy. The range is 2-10. If the target group
#' protocol is TCP, TCP_UDP, UDP, TLS, HTTP or HTTPS, the default is 2. For
#' target groups with a protocol of GENEVE, the default is 2. If the target
#' type is `lambda`, the default is 5.
#' @param Matcher \[HTTP/HTTPS health checks\] The HTTP or gRPC codes to use when checking
#' for a successful response from a target. For target groups with a
#' protocol of TCP, TCP_UDP, UDP or TLS the range is 200-599. For target
#' groups with a protocol of HTTP or HTTPS, the range is 200-499. For
#' target groups with a protocol of GENEVE, the range is 200-399.
#' @param TargetType The type of target that you must specify when registering targets with
#' this target group. You can't specify targets for a target group using
#' more than one target type.
#' 
#' -   `instance` - Register targets by instance ID. This is the default
#'     value.
#' 
#' -   `ip` - Register targets by IP address. You can specify IP addresses
#'     from the subnets of the virtual private cloud (VPC) for the target
#'     group, the RFC 1918 range (10.0.0.0/8, 172.16.0.0/12, and
#'     192.168.0.0/16), and the RFC 6598 range (100.64.0.0/10). You can't
#'     specify publicly routable IP addresses.
#' 
#' -   `lambda` - Register a single Lambda function as a target.
#' 
#' -   `alb` - Register a single Application Load Balancer as a target.
#' @param Tags The tags to assign to the target group.
#' @param IpAddressType The type of IP address used for this target group. The possible values
#' are `ipv4` and `ipv6`. This is an optional parameter. If not specified,
#' the IP address type defaults to `ipv4`.
#'
#' @keywords internal
#'
#' @rdname elbv2_create_target_group
elbv2_create_target_group <- function(Name, Protocol = NULL, ProtocolVersion = NULL, Port = NULL, VpcId = NULL, HealthCheckProtocol = NULL, HealthCheckPort = NULL, HealthCheckEnabled = NULL, HealthCheckPath = NULL, HealthCheckIntervalSeconds = NULL, HealthCheckTimeoutSeconds = NULL, HealthyThresholdCount = NULL, UnhealthyThresholdCount = NULL, Matcher = NULL, TargetType = NULL, Tags = NULL, IpAddressType = NULL) {
  op <- new_operation(
    name = "CreateTargetGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elbv2$create_target_group_input(Name = Name, Protocol = Protocol, ProtocolVersion = ProtocolVersion, Port = Port, VpcId = VpcId, HealthCheckProtocol = HealthCheckProtocol, HealthCheckPort = HealthCheckPort, HealthCheckEnabled = HealthCheckEnabled, HealthCheckPath = HealthCheckPath, HealthCheckIntervalSeconds = HealthCheckIntervalSeconds, HealthCheckTimeoutSeconds = HealthCheckTimeoutSeconds, HealthyThresholdCount = HealthyThresholdCount, UnhealthyThresholdCount = UnhealthyThresholdCount, Matcher = Matcher, TargetType = TargetType, Tags = Tags, IpAddressType = IpAddressType)
  output <- .elbv2$create_target_group_output()
  config <- get_config()
  svc <- .elbv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elbv2$operations$create_target_group <- elbv2_create_target_group

#' Deletes the specified listener
#'
#' @description
#' Deletes the specified listener.
#'
#' See [https://www.paws-r-sdk.com/docs/elbv2_delete_listener/](https://www.paws-r-sdk.com/docs/elbv2_delete_listener/) for full documentation.
#'
#' @param ListenerArn &#91;required&#93; The Amazon Resource Name (ARN) of the listener.
#'
#' @keywords internal
#'
#' @rdname elbv2_delete_listener
elbv2_delete_listener <- function(ListenerArn) {
  op <- new_operation(
    name = "DeleteListener",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elbv2$delete_listener_input(ListenerArn = ListenerArn)
  output <- .elbv2$delete_listener_output()
  config <- get_config()
  svc <- .elbv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elbv2$operations$delete_listener <- elbv2_delete_listener

#' Deletes the specified Application Load Balancer, Network Load Balancer,
#' or Gateway Load Balancer
#'
#' @description
#' Deletes the specified Application Load Balancer, Network Load Balancer, or Gateway Load Balancer. Deleting a load balancer also deletes its listeners.
#'
#' See [https://www.paws-r-sdk.com/docs/elbv2_delete_load_balancer/](https://www.paws-r-sdk.com/docs/elbv2_delete_load_balancer/) for full documentation.
#'
#' @param LoadBalancerArn &#91;required&#93; The Amazon Resource Name (ARN) of the load balancer.
#'
#' @keywords internal
#'
#' @rdname elbv2_delete_load_balancer
elbv2_delete_load_balancer <- function(LoadBalancerArn) {
  op <- new_operation(
    name = "DeleteLoadBalancer",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elbv2$delete_load_balancer_input(LoadBalancerArn = LoadBalancerArn)
  output <- .elbv2$delete_load_balancer_output()
  config <- get_config()
  svc <- .elbv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elbv2$operations$delete_load_balancer <- elbv2_delete_load_balancer

#' Deletes the specified rule
#'
#' @description
#' Deletes the specified rule.
#'
#' See [https://www.paws-r-sdk.com/docs/elbv2_delete_rule/](https://www.paws-r-sdk.com/docs/elbv2_delete_rule/) for full documentation.
#'
#' @param RuleArn &#91;required&#93; The Amazon Resource Name (ARN) of the rule.
#'
#' @keywords internal
#'
#' @rdname elbv2_delete_rule
elbv2_delete_rule <- function(RuleArn) {
  op <- new_operation(
    name = "DeleteRule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elbv2$delete_rule_input(RuleArn = RuleArn)
  output <- .elbv2$delete_rule_output()
  config <- get_config()
  svc <- .elbv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elbv2$operations$delete_rule <- elbv2_delete_rule

#' Deletes the specified target group
#'
#' @description
#' Deletes the specified target group.
#'
#' See [https://www.paws-r-sdk.com/docs/elbv2_delete_target_group/](https://www.paws-r-sdk.com/docs/elbv2_delete_target_group/) for full documentation.
#'
#' @param TargetGroupArn &#91;required&#93; The Amazon Resource Name (ARN) of the target group.
#'
#' @keywords internal
#'
#' @rdname elbv2_delete_target_group
elbv2_delete_target_group <- function(TargetGroupArn) {
  op <- new_operation(
    name = "DeleteTargetGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elbv2$delete_target_group_input(TargetGroupArn = TargetGroupArn)
  output <- .elbv2$delete_target_group_output()
  config <- get_config()
  svc <- .elbv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elbv2$operations$delete_target_group <- elbv2_delete_target_group

#' Deregisters the specified targets from the specified target group
#'
#' @description
#' Deregisters the specified targets from the specified target group. After the targets are deregistered, they no longer receive traffic from the load balancer.
#'
#' See [https://www.paws-r-sdk.com/docs/elbv2_deregister_targets/](https://www.paws-r-sdk.com/docs/elbv2_deregister_targets/) for full documentation.
#'
#' @param TargetGroupArn &#91;required&#93; The Amazon Resource Name (ARN) of the target group.
#' @param Targets &#91;required&#93; The targets. If you specified a port override when you registered a
#' target, you must specify both the target ID and the port when you
#' deregister it.
#'
#' @keywords internal
#'
#' @rdname elbv2_deregister_targets
elbv2_deregister_targets <- function(TargetGroupArn, Targets) {
  op <- new_operation(
    name = "DeregisterTargets",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elbv2$deregister_targets_input(TargetGroupArn = TargetGroupArn, Targets = Targets)
  output <- .elbv2$deregister_targets_output()
  config <- get_config()
  svc <- .elbv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elbv2$operations$deregister_targets <- elbv2_deregister_targets

#' Describes the current Elastic Load Balancing resource limits for your
#' Amazon Web Services account
#'
#' @description
#' Describes the current Elastic Load Balancing resource limits for your Amazon Web Services account.
#'
#' See [https://www.paws-r-sdk.com/docs/elbv2_describe_account_limits/](https://www.paws-r-sdk.com/docs/elbv2_describe_account_limits/) for full documentation.
#'
#' @param Marker The marker for the next set of results. (You received this marker from a
#' previous call.)
#' @param PageSize The maximum number of results to return with this call.
#'
#' @keywords internal
#'
#' @rdname elbv2_describe_account_limits
elbv2_describe_account_limits <- function(Marker = NULL, PageSize = NULL) {
  op <- new_operation(
    name = "DescribeAccountLimits",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elbv2$describe_account_limits_input(Marker = Marker, PageSize = PageSize)
  output <- .elbv2$describe_account_limits_output()
  config <- get_config()
  svc <- .elbv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elbv2$operations$describe_account_limits <- elbv2_describe_account_limits

#' Describes the default certificate and the certificate list for the
#' specified HTTPS or TLS listener
#'
#' @description
#' Describes the default certificate and the certificate list for the specified HTTPS or TLS listener.
#'
#' See [https://www.paws-r-sdk.com/docs/elbv2_describe_listener_certificates/](https://www.paws-r-sdk.com/docs/elbv2_describe_listener_certificates/) for full documentation.
#'
#' @param ListenerArn &#91;required&#93; The Amazon Resource Names (ARN) of the listener.
#' @param Marker The marker for the next set of results. (You received this marker from a
#' previous call.)
#' @param PageSize The maximum number of results to return with this call.
#'
#' @keywords internal
#'
#' @rdname elbv2_describe_listener_certificates
elbv2_describe_listener_certificates <- function(ListenerArn, Marker = NULL, PageSize = NULL) {
  op <- new_operation(
    name = "DescribeListenerCertificates",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elbv2$describe_listener_certificates_input(ListenerArn = ListenerArn, Marker = Marker, PageSize = PageSize)
  output <- .elbv2$describe_listener_certificates_output()
  config <- get_config()
  svc <- .elbv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elbv2$operations$describe_listener_certificates <- elbv2_describe_listener_certificates

#' Describes the specified listeners or the listeners for the specified
#' Application Load Balancer, Network Load Balancer, or Gateway Load
#' Balancer
#'
#' @description
#' Describes the specified listeners or the listeners for the specified Application Load Balancer, Network Load Balancer, or Gateway Load Balancer. You must specify either a load balancer or one or more listeners.
#'
#' See [https://www.paws-r-sdk.com/docs/elbv2_describe_listeners/](https://www.paws-r-sdk.com/docs/elbv2_describe_listeners/) for full documentation.
#'
#' @param LoadBalancerArn The Amazon Resource Name (ARN) of the load balancer.
#' @param ListenerArns The Amazon Resource Names (ARN) of the listeners.
#' @param Marker The marker for the next set of results. (You received this marker from a
#' previous call.)
#' @param PageSize The maximum number of results to return with this call.
#'
#' @keywords internal
#'
#' @rdname elbv2_describe_listeners
elbv2_describe_listeners <- function(LoadBalancerArn = NULL, ListenerArns = NULL, Marker = NULL, PageSize = NULL) {
  op <- new_operation(
    name = "DescribeListeners",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elbv2$describe_listeners_input(LoadBalancerArn = LoadBalancerArn, ListenerArns = ListenerArns, Marker = Marker, PageSize = PageSize)
  output <- .elbv2$describe_listeners_output()
  config <- get_config()
  svc <- .elbv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elbv2$operations$describe_listeners <- elbv2_describe_listeners

#' Describes the attributes for the specified Application Load Balancer,
#' Network Load Balancer, or Gateway Load Balancer
#'
#' @description
#' Describes the attributes for the specified Application Load Balancer, Network Load Balancer, or Gateway Load Balancer.
#'
#' See [https://www.paws-r-sdk.com/docs/elbv2_describe_load_balancer_attributes/](https://www.paws-r-sdk.com/docs/elbv2_describe_load_balancer_attributes/) for full documentation.
#'
#' @param LoadBalancerArn &#91;required&#93; The Amazon Resource Name (ARN) of the load balancer.
#'
#' @keywords internal
#'
#' @rdname elbv2_describe_load_balancer_attributes
elbv2_describe_load_balancer_attributes <- function(LoadBalancerArn) {
  op <- new_operation(
    name = "DescribeLoadBalancerAttributes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elbv2$describe_load_balancer_attributes_input(LoadBalancerArn = LoadBalancerArn)
  output <- .elbv2$describe_load_balancer_attributes_output()
  config <- get_config()
  svc <- .elbv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elbv2$operations$describe_load_balancer_attributes <- elbv2_describe_load_balancer_attributes

#' Describes the specified load balancers or all of your load balancers
#'
#' @description
#' Describes the specified load balancers or all of your load balancers.
#'
#' See [https://www.paws-r-sdk.com/docs/elbv2_describe_load_balancers/](https://www.paws-r-sdk.com/docs/elbv2_describe_load_balancers/) for full documentation.
#'
#' @param LoadBalancerArns The Amazon Resource Names (ARN) of the load balancers. You can specify
#' up to 20 load balancers in a single call.
#' @param Names The names of the load balancers.
#' @param Marker The marker for the next set of results. (You received this marker from a
#' previous call.)
#' @param PageSize The maximum number of results to return with this call.
#'
#' @keywords internal
#'
#' @rdname elbv2_describe_load_balancers
elbv2_describe_load_balancers <- function(LoadBalancerArns = NULL, Names = NULL, Marker = NULL, PageSize = NULL) {
  op <- new_operation(
    name = "DescribeLoadBalancers",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elbv2$describe_load_balancers_input(LoadBalancerArns = LoadBalancerArns, Names = Names, Marker = Marker, PageSize = PageSize)
  output <- .elbv2$describe_load_balancers_output()
  config <- get_config()
  svc <- .elbv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elbv2$operations$describe_load_balancers <- elbv2_describe_load_balancers

#' Describes the specified rules or the rules for the specified listener
#'
#' @description
#' Describes the specified rules or the rules for the specified listener. You must specify either a listener or one or more rules.
#'
#' See [https://www.paws-r-sdk.com/docs/elbv2_describe_rules/](https://www.paws-r-sdk.com/docs/elbv2_describe_rules/) for full documentation.
#'
#' @param ListenerArn The Amazon Resource Name (ARN) of the listener.
#' @param RuleArns The Amazon Resource Names (ARN) of the rules.
#' @param Marker The marker for the next set of results. (You received this marker from a
#' previous call.)
#' @param PageSize The maximum number of results to return with this call.
#'
#' @keywords internal
#'
#' @rdname elbv2_describe_rules
elbv2_describe_rules <- function(ListenerArn = NULL, RuleArns = NULL, Marker = NULL, PageSize = NULL) {
  op <- new_operation(
    name = "DescribeRules",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elbv2$describe_rules_input(ListenerArn = ListenerArn, RuleArns = RuleArns, Marker = Marker, PageSize = PageSize)
  output <- .elbv2$describe_rules_output()
  config <- get_config()
  svc <- .elbv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elbv2$operations$describe_rules <- elbv2_describe_rules

#' Describes the specified policies or all policies used for SSL
#' negotiation
#'
#' @description
#' Describes the specified policies or all policies used for SSL negotiation.
#'
#' See [https://www.paws-r-sdk.com/docs/elbv2_describe_ssl_policies/](https://www.paws-r-sdk.com/docs/elbv2_describe_ssl_policies/) for full documentation.
#'
#' @param Names The names of the policies.
#' @param Marker The marker for the next set of results. (You received this marker from a
#' previous call.)
#' @param PageSize The maximum number of results to return with this call.
#' @param LoadBalancerType The type of load balancer. The default lists the SSL policies for all
#' load balancers.
#'
#' @keywords internal
#'
#' @rdname elbv2_describe_ssl_policies
elbv2_describe_ssl_policies <- function(Names = NULL, Marker = NULL, PageSize = NULL, LoadBalancerType = NULL) {
  op <- new_operation(
    name = "DescribeSSLPolicies",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elbv2$describe_ssl_policies_input(Names = Names, Marker = Marker, PageSize = PageSize, LoadBalancerType = LoadBalancerType)
  output <- .elbv2$describe_ssl_policies_output()
  config <- get_config()
  svc <- .elbv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elbv2$operations$describe_ssl_policies <- elbv2_describe_ssl_policies

#' Describes the tags for the specified Elastic Load Balancing resources
#'
#' @description
#' Describes the tags for the specified Elastic Load Balancing resources. You can describe the tags for one or more Application Load Balancers, Network Load Balancers, Gateway Load Balancers, target groups, listeners, or rules.
#'
#' See [https://www.paws-r-sdk.com/docs/elbv2_describe_tags/](https://www.paws-r-sdk.com/docs/elbv2_describe_tags/) for full documentation.
#'
#' @param ResourceArns &#91;required&#93; The Amazon Resource Names (ARN) of the resources. You can specify up to
#' 20 resources in a single call.
#'
#' @keywords internal
#'
#' @rdname elbv2_describe_tags
elbv2_describe_tags <- function(ResourceArns) {
  op <- new_operation(
    name = "DescribeTags",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elbv2$describe_tags_input(ResourceArns = ResourceArns)
  output <- .elbv2$describe_tags_output()
  config <- get_config()
  svc <- .elbv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elbv2$operations$describe_tags <- elbv2_describe_tags

#' Describes the attributes for the specified target group
#'
#' @description
#' Describes the attributes for the specified target group.
#'
#' See [https://www.paws-r-sdk.com/docs/elbv2_describe_target_group_attributes/](https://www.paws-r-sdk.com/docs/elbv2_describe_target_group_attributes/) for full documentation.
#'
#' @param TargetGroupArn &#91;required&#93; The Amazon Resource Name (ARN) of the target group.
#'
#' @keywords internal
#'
#' @rdname elbv2_describe_target_group_attributes
elbv2_describe_target_group_attributes <- function(TargetGroupArn) {
  op <- new_operation(
    name = "DescribeTargetGroupAttributes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elbv2$describe_target_group_attributes_input(TargetGroupArn = TargetGroupArn)
  output <- .elbv2$describe_target_group_attributes_output()
  config <- get_config()
  svc <- .elbv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elbv2$operations$describe_target_group_attributes <- elbv2_describe_target_group_attributes

#' Describes the specified target groups or all of your target groups
#'
#' @description
#' Describes the specified target groups or all of your target groups. By default, all target groups are described. Alternatively, you can specify one of the following to filter the results: the ARN of the load balancer, the names of one or more target groups, or the ARNs of one or more target groups.
#'
#' See [https://www.paws-r-sdk.com/docs/elbv2_describe_target_groups/](https://www.paws-r-sdk.com/docs/elbv2_describe_target_groups/) for full documentation.
#'
#' @param LoadBalancerArn The Amazon Resource Name (ARN) of the load balancer.
#' @param TargetGroupArns The Amazon Resource Names (ARN) of the target groups.
#' @param Names The names of the target groups.
#' @param Marker The marker for the next set of results. (You received this marker from a
#' previous call.)
#' @param PageSize The maximum number of results to return with this call.
#'
#' @keywords internal
#'
#' @rdname elbv2_describe_target_groups
elbv2_describe_target_groups <- function(LoadBalancerArn = NULL, TargetGroupArns = NULL, Names = NULL, Marker = NULL, PageSize = NULL) {
  op <- new_operation(
    name = "DescribeTargetGroups",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elbv2$describe_target_groups_input(LoadBalancerArn = LoadBalancerArn, TargetGroupArns = TargetGroupArns, Names = Names, Marker = Marker, PageSize = PageSize)
  output <- .elbv2$describe_target_groups_output()
  config <- get_config()
  svc <- .elbv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elbv2$operations$describe_target_groups <- elbv2_describe_target_groups

#' Describes the health of the specified targets or all of your targets
#'
#' @description
#' Describes the health of the specified targets or all of your targets.
#'
#' See [https://www.paws-r-sdk.com/docs/elbv2_describe_target_health/](https://www.paws-r-sdk.com/docs/elbv2_describe_target_health/) for full documentation.
#'
#' @param TargetGroupArn &#91;required&#93; The Amazon Resource Name (ARN) of the target group.
#' @param Targets The targets.
#'
#' @keywords internal
#'
#' @rdname elbv2_describe_target_health
elbv2_describe_target_health <- function(TargetGroupArn, Targets = NULL) {
  op <- new_operation(
    name = "DescribeTargetHealth",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elbv2$describe_target_health_input(TargetGroupArn = TargetGroupArn, Targets = Targets)
  output <- .elbv2$describe_target_health_output()
  config <- get_config()
  svc <- .elbv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elbv2$operations$describe_target_health <- elbv2_describe_target_health

#' Replaces the specified properties of the specified listener
#'
#' @description
#' Replaces the specified properties of the specified listener. Any properties that you do not specify remain unchanged.
#'
#' See [https://www.paws-r-sdk.com/docs/elbv2_modify_listener/](https://www.paws-r-sdk.com/docs/elbv2_modify_listener/) for full documentation.
#'
#' @param ListenerArn &#91;required&#93; The Amazon Resource Name (ARN) of the listener.
#' @param Port The port for connections from clients to the load balancer. You cannot
#' specify a port for a Gateway Load Balancer.
#' @param Protocol The protocol for connections from clients to the load balancer.
#' Application Load Balancers support the HTTP and HTTPS protocols. Network
#' Load Balancers support the TCP, TLS, UDP, and TCP_UDP protocols. You
#' can’t change the protocol to UDP or TCP_UDP if dual-stack mode is
#' enabled. You cannot specify a protocol for a Gateway Load Balancer.
#' @param SslPolicy \[HTTPS and TLS listeners\] The security policy that defines which
#' protocols and ciphers are supported.
#' 
#' For more information, see [Security
#' policies](https://docs.aws.amazon.com/elasticloadbalancing/latest/application/create-https-listener.html#describe-ssl-policies)
#' in the *Application Load Balancers Guide* or [Security
#' policies](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html#describe-ssl-policies)
#' in the *Network Load Balancers Guide*.
#' @param Certificates \[HTTPS and TLS listeners\] The default certificate for the listener.
#' You must provide exactly one certificate. Set `CertificateArn` to the
#' certificate ARN but do not set `IsDefault`.
#' @param DefaultActions The actions for the default rule.
#' @param AlpnPolicy \[TLS listeners\] The name of the Application-Layer Protocol Negotiation
#' (ALPN) policy. You can specify one policy name. The following are the
#' possible values:
#' 
#' -   `HTTP1Only`
#' 
#' -   `HTTP2Only`
#' 
#' -   `HTTP2Optional`
#' 
#' -   `HTTP2Preferred`
#' 
#' -   `None`
#' 
#' For more information, see [ALPN
#' policies](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html#alpn-policies)
#' in the *Network Load Balancers Guide*.
#'
#' @keywords internal
#'
#' @rdname elbv2_modify_listener
elbv2_modify_listener <- function(ListenerArn, Port = NULL, Protocol = NULL, SslPolicy = NULL, Certificates = NULL, DefaultActions = NULL, AlpnPolicy = NULL) {
  op <- new_operation(
    name = "ModifyListener",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elbv2$modify_listener_input(ListenerArn = ListenerArn, Port = Port, Protocol = Protocol, SslPolicy = SslPolicy, Certificates = Certificates, DefaultActions = DefaultActions, AlpnPolicy = AlpnPolicy)
  output <- .elbv2$modify_listener_output()
  config <- get_config()
  svc <- .elbv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elbv2$operations$modify_listener <- elbv2_modify_listener

#' Modifies the specified attributes of the specified Application Load
#' Balancer, Network Load Balancer, or Gateway Load Balancer
#'
#' @description
#' Modifies the specified attributes of the specified Application Load Balancer, Network Load Balancer, or Gateway Load Balancer.
#'
#' See [https://www.paws-r-sdk.com/docs/elbv2_modify_load_balancer_attributes/](https://www.paws-r-sdk.com/docs/elbv2_modify_load_balancer_attributes/) for full documentation.
#'
#' @param LoadBalancerArn &#91;required&#93; The Amazon Resource Name (ARN) of the load balancer.
#' @param Attributes &#91;required&#93; The load balancer attributes.
#'
#' @keywords internal
#'
#' @rdname elbv2_modify_load_balancer_attributes
elbv2_modify_load_balancer_attributes <- function(LoadBalancerArn, Attributes) {
  op <- new_operation(
    name = "ModifyLoadBalancerAttributes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elbv2$modify_load_balancer_attributes_input(LoadBalancerArn = LoadBalancerArn, Attributes = Attributes)
  output <- .elbv2$modify_load_balancer_attributes_output()
  config <- get_config()
  svc <- .elbv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elbv2$operations$modify_load_balancer_attributes <- elbv2_modify_load_balancer_attributes

#' Replaces the specified properties of the specified rule
#'
#' @description
#' Replaces the specified properties of the specified rule. Any properties that you do not specify are unchanged.
#'
#' See [https://www.paws-r-sdk.com/docs/elbv2_modify_rule/](https://www.paws-r-sdk.com/docs/elbv2_modify_rule/) for full documentation.
#'
#' @param RuleArn &#91;required&#93; The Amazon Resource Name (ARN) of the rule.
#' @param Conditions The conditions.
#' @param Actions The actions.
#'
#' @keywords internal
#'
#' @rdname elbv2_modify_rule
elbv2_modify_rule <- function(RuleArn, Conditions = NULL, Actions = NULL) {
  op <- new_operation(
    name = "ModifyRule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elbv2$modify_rule_input(RuleArn = RuleArn, Conditions = Conditions, Actions = Actions)
  output <- .elbv2$modify_rule_output()
  config <- get_config()
  svc <- .elbv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elbv2$operations$modify_rule <- elbv2_modify_rule

#' Modifies the health checks used when evaluating the health state of the
#' targets in the specified target group
#'
#' @description
#' Modifies the health checks used when evaluating the health state of the targets in the specified target group.
#'
#' See [https://www.paws-r-sdk.com/docs/elbv2_modify_target_group/](https://www.paws-r-sdk.com/docs/elbv2_modify_target_group/) for full documentation.
#'
#' @param TargetGroupArn &#91;required&#93; The Amazon Resource Name (ARN) of the target group.
#' @param HealthCheckProtocol The protocol the load balancer uses when performing health checks on
#' targets. For Application Load Balancers, the default is HTTP. For
#' Network Load Balancers and Gateway Load Balancers, the default is TCP.
#' The TCP protocol is not supported for health checks if the protocol of
#' the target group is HTTP or HTTPS. It is supported for health checks
#' only if the protocol of the target group is TCP, TLS, UDP, or TCP_UDP.
#' The GENEVE, TLS, UDP, and TCP_UDP protocols are not supported for health
#' checks.
#' @param HealthCheckPort The port the load balancer uses when performing health checks on
#' targets.
#' @param HealthCheckPath \[HTTP/HTTPS health checks\] The destination for health checks on the
#' targets.
#' 
#' \[HTTP1 or HTTP2 protocol version\] The ping path. The default is /.
#' 
#' \[GRPC protocol version\] The path of a custom health check method with
#' the format /package.service/method. The default is /Amazon Web
#' Services.ALB/healthcheck.
#' @param HealthCheckEnabled Indicates whether health checks are enabled.
#' @param HealthCheckIntervalSeconds The approximate amount of time, in seconds, between health checks of an
#' individual target.
#' @param HealthCheckTimeoutSeconds \[HTTP/HTTPS health checks\] The amount of time, in seconds, during
#' which no response means a failed health check.
#' @param HealthyThresholdCount The number of consecutive health checks successes required before
#' considering an unhealthy target healthy.
#' @param UnhealthyThresholdCount The number of consecutive health check failures required before
#' considering the target unhealthy.
#' @param Matcher \[HTTP/HTTPS health checks\] The HTTP or gRPC codes to use when checking
#' for a successful response from a target. For target groups with a
#' protocol of TCP, TCP_UDP, UDP or TLS the range is 200-599. For target
#' groups with a protocol of HTTP or HTTPS, the range is 200-499. For
#' target groups with a protocol of GENEVE, the range is 200-399.
#'
#' @keywords internal
#'
#' @rdname elbv2_modify_target_group
elbv2_modify_target_group <- function(TargetGroupArn, HealthCheckProtocol = NULL, HealthCheckPort = NULL, HealthCheckPath = NULL, HealthCheckEnabled = NULL, HealthCheckIntervalSeconds = NULL, HealthCheckTimeoutSeconds = NULL, HealthyThresholdCount = NULL, UnhealthyThresholdCount = NULL, Matcher = NULL) {
  op <- new_operation(
    name = "ModifyTargetGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elbv2$modify_target_group_input(TargetGroupArn = TargetGroupArn, HealthCheckProtocol = HealthCheckProtocol, HealthCheckPort = HealthCheckPort, HealthCheckPath = HealthCheckPath, HealthCheckEnabled = HealthCheckEnabled, HealthCheckIntervalSeconds = HealthCheckIntervalSeconds, HealthCheckTimeoutSeconds = HealthCheckTimeoutSeconds, HealthyThresholdCount = HealthyThresholdCount, UnhealthyThresholdCount = UnhealthyThresholdCount, Matcher = Matcher)
  output <- .elbv2$modify_target_group_output()
  config <- get_config()
  svc <- .elbv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elbv2$operations$modify_target_group <- elbv2_modify_target_group

#' Modifies the specified attributes of the specified target group
#'
#' @description
#' Modifies the specified attributes of the specified target group.
#'
#' See [https://www.paws-r-sdk.com/docs/elbv2_modify_target_group_attributes/](https://www.paws-r-sdk.com/docs/elbv2_modify_target_group_attributes/) for full documentation.
#'
#' @param TargetGroupArn &#91;required&#93; The Amazon Resource Name (ARN) of the target group.
#' @param Attributes &#91;required&#93; The attributes.
#'
#' @keywords internal
#'
#' @rdname elbv2_modify_target_group_attributes
elbv2_modify_target_group_attributes <- function(TargetGroupArn, Attributes) {
  op <- new_operation(
    name = "ModifyTargetGroupAttributes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elbv2$modify_target_group_attributes_input(TargetGroupArn = TargetGroupArn, Attributes = Attributes)
  output <- .elbv2$modify_target_group_attributes_output()
  config <- get_config()
  svc <- .elbv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elbv2$operations$modify_target_group_attributes <- elbv2_modify_target_group_attributes

#' Registers the specified targets with the specified target group
#'
#' @description
#' Registers the specified targets with the specified target group.
#'
#' See [https://www.paws-r-sdk.com/docs/elbv2_register_targets/](https://www.paws-r-sdk.com/docs/elbv2_register_targets/) for full documentation.
#'
#' @param TargetGroupArn &#91;required&#93; The Amazon Resource Name (ARN) of the target group.
#' @param Targets &#91;required&#93; The targets.
#'
#' @keywords internal
#'
#' @rdname elbv2_register_targets
elbv2_register_targets <- function(TargetGroupArn, Targets) {
  op <- new_operation(
    name = "RegisterTargets",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elbv2$register_targets_input(TargetGroupArn = TargetGroupArn, Targets = Targets)
  output <- .elbv2$register_targets_output()
  config <- get_config()
  svc <- .elbv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elbv2$operations$register_targets <- elbv2_register_targets

#' Removes the specified certificate from the certificate list for the
#' specified HTTPS or TLS listener
#'
#' @description
#' Removes the specified certificate from the certificate list for the specified HTTPS or TLS listener.
#'
#' See [https://www.paws-r-sdk.com/docs/elbv2_remove_listener_certificates/](https://www.paws-r-sdk.com/docs/elbv2_remove_listener_certificates/) for full documentation.
#'
#' @param ListenerArn &#91;required&#93; The Amazon Resource Name (ARN) of the listener.
#' @param Certificates &#91;required&#93; The certificate to remove. You can specify one certificate per call. Set
#' `CertificateArn` to the certificate ARN but do not set `IsDefault`.
#'
#' @keywords internal
#'
#' @rdname elbv2_remove_listener_certificates
elbv2_remove_listener_certificates <- function(ListenerArn, Certificates) {
  op <- new_operation(
    name = "RemoveListenerCertificates",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elbv2$remove_listener_certificates_input(ListenerArn = ListenerArn, Certificates = Certificates)
  output <- .elbv2$remove_listener_certificates_output()
  config <- get_config()
  svc <- .elbv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elbv2$operations$remove_listener_certificates <- elbv2_remove_listener_certificates

#' Removes the specified tags from the specified Elastic Load Balancing
#' resources
#'
#' @description
#' Removes the specified tags from the specified Elastic Load Balancing resources. You can remove the tags for one or more Application Load Balancers, Network Load Balancers, Gateway Load Balancers, target groups, listeners, or rules.
#'
#' See [https://www.paws-r-sdk.com/docs/elbv2_remove_tags/](https://www.paws-r-sdk.com/docs/elbv2_remove_tags/) for full documentation.
#'
#' @param ResourceArns &#91;required&#93; The Amazon Resource Name (ARN) of the resource.
#' @param TagKeys &#91;required&#93; The tag keys for the tags to remove.
#'
#' @keywords internal
#'
#' @rdname elbv2_remove_tags
elbv2_remove_tags <- function(ResourceArns, TagKeys) {
  op <- new_operation(
    name = "RemoveTags",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elbv2$remove_tags_input(ResourceArns = ResourceArns, TagKeys = TagKeys)
  output <- .elbv2$remove_tags_output()
  config <- get_config()
  svc <- .elbv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elbv2$operations$remove_tags <- elbv2_remove_tags

#' Sets the type of IP addresses used by the subnets of the specified load
#' balancer
#'
#' @description
#' Sets the type of IP addresses used by the subnets of the specified load balancer.
#'
#' See [https://www.paws-r-sdk.com/docs/elbv2_set_ip_address_type/](https://www.paws-r-sdk.com/docs/elbv2_set_ip_address_type/) for full documentation.
#'
#' @param LoadBalancerArn &#91;required&#93; The Amazon Resource Name (ARN) of the load balancer.
#' @param IpAddressType &#91;required&#93; The IP address type. The possible values are `ipv4` (for IPv4 addresses)
#' and `dualstack` (for IPv4 and IPv6 addresses). You can’t specify
#' `dualstack` for a load balancer with a UDP or TCP_UDP listener.
#'
#' @keywords internal
#'
#' @rdname elbv2_set_ip_address_type
elbv2_set_ip_address_type <- function(LoadBalancerArn, IpAddressType) {
  op <- new_operation(
    name = "SetIpAddressType",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elbv2$set_ip_address_type_input(LoadBalancerArn = LoadBalancerArn, IpAddressType = IpAddressType)
  output <- .elbv2$set_ip_address_type_output()
  config <- get_config()
  svc <- .elbv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elbv2$operations$set_ip_address_type <- elbv2_set_ip_address_type

#' Sets the priorities of the specified rules
#'
#' @description
#' Sets the priorities of the specified rules.
#'
#' See [https://www.paws-r-sdk.com/docs/elbv2_set_rule_priorities/](https://www.paws-r-sdk.com/docs/elbv2_set_rule_priorities/) for full documentation.
#'
#' @param RulePriorities &#91;required&#93; The rule priorities.
#'
#' @keywords internal
#'
#' @rdname elbv2_set_rule_priorities
elbv2_set_rule_priorities <- function(RulePriorities) {
  op <- new_operation(
    name = "SetRulePriorities",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elbv2$set_rule_priorities_input(RulePriorities = RulePriorities)
  output <- .elbv2$set_rule_priorities_output()
  config <- get_config()
  svc <- .elbv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elbv2$operations$set_rule_priorities <- elbv2_set_rule_priorities

#' Associates the specified security groups with the specified Application
#' Load Balancer
#'
#' @description
#' Associates the specified security groups with the specified Application Load Balancer. The specified security groups override the previously associated security groups.
#'
#' See [https://www.paws-r-sdk.com/docs/elbv2_set_security_groups/](https://www.paws-r-sdk.com/docs/elbv2_set_security_groups/) for full documentation.
#'
#' @param LoadBalancerArn &#91;required&#93; The Amazon Resource Name (ARN) of the load balancer.
#' @param SecurityGroups &#91;required&#93; The IDs of the security groups.
#'
#' @keywords internal
#'
#' @rdname elbv2_set_security_groups
elbv2_set_security_groups <- function(LoadBalancerArn, SecurityGroups) {
  op <- new_operation(
    name = "SetSecurityGroups",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elbv2$set_security_groups_input(LoadBalancerArn = LoadBalancerArn, SecurityGroups = SecurityGroups)
  output <- .elbv2$set_security_groups_output()
  config <- get_config()
  svc <- .elbv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elbv2$operations$set_security_groups <- elbv2_set_security_groups

#' Enables the Availability Zones for the specified public subnets for the
#' specified Application Load Balancer or Network Load Balancer
#'
#' @description
#' Enables the Availability Zones for the specified public subnets for the specified Application Load Balancer or Network Load Balancer. The specified subnets replace the previously enabled subnets.
#'
#' See [https://www.paws-r-sdk.com/docs/elbv2_set_subnets/](https://www.paws-r-sdk.com/docs/elbv2_set_subnets/) for full documentation.
#'
#' @param LoadBalancerArn &#91;required&#93; The Amazon Resource Name (ARN) of the load balancer.
#' @param Subnets The IDs of the public subnets. You can specify only one subnet per
#' Availability Zone. You must specify either subnets or subnet mappings.
#' 
#' \[Application Load Balancers\] You must specify subnets from at least
#' two Availability Zones.
#' 
#' \[Application Load Balancers on Outposts\] You must specify one Outpost
#' subnet.
#' 
#' \[Application Load Balancers on Local Zones\] You can specify subnets
#' from one or more Local Zones.
#' 
#' \[Network Load Balancers\] You can specify subnets from one or more
#' Availability Zones.
#' @param SubnetMappings The IDs of the public subnets. You can specify only one subnet per
#' Availability Zone. You must specify either subnets or subnet mappings.
#' 
#' \[Application Load Balancers\] You must specify subnets from at least
#' two Availability Zones. You cannot specify Elastic IP addresses for your
#' subnets.
#' 
#' \[Application Load Balancers on Outposts\] You must specify one Outpost
#' subnet.
#' 
#' \[Application Load Balancers on Local Zones\] You can specify subnets
#' from one or more Local Zones.
#' 
#' \[Network Load Balancers\] You can specify subnets from one or more
#' Availability Zones. You can specify one Elastic IP address per subnet if
#' you need static IP addresses for your internet-facing load balancer. For
#' internal load balancers, you can specify one private IP address per
#' subnet from the IPv4 range of the subnet. For internet-facing load
#' balancer, you can specify one IPv6 address per subnet.
#' @param IpAddressType \[Network Load Balancers\] The type of IP addresses used by the subnets
#' for your load balancer. The possible values are `ipv4` (for IPv4
#' addresses) and `dualstack` (for IPv4 and IPv6 addresses). You can’t
#' specify `dualstack` for a load balancer with a UDP or TCP_UDP listener.
#' .
#'
#' @keywords internal
#'
#' @rdname elbv2_set_subnets
elbv2_set_subnets <- function(LoadBalancerArn, Subnets = NULL, SubnetMappings = NULL, IpAddressType = NULL) {
  op <- new_operation(
    name = "SetSubnets",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elbv2$set_subnets_input(LoadBalancerArn = LoadBalancerArn, Subnets = Subnets, SubnetMappings = SubnetMappings, IpAddressType = IpAddressType)
  output <- .elbv2$set_subnets_output()
  config <- get_config()
  svc <- .elbv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elbv2$operations$set_subnets <- elbv2_set_subnets
