% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/route53_operations.R
\name{route53_list_hosted_zones}
\alias{route53_list_hosted_zones}
\title{Retrieves a list of the public and private hosted zones that are
associated with the current Amazon Web Services account}
\usage{
route53_list_hosted_zones(
  Marker = NULL,
  MaxItems = NULL,
  DelegationSetId = NULL
)
}
\arguments{
\item{Marker}{If the value of \code{IsTruncated} in the previous response was \code{true}, you
have more hosted zones. To get more hosted zones, submit another
\code{\link[=route53_list_hosted_zones]{list_hosted_zones}} request.

For the value of \code{marker}, specify the value of \code{NextMarker} from the
previous response, which is the ID of the first hosted zone that Amazon
Route 53 will return if you submit another request.

If the value of \code{IsTruncated} in the previous response was \code{false},
there are no more hosted zones to get.}

\item{MaxItems}{(Optional) The maximum number of hosted zones that you want Amazon Route
53 to return. If you have more than \code{maxitems} hosted zones, the value
of \code{IsTruncated} in the response is \code{true}, and the value of
\code{NextMarker} is the hosted zone ID of the first hosted zone that Route
53 will return if you submit another request.}

\item{DelegationSetId}{If you're using reusable delegation sets and you want to list all of the
hosted zones that are associated with a reusable delegation set, specify
the ID of that reusable delegation set.}
}
\description{
Retrieves a list of the public and private hosted zones that are associated with the current Amazon Web Services account. The response includes a \code{HostedZones} child element for each hosted zone.

See \url{https://www.paws-r-sdk.com/docs/route53_list_hosted_zones/} for full documentation.
}
\keyword{internal}
