# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_operation new_request send_request
#' @include securityhub_service.R
NULL

#' Accepts the invitation to be monitored by a master SecurityHub account
#'
#' Accepts the invitation to be monitored by a master SecurityHub account.
#'
#' @usage
#' securityhub_accept_invitation(MasterId, InvitationId)
#'
#' @param MasterId The account ID of the master Security Hub account whose invitation
#' you\'re accepting.
#' @param InvitationId The ID of the invitation that is sent to the AWS account by the Security
#' Hub master account.
#'
#' @section Request syntax:
#' ```
#' svc$accept_invitation(
#'   MasterId = "string",
#'   InvitationId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname securityhub_accept_invitation
securityhub_accept_invitation <- function(MasterId = NULL, InvitationId = NULL) {
  op <- new_operation(
    name = "AcceptInvitation",
    http_method = "POST",
    http_path = "/master",
    paginator = list()
  )
  input <- .securityhub$accept_invitation_input(MasterId = MasterId, InvitationId = InvitationId)
  output <- .securityhub$accept_invitation_output()
  svc <- .securityhub$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$accept_invitation <- securityhub_accept_invitation

#' Disables the standards specified by the standards subscription ARNs
#'
#' Disables the standards specified by the standards subscription ARNs. In
#' the context of Security Hub, supported standards (for example, CIS AWS
#' Foundations) are automated and continuous checks that help determine
#' your compliance status against security industry (including AWS) best
#' practices.
#'
#' @usage
#' securityhub_batch_disable_standards(StandardsSubscriptionArns)
#'
#' @param StandardsSubscriptionArns &#91;required&#93; The ARNS of the standards subscriptions that you want to disable.
#'
#' @section Request syntax:
#' ```
#' svc$batch_disable_standards(
#'   StandardsSubscriptionArns = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname securityhub_batch_disable_standards
securityhub_batch_disable_standards <- function(StandardsSubscriptionArns) {
  op <- new_operation(
    name = "BatchDisableStandards",
    http_method = "POST",
    http_path = "/standards/deregister",
    paginator = list()
  )
  input <- .securityhub$batch_disable_standards_input(StandardsSubscriptionArns = StandardsSubscriptionArns)
  output <- .securityhub$batch_disable_standards_output()
  svc <- .securityhub$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$batch_disable_standards <- securityhub_batch_disable_standards

#' Enables the standards specified by the standards ARNs
#'
#' Enables the standards specified by the standards ARNs. In the context of
#' Security Hub, supported standards (for example, CIS AWS Foundations) are
#' automated and continuous checks that help determine your compliance
#' status against security industry (including AWS) best practices.
#'
#' @usage
#' securityhub_batch_enable_standards(StandardsSubscriptionRequests)
#'
#' @param StandardsSubscriptionRequests &#91;required&#93; The list of standards that you want to enable.
#'
#' @section Request syntax:
#' ```
#' svc$batch_enable_standards(
#'   StandardsSubscriptionRequests = list(
#'     list(
#'       StandardsArn = "string",
#'       StandardsInput = list(
#'         "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname securityhub_batch_enable_standards
securityhub_batch_enable_standards <- function(StandardsSubscriptionRequests) {
  op <- new_operation(
    name = "BatchEnableStandards",
    http_method = "POST",
    http_path = "/standards/register",
    paginator = list()
  )
  input <- .securityhub$batch_enable_standards_input(StandardsSubscriptionRequests = StandardsSubscriptionRequests)
  output <- .securityhub$batch_enable_standards_output()
  svc <- .securityhub$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$batch_enable_standards <- securityhub_batch_enable_standards

#' Imports security findings that are generated by the integrated
#' third-party products into Security Hub
#'
#' Imports security findings that are generated by the integrated
#' third-party products into Security Hub.
#'
#' @usage
#' securityhub_batch_import_findings(Findings)
#'
#' @param Findings &#91;required&#93; A list of findings that you want to import. Must be submitted in the
#' AWSSecurityFinding format.
#'
#' @section Request syntax:
#' ```
#' svc$batch_import_findings(
#'   Findings = list(
#'     list(
#'       SchemaVersion = "string",
#'       Id = "string",
#'       ProductArn = "string",
#'       GeneratorId = "string",
#'       AwsAccountId = "string",
#'       Types = list(
#'         "string"
#'       ),
#'       FirstObservedAt = "string",
#'       LastObservedAt = "string",
#'       CreatedAt = "string",
#'       UpdatedAt = "string",
#'       Severity = list(
#'         Product = 123.0,
#'         Normalized = 123
#'       ),
#'       Confidence = 123,
#'       Criticality = 123,
#'       Title = "string",
#'       Description = "string",
#'       Remediation = list(
#'         Recommendation = list(
#'           Text = "string",
#'           Url = "string"
#'         )
#'       ),
#'       SourceUrl = "string",
#'       ProductFields = list(
#'         "string"
#'       ),
#'       UserDefinedFields = list(
#'         "string"
#'       ),
#'       Malware = list(
#'         list(
#'           Name = "string",
#'           Type = "ADWARE"|"BLENDED_THREAT"|"BOTNET_AGENT"|"COIN_MINER"|"EXPLOIT_KIT"|"KEYLOGGER"|"MACRO"|"POTENTIALLY_UNWANTED"|"SPYWARE"|"RANSOMWARE"|"REMOTE_ACCESS"|"ROOTKIT"|"TROJAN"|"VIRUS"|"WORM",
#'           Path = "string",
#'           State = "OBSERVED"|"REMOVAL_FAILED"|"REMOVED"
#'         )
#'       ),
#'       Network = list(
#'         Direction = "IN"|"OUT",
#'         Protocol = "string",
#'         SourceIpV4 = "string",
#'         SourceIpV6 = "string",
#'         SourcePort = 123,
#'         SourceDomain = "string",
#'         SourceMac = "string",
#'         DestinationIpV4 = "string",
#'         DestinationIpV6 = "string",
#'         DestinationPort = 123,
#'         DestinationDomain = "string"
#'       ),
#'       Process = list(
#'         Name = "string",
#'         Path = "string",
#'         Pid = 123,
#'         ParentPid = 123,
#'         LaunchedAt = "string",
#'         TerminatedAt = "string"
#'       ),
#'       ThreatIntelIndicators = list(
#'         list(
#'           Type = "DOMAIN"|"EMAIL_ADDRESS"|"HASH_MD5"|"HASH_SHA1"|"HASH_SHA256"|"HASH_SHA512"|"IPV4_ADDRESS"|"IPV6_ADDRESS"|"MUTEX"|"PROCESS"|"URL",
#'           Value = "string",
#'           Category = "BACKDOOR"|"CARD_STEALER"|"COMMAND_AND_CONTROL"|"DROP_SITE"|"EXPLOIT_SITE"|"KEYLOGGER",
#'           LastObservedAt = "string",
#'           Source = "string",
#'           SourceUrl = "string"
#'         )
#'       ),
#'       Resources = list(
#'         list(
#'           Type = "string",
#'           Id = "string",
#'           Partition = "aws"|"aws-cn"|"aws-us-gov",
#'           Region = "string",
#'           Tags = list(
#'             "string"
#'           ),
#'           Details = list(
#'             AwsEc2Instance = list(
#'               Type = "string",
#'               ImageId = "string",
#'               IpV4Addresses = list(
#'                 "string"
#'               ),
#'               IpV6Addresses = list(
#'                 "string"
#'               ),
#'               KeyName = "string",
#'               IamInstanceProfileArn = "string",
#'               VpcId = "string",
#'               SubnetId = "string",
#'               LaunchedAt = "string"
#'             ),
#'             AwsS3Bucket = list(
#'               OwnerId = "string",
#'               OwnerName = "string"
#'             ),
#'             AwsIamAccessKey = list(
#'               UserName = "string",
#'               Status = "Active"|"Inactive",
#'               CreatedAt = "string"
#'             ),
#'             Container = list(
#'               Name = "string",
#'               ImageId = "string",
#'               ImageName = "string",
#'               LaunchedAt = "string"
#'             ),
#'             Other = list(
#'               "string"
#'             )
#'           )
#'         )
#'       ),
#'       Compliance = list(
#'         Status = "PASSED"|"WARNING"|"FAILED"|"NOT_AVAILABLE"
#'       ),
#'       VerificationState = "UNKNOWN"|"TRUE_POSITIVE"|"FALSE_POSITIVE"|"BENIGN_POSITIVE",
#'       WorkflowState = "NEW"|"ASSIGNED"|"IN_PROGRESS"|"DEFERRED"|"RESOLVED",
#'       RecordState = "ACTIVE"|"ARCHIVED",
#'       RelatedFindings = list(
#'         list(
#'           ProductArn = "string",
#'           Id = "string"
#'         )
#'       ),
#'       Note = list(
#'         Text = "string",
#'         UpdatedBy = "string",
#'         UpdatedAt = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname securityhub_batch_import_findings
securityhub_batch_import_findings <- function(Findings) {
  op <- new_operation(
    name = "BatchImportFindings",
    http_method = "POST",
    http_path = "/findings/import",
    paginator = list()
  )
  input <- .securityhub$batch_import_findings_input(Findings = Findings)
  output <- .securityhub$batch_import_findings_output()
  svc <- .securityhub$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$batch_import_findings <- securityhub_batch_import_findings

#' Creates an insight, which is a consolidation of findings that identifies
#' a security area that requires attention or intervention
#'
#' Creates an insight, which is a consolidation of findings that identifies
#' a security area that requires attention or intervention.
#'
#' @usage
#' securityhub_create_insight(Name, Filters, GroupByAttribute)
#'
#' @param Name &#91;required&#93; The user-defined name that identifies the insight that you want to
#' create.
#' @param Filters &#91;required&#93; A collection of attributes that are applied to all active Security
#' Hub-aggregated findings and that result in a subset of findings that are
#' included in this insight.
#' @param GroupByAttribute &#91;required&#93; The attribute by which the insight\'s findings are grouped. This
#' attribute is used as a findings aggregator for the purposes of viewing
#' and managing multiple related findings under a single operand.
#'
#' @section Request syntax:
#' ```
#' svc$create_insight(
#'   Name = "string",
#'   Filters = list(
#'     ProductArn = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     AwsAccountId = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     Id = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     GeneratorId = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     Type = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     FirstObservedAt = list(
#'       list(
#'         Start = "string",
#'         End = "string",
#'         DateRange = list(
#'           Value = 123,
#'           Unit = "DAYS"
#'         )
#'       )
#'     ),
#'     LastObservedAt = list(
#'       list(
#'         Start = "string",
#'         End = "string",
#'         DateRange = list(
#'           Value = 123,
#'           Unit = "DAYS"
#'         )
#'       )
#'     ),
#'     CreatedAt = list(
#'       list(
#'         Start = "string",
#'         End = "string",
#'         DateRange = list(
#'           Value = 123,
#'           Unit = "DAYS"
#'         )
#'       )
#'     ),
#'     UpdatedAt = list(
#'       list(
#'         Start = "string",
#'         End = "string",
#'         DateRange = list(
#'           Value = 123,
#'           Unit = "DAYS"
#'         )
#'       )
#'     ),
#'     SeverityProduct = list(
#'       list(
#'         Gte = 123.0,
#'         Lte = 123.0,
#'         Eq = 123.0
#'       )
#'     ),
#'     SeverityNormalized = list(
#'       list(
#'         Gte = 123.0,
#'         Lte = 123.0,
#'         Eq = 123.0
#'       )
#'     ),
#'     SeverityLabel = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     Confidence = list(
#'       list(
#'         Gte = 123.0,
#'         Lte = 123.0,
#'         Eq = 123.0
#'       )
#'     ),
#'     Criticality = list(
#'       list(
#'         Gte = 123.0,
#'         Lte = 123.0,
#'         Eq = 123.0
#'       )
#'     ),
#'     Title = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     Description = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     RecommendationText = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     SourceUrl = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     ProductFields = list(
#'       list(
#'         Key = "string",
#'         Value = "string",
#'         Comparison = "CONTAINS"
#'       )
#'     ),
#'     ProductName = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     CompanyName = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     UserDefinedFields = list(
#'       list(
#'         Key = "string",
#'         Value = "string",
#'         Comparison = "CONTAINS"
#'       )
#'     ),
#'     MalwareName = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     MalwareType = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     MalwarePath = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     MalwareState = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     NetworkDirection = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     NetworkProtocol = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     NetworkSourceIpV4 = list(
#'       list(
#'         Cidr = "string"
#'       )
#'     ),
#'     NetworkSourceIpV6 = list(
#'       list(
#'         Cidr = "string"
#'       )
#'     ),
#'     NetworkSourcePort = list(
#'       list(
#'         Gte = 123.0,
#'         Lte = 123.0,
#'         Eq = 123.0
#'       )
#'     ),
#'     NetworkSourceDomain = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     NetworkSourceMac = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     NetworkDestinationIpV4 = list(
#'       list(
#'         Cidr = "string"
#'       )
#'     ),
#'     NetworkDestinationIpV6 = list(
#'       list(
#'         Cidr = "string"
#'       )
#'     ),
#'     NetworkDestinationPort = list(
#'       list(
#'         Gte = 123.0,
#'         Lte = 123.0,
#'         Eq = 123.0
#'       )
#'     ),
#'     NetworkDestinationDomain = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     ProcessName = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     ProcessPath = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     ProcessPid = list(
#'       list(
#'         Gte = 123.0,
#'         Lte = 123.0,
#'         Eq = 123.0
#'       )
#'     ),
#'     ProcessParentPid = list(
#'       list(
#'         Gte = 123.0,
#'         Lte = 123.0,
#'         Eq = 123.0
#'       )
#'     ),
#'     ProcessLaunchedAt = list(
#'       list(
#'         Start = "string",
#'         End = "string",
#'         DateRange = list(
#'           Value = 123,
#'           Unit = "DAYS"
#'         )
#'       )
#'     ),
#'     ProcessTerminatedAt = list(
#'       list(
#'         Start = "string",
#'         End = "string",
#'         DateRange = list(
#'           Value = 123,
#'           Unit = "DAYS"
#'         )
#'       )
#'     ),
#'     ThreatIntelIndicatorType = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     ThreatIntelIndicatorValue = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     ThreatIntelIndicatorCategory = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     ThreatIntelIndicatorLastObservedAt = list(
#'       list(
#'         Start = "string",
#'         End = "string",
#'         DateRange = list(
#'           Value = 123,
#'           Unit = "DAYS"
#'         )
#'       )
#'     ),
#'     ThreatIntelIndicatorSource = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     ThreatIntelIndicatorSourceUrl = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     ResourceType = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     ResourceId = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     ResourcePartition = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     ResourceRegion = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     ResourceTags = list(
#'       list(
#'         Key = "string",
#'         Value = "string",
#'         Comparison = "CONTAINS"
#'       )
#'     ),
#'     ResourceAwsEc2InstanceType = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     ResourceAwsEc2InstanceImageId = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     ResourceAwsEc2InstanceIpV4Addresses = list(
#'       list(
#'         Cidr = "string"
#'       )
#'     ),
#'     ResourceAwsEc2InstanceIpV6Addresses = list(
#'       list(
#'         Cidr = "string"
#'       )
#'     ),
#'     ResourceAwsEc2InstanceKeyName = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     ResourceAwsEc2InstanceIamInstanceProfileArn = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     ResourceAwsEc2InstanceVpcId = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     ResourceAwsEc2InstanceSubnetId = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     ResourceAwsEc2InstanceLaunchedAt = list(
#'       list(
#'         Start = "string",
#'         End = "string",
#'         DateRange = list(
#'           Value = 123,
#'           Unit = "DAYS"
#'         )
#'       )
#'     ),
#'     ResourceAwsS3BucketOwnerId = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     ResourceAwsS3BucketOwnerName = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     ResourceAwsIamAccessKeyUserName = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     ResourceAwsIamAccessKeyStatus = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     ResourceAwsIamAccessKeyCreatedAt = list(
#'       list(
#'         Start = "string",
#'         End = "string",
#'         DateRange = list(
#'           Value = 123,
#'           Unit = "DAYS"
#'         )
#'       )
#'     ),
#'     ResourceContainerName = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     ResourceContainerImageId = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     ResourceContainerImageName = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     ResourceContainerLaunchedAt = list(
#'       list(
#'         Start = "string",
#'         End = "string",
#'         DateRange = list(
#'           Value = 123,
#'           Unit = "DAYS"
#'         )
#'       )
#'     ),
#'     ResourceDetailsOther = list(
#'       list(
#'         Key = "string",
#'         Value = "string",
#'         Comparison = "CONTAINS"
#'       )
#'     ),
#'     ComplianceStatus = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     VerificationState = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     WorkflowState = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     RecordState = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     RelatedFindingsProductArn = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     RelatedFindingsId = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     NoteText = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     NoteUpdatedAt = list(
#'       list(
#'         Start = "string",
#'         End = "string",
#'         DateRange = list(
#'           Value = 123,
#'           Unit = "DAYS"
#'         )
#'       )
#'     ),
#'     NoteUpdatedBy = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     Keyword = list(
#'       list(
#'         Value = "string"
#'       )
#'     )
#'   ),
#'   GroupByAttribute = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname securityhub_create_insight
securityhub_create_insight <- function(Name, Filters, GroupByAttribute) {
  op <- new_operation(
    name = "CreateInsight",
    http_method = "POST",
    http_path = "/insights",
    paginator = list()
  )
  input <- .securityhub$create_insight_input(Name = Name, Filters = Filters, GroupByAttribute = GroupByAttribute)
  output <- .securityhub$create_insight_output()
  svc <- .securityhub$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$create_insight <- securityhub_create_insight

#' Creates member Security Hub accounts in the current AWS account (which
#' becomes the master Security Hub account) that has Security Hub enabled
#'
#' Creates member Security Hub accounts in the current AWS account (which
#' becomes the master Security Hub account) that has Security Hub enabled.
#'
#' @usage
#' securityhub_create_members(AccountDetails)
#'
#' @param AccountDetails A list of account ID and email address pairs of the accounts that you
#' want to associate with the master Security Hub account.
#'
#' @section Request syntax:
#' ```
#' svc$create_members(
#'   AccountDetails = list(
#'     list(
#'       AccountId = "string",
#'       Email = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname securityhub_create_members
securityhub_create_members <- function(AccountDetails = NULL) {
  op <- new_operation(
    name = "CreateMembers",
    http_method = "POST",
    http_path = "/members",
    paginator = list()
  )
  input <- .securityhub$create_members_input(AccountDetails = AccountDetails)
  output <- .securityhub$create_members_output()
  svc <- .securityhub$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$create_members <- securityhub_create_members

#' Declines invitations that are sent to this AWS account (invitee) by the
#' AWS accounts (inviters) that are specified by the account IDs
#'
#' Declines invitations that are sent to this AWS account (invitee) by the
#' AWS accounts (inviters) that are specified by the account IDs.
#'
#' @usage
#' securityhub_decline_invitations(AccountIds)
#'
#' @param AccountIds A list of account IDs specifying accounts whose invitations to Security
#' Hub you want to decline.
#'
#' @section Request syntax:
#' ```
#' svc$decline_invitations(
#'   AccountIds = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname securityhub_decline_invitations
securityhub_decline_invitations <- function(AccountIds = NULL) {
  op <- new_operation(
    name = "DeclineInvitations",
    http_method = "POST",
    http_path = "/invitations/decline",
    paginator = list()
  )
  input <- .securityhub$decline_invitations_input(AccountIds = AccountIds)
  output <- .securityhub$decline_invitations_output()
  svc <- .securityhub$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$decline_invitations <- securityhub_decline_invitations

#' Deletes an insight that is specified by the insight ARN
#'
#' Deletes an insight that is specified by the insight ARN.
#'
#' @usage
#' securityhub_delete_insight(InsightArn)
#'
#' @param InsightArn &#91;required&#93; The ARN of the insight that you want to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_insight(
#'   InsightArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname securityhub_delete_insight
securityhub_delete_insight <- function(InsightArn) {
  op <- new_operation(
    name = "DeleteInsight",
    http_method = "DELETE",
    http_path = "/insights/{InsightArn+}",
    paginator = list()
  )
  input <- .securityhub$delete_insight_input(InsightArn = InsightArn)
  output <- .securityhub$delete_insight_output()
  svc <- .securityhub$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$delete_insight <- securityhub_delete_insight

#' Deletes invitations that are sent to this AWS account (invitee) by the
#' AWS accounts (inviters) that are specified by their account IDs
#'
#' Deletes invitations that are sent to this AWS account (invitee) by the
#' AWS accounts (inviters) that are specified by their account IDs.
#'
#' @usage
#' securityhub_delete_invitations(AccountIds)
#'
#' @param AccountIds A list of account IDs specifying accounts whose invitations to Security
#' Hub you want to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_invitations(
#'   AccountIds = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname securityhub_delete_invitations
securityhub_delete_invitations <- function(AccountIds = NULL) {
  op <- new_operation(
    name = "DeleteInvitations",
    http_method = "POST",
    http_path = "/invitations/delete",
    paginator = list()
  )
  input <- .securityhub$delete_invitations_input(AccountIds = AccountIds)
  output <- .securityhub$delete_invitations_output()
  svc <- .securityhub$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$delete_invitations <- securityhub_delete_invitations

#' Deletes the Security Hub member accounts that are specified by the
#' account IDs
#'
#' Deletes the Security Hub member accounts that are specified by the
#' account IDs.
#'
#' @usage
#' securityhub_delete_members(AccountIds)
#'
#' @param AccountIds A list of account IDs of the Security Hub member accounts that you want
#' to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_members(
#'   AccountIds = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname securityhub_delete_members
securityhub_delete_members <- function(AccountIds = NULL) {
  op <- new_operation(
    name = "DeleteMembers",
    http_method = "POST",
    http_path = "/members/delete",
    paginator = list()
  )
  input <- .securityhub$delete_members_input(AccountIds = AccountIds)
  output <- .securityhub$delete_members_output()
  svc <- .securityhub$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$delete_members <- securityhub_delete_members

#' Stops you from being able to import findings generated by integrated
#' third-party providers into Security Hub
#'
#' Stops you from being able to import findings generated by integrated
#' third-party providers into Security Hub.
#'
#' @usage
#' securityhub_disable_import_findings_for_product(ProductSubscriptionArn)
#'
#' @param ProductSubscriptionArn &#91;required&#93; The ARN of a resource that represents your subscription to a supported
#' product.
#'
#' @section Request syntax:
#' ```
#' svc$disable_import_findings_for_product(
#'   ProductSubscriptionArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname securityhub_disable_import_findings_for_product
securityhub_disable_import_findings_for_product <- function(ProductSubscriptionArn) {
  op <- new_operation(
    name = "DisableImportFindingsForProduct",
    http_method = "DELETE",
    http_path = "/productSubscriptions/{ProductSubscriptionArn+}",
    paginator = list()
  )
  input <- .securityhub$disable_import_findings_for_product_input(ProductSubscriptionArn = ProductSubscriptionArn)
  output <- .securityhub$disable_import_findings_for_product_output()
  svc <- .securityhub$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$disable_import_findings_for_product <- securityhub_disable_import_findings_for_product

#' Disables the AWS Security Hub Service
#'
#' Disables the AWS Security Hub Service.
#'
#' @usage
#' securityhub_disable_security_hub()
#'
#' @section Request syntax:
#' ```
#' svc$disable_security_hub()
#' ```
#'
#' @keywords internal
#'
#' @rdname securityhub_disable_security_hub
securityhub_disable_security_hub <- function() {
  op <- new_operation(
    name = "DisableSecurityHub",
    http_method = "DELETE",
    http_path = "/accounts",
    paginator = list()
  )
  input <- .securityhub$disable_security_hub_input()
  output <- .securityhub$disable_security_hub_output()
  svc <- .securityhub$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$disable_security_hub <- securityhub_disable_security_hub

#' Disassociates the current Security Hub member account from its master
#' account
#'
#' Disassociates the current Security Hub member account from its master
#' account.
#'
#' @usage
#' securityhub_disassociate_from_master_account()
#'
#' @section Request syntax:
#' ```
#' svc$disassociate_from_master_account()
#' ```
#'
#' @keywords internal
#'
#' @rdname securityhub_disassociate_from_master_account
securityhub_disassociate_from_master_account <- function() {
  op <- new_operation(
    name = "DisassociateFromMasterAccount",
    http_method = "POST",
    http_path = "/master/disassociate",
    paginator = list()
  )
  input <- .securityhub$disassociate_from_master_account_input()
  output <- .securityhub$disassociate_from_master_account_output()
  svc <- .securityhub$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$disassociate_from_master_account <- securityhub_disassociate_from_master_account

#' Disassociates the Security Hub member accounts that are specified by the
#' account IDs from their master account
#'
#' Disassociates the Security Hub member accounts that are specified by the
#' account IDs from their master account.
#'
#' @usage
#' securityhub_disassociate_members(AccountIds)
#'
#' @param AccountIds The account IDs of the member accounts that you want to disassociate
#' from the master account.
#'
#' @section Request syntax:
#' ```
#' svc$disassociate_members(
#'   AccountIds = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname securityhub_disassociate_members
securityhub_disassociate_members <- function(AccountIds = NULL) {
  op <- new_operation(
    name = "DisassociateMembers",
    http_method = "POST",
    http_path = "/members/disassociate",
    paginator = list()
  )
  input <- .securityhub$disassociate_members_input(AccountIds = AccountIds)
  output <- .securityhub$disassociate_members_output()
  svc <- .securityhub$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$disassociate_members <- securityhub_disassociate_members

#' Enables you to import findings generated by integrated third-party
#' providers into Security Hub
#'
#' Enables you to import findings generated by integrated third-party
#' providers into Security Hub.
#'
#' @usage
#' securityhub_enable_import_findings_for_product(ProductArn)
#'
#' @param ProductArn &#91;required&#93; The ARN of the product that generates findings that you want to import
#' into Security Hub.
#'
#' @section Request syntax:
#' ```
#' svc$enable_import_findings_for_product(
#'   ProductArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname securityhub_enable_import_findings_for_product
securityhub_enable_import_findings_for_product <- function(ProductArn) {
  op <- new_operation(
    name = "EnableImportFindingsForProduct",
    http_method = "POST",
    http_path = "/productSubscriptions",
    paginator = list()
  )
  input <- .securityhub$enable_import_findings_for_product_input(ProductArn = ProductArn)
  output <- .securityhub$enable_import_findings_for_product_output()
  svc <- .securityhub$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$enable_import_findings_for_product <- securityhub_enable_import_findings_for_product

#' Enables the AWS Security Hub service
#'
#' Enables the AWS Security Hub service.
#'
#' @usage
#' securityhub_enable_security_hub()
#'
#' @section Request syntax:
#' ```
#' svc$enable_security_hub()
#' ```
#'
#' @keywords internal
#'
#' @rdname securityhub_enable_security_hub
securityhub_enable_security_hub <- function() {
  op <- new_operation(
    name = "EnableSecurityHub",
    http_method = "POST",
    http_path = "/accounts",
    paginator = list()
  )
  input <- .securityhub$enable_security_hub_input()
  output <- .securityhub$enable_security_hub_output()
  svc <- .securityhub$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$enable_security_hub <- securityhub_enable_security_hub

#' Lists and describes enabled standards
#'
#' Lists and describes enabled standards.
#'
#' @usage
#' securityhub_get_enabled_standards(StandardsSubscriptionArns, NextToken,
#'   MaxResults)
#'
#' @param StandardsSubscriptionArns The list of standards subscription ARNS that you want to list and
#' describe.
#' @param NextToken Paginates results. Set the value of this parameter to NULL on your first
#' call to the GetEnabledStandards operation. For subsequent calls to the
#' operation, fill nextToken in the request with the value of nextToken
#' from the previous response to continue listing data.
#' @param MaxResults Indicates the maximum number of items that you want in the response.
#'
#' @section Request syntax:
#' ```
#' svc$get_enabled_standards(
#'   StandardsSubscriptionArns = list(
#'     "string"
#'   ),
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname securityhub_get_enabled_standards
securityhub_get_enabled_standards <- function(StandardsSubscriptionArns = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "GetEnabledStandards",
    http_method = "POST",
    http_path = "/standards/get",
    paginator = list()
  )
  input <- .securityhub$get_enabled_standards_input(StandardsSubscriptionArns = StandardsSubscriptionArns, NextToken = NextToken, MaxResults = MaxResults)
  output <- .securityhub$get_enabled_standards_output()
  svc <- .securityhub$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$get_enabled_standards <- securityhub_get_enabled_standards

#' Lists and describes Security Hub-aggregated findings that are specified
#' by filter attributes
#'
#' Lists and describes Security Hub-aggregated findings that are specified
#' by filter attributes.
#'
#' @usage
#' securityhub_get_findings(Filters, SortCriteria, NextToken, MaxResults)
#'
#' @param Filters A collection of attributes that is use for querying findings.
#' @param SortCriteria A collection of attributes used for sorting findings.
#' @param NextToken Paginates results. Set the value of this parameter to NULL on your first
#' call to the GetFindings operation. For subsequent calls to the
#' operation, fill nextToken in the request with the value of nextToken
#' from the previous response to continue listing data.
#' @param MaxResults Indicates the maximum number of items that you want in the response.
#'
#' @section Request syntax:
#' ```
#' svc$get_findings(
#'   Filters = list(
#'     ProductArn = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     AwsAccountId = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     Id = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     GeneratorId = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     Type = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     FirstObservedAt = list(
#'       list(
#'         Start = "string",
#'         End = "string",
#'         DateRange = list(
#'           Value = 123,
#'           Unit = "DAYS"
#'         )
#'       )
#'     ),
#'     LastObservedAt = list(
#'       list(
#'         Start = "string",
#'         End = "string",
#'         DateRange = list(
#'           Value = 123,
#'           Unit = "DAYS"
#'         )
#'       )
#'     ),
#'     CreatedAt = list(
#'       list(
#'         Start = "string",
#'         End = "string",
#'         DateRange = list(
#'           Value = 123,
#'           Unit = "DAYS"
#'         )
#'       )
#'     ),
#'     UpdatedAt = list(
#'       list(
#'         Start = "string",
#'         End = "string",
#'         DateRange = list(
#'           Value = 123,
#'           Unit = "DAYS"
#'         )
#'       )
#'     ),
#'     SeverityProduct = list(
#'       list(
#'         Gte = 123.0,
#'         Lte = 123.0,
#'         Eq = 123.0
#'       )
#'     ),
#'     SeverityNormalized = list(
#'       list(
#'         Gte = 123.0,
#'         Lte = 123.0,
#'         Eq = 123.0
#'       )
#'     ),
#'     SeverityLabel = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     Confidence = list(
#'       list(
#'         Gte = 123.0,
#'         Lte = 123.0,
#'         Eq = 123.0
#'       )
#'     ),
#'     Criticality = list(
#'       list(
#'         Gte = 123.0,
#'         Lte = 123.0,
#'         Eq = 123.0
#'       )
#'     ),
#'     Title = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     Description = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     RecommendationText = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     SourceUrl = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     ProductFields = list(
#'       list(
#'         Key = "string",
#'         Value = "string",
#'         Comparison = "CONTAINS"
#'       )
#'     ),
#'     ProductName = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     CompanyName = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     UserDefinedFields = list(
#'       list(
#'         Key = "string",
#'         Value = "string",
#'         Comparison = "CONTAINS"
#'       )
#'     ),
#'     MalwareName = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     MalwareType = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     MalwarePath = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     MalwareState = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     NetworkDirection = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     NetworkProtocol = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     NetworkSourceIpV4 = list(
#'       list(
#'         Cidr = "string"
#'       )
#'     ),
#'     NetworkSourceIpV6 = list(
#'       list(
#'         Cidr = "string"
#'       )
#'     ),
#'     NetworkSourcePort = list(
#'       list(
#'         Gte = 123.0,
#'         Lte = 123.0,
#'         Eq = 123.0
#'       )
#'     ),
#'     NetworkSourceDomain = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     NetworkSourceMac = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     NetworkDestinationIpV4 = list(
#'       list(
#'         Cidr = "string"
#'       )
#'     ),
#'     NetworkDestinationIpV6 = list(
#'       list(
#'         Cidr = "string"
#'       )
#'     ),
#'     NetworkDestinationPort = list(
#'       list(
#'         Gte = 123.0,
#'         Lte = 123.0,
#'         Eq = 123.0
#'       )
#'     ),
#'     NetworkDestinationDomain = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     ProcessName = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     ProcessPath = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     ProcessPid = list(
#'       list(
#'         Gte = 123.0,
#'         Lte = 123.0,
#'         Eq = 123.0
#'       )
#'     ),
#'     ProcessParentPid = list(
#'       list(
#'         Gte = 123.0,
#'         Lte = 123.0,
#'         Eq = 123.0
#'       )
#'     ),
#'     ProcessLaunchedAt = list(
#'       list(
#'         Start = "string",
#'         End = "string",
#'         DateRange = list(
#'           Value = 123,
#'           Unit = "DAYS"
#'         )
#'       )
#'     ),
#'     ProcessTerminatedAt = list(
#'       list(
#'         Start = "string",
#'         End = "string",
#'         DateRange = list(
#'           Value = 123,
#'           Unit = "DAYS"
#'         )
#'       )
#'     ),
#'     ThreatIntelIndicatorType = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     ThreatIntelIndicatorValue = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     ThreatIntelIndicatorCategory = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     ThreatIntelIndicatorLastObservedAt = list(
#'       list(
#'         Start = "string",
#'         End = "string",
#'         DateRange = list(
#'           Value = 123,
#'           Unit = "DAYS"
#'         )
#'       )
#'     ),
#'     ThreatIntelIndicatorSource = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     ThreatIntelIndicatorSourceUrl = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     ResourceType = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     ResourceId = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     ResourcePartition = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     ResourceRegion = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     ResourceTags = list(
#'       list(
#'         Key = "string",
#'         Value = "string",
#'         Comparison = "CONTAINS"
#'       )
#'     ),
#'     ResourceAwsEc2InstanceType = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     ResourceAwsEc2InstanceImageId = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     ResourceAwsEc2InstanceIpV4Addresses = list(
#'       list(
#'         Cidr = "string"
#'       )
#'     ),
#'     ResourceAwsEc2InstanceIpV6Addresses = list(
#'       list(
#'         Cidr = "string"
#'       )
#'     ),
#'     ResourceAwsEc2InstanceKeyName = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     ResourceAwsEc2InstanceIamInstanceProfileArn = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     ResourceAwsEc2InstanceVpcId = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     ResourceAwsEc2InstanceSubnetId = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     ResourceAwsEc2InstanceLaunchedAt = list(
#'       list(
#'         Start = "string",
#'         End = "string",
#'         DateRange = list(
#'           Value = 123,
#'           Unit = "DAYS"
#'         )
#'       )
#'     ),
#'     ResourceAwsS3BucketOwnerId = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     ResourceAwsS3BucketOwnerName = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     ResourceAwsIamAccessKeyUserName = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     ResourceAwsIamAccessKeyStatus = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     ResourceAwsIamAccessKeyCreatedAt = list(
#'       list(
#'         Start = "string",
#'         End = "string",
#'         DateRange = list(
#'           Value = 123,
#'           Unit = "DAYS"
#'         )
#'       )
#'     ),
#'     ResourceContainerName = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     ResourceContainerImageId = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     ResourceContainerImageName = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     ResourceContainerLaunchedAt = list(
#'       list(
#'         Start = "string",
#'         End = "string",
#'         DateRange = list(
#'           Value = 123,
#'           Unit = "DAYS"
#'         )
#'       )
#'     ),
#'     ResourceDetailsOther = list(
#'       list(
#'         Key = "string",
#'         Value = "string",
#'         Comparison = "CONTAINS"
#'       )
#'     ),
#'     ComplianceStatus = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     VerificationState = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     WorkflowState = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     RecordState = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     RelatedFindingsProductArn = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     RelatedFindingsId = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     NoteText = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     NoteUpdatedAt = list(
#'       list(
#'         Start = "string",
#'         End = "string",
#'         DateRange = list(
#'           Value = 123,
#'           Unit = "DAYS"
#'         )
#'       )
#'     ),
#'     NoteUpdatedBy = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     Keyword = list(
#'       list(
#'         Value = "string"
#'       )
#'     )
#'   ),
#'   SortCriteria = list(
#'     list(
#'       Field = "string",
#'       SortOrder = "asc"|"desc"
#'     )
#'   ),
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname securityhub_get_findings
securityhub_get_findings <- function(Filters = NULL, SortCriteria = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "GetFindings",
    http_method = "POST",
    http_path = "/findings",
    paginator = list()
  )
  input <- .securityhub$get_findings_input(Filters = Filters, SortCriteria = SortCriteria, NextToken = NextToken, MaxResults = MaxResults)
  output <- .securityhub$get_findings_output()
  svc <- .securityhub$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$get_findings <- securityhub_get_findings

#' Lists the results of the Security Hub insight specified by the insight
#' ARN
#'
#' Lists the results of the Security Hub insight specified by the insight
#' ARN.
#'
#' @usage
#' securityhub_get_insight_results(InsightArn)
#'
#' @param InsightArn &#91;required&#93; The ARN of the insight whose results you want to see.
#'
#' @section Request syntax:
#' ```
#' svc$get_insight_results(
#'   InsightArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname securityhub_get_insight_results
securityhub_get_insight_results <- function(InsightArn) {
  op <- new_operation(
    name = "GetInsightResults",
    http_method = "GET",
    http_path = "/insights/results/{InsightArn+}",
    paginator = list()
  )
  input <- .securityhub$get_insight_results_input(InsightArn = InsightArn)
  output <- .securityhub$get_insight_results_output()
  svc <- .securityhub$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$get_insight_results <- securityhub_get_insight_results

#' Lists and describes insights that are specified by insight ARNs
#'
#' Lists and describes insights that are specified by insight ARNs.
#'
#' @usage
#' securityhub_get_insights(InsightArns, NextToken, MaxResults)
#'
#' @param InsightArns The ARNS of the insights that you want to describe.
#' @param NextToken Paginates results. Set the value of this parameter to NULL on your first
#' call to the GetInsights operation. For subsequent calls to the
#' operation, fill nextToken in the request with the value of nextToken
#' from the previous response to continue listing data.
#' @param MaxResults Indicates the maximum number of items that you want in the response.
#'
#' @section Request syntax:
#' ```
#' svc$get_insights(
#'   InsightArns = list(
#'     "string"
#'   ),
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname securityhub_get_insights
securityhub_get_insights <- function(InsightArns = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "GetInsights",
    http_method = "POST",
    http_path = "/insights/get",
    paginator = list()
  )
  input <- .securityhub$get_insights_input(InsightArns = InsightArns, NextToken = NextToken, MaxResults = MaxResults)
  output <- .securityhub$get_insights_output()
  svc <- .securityhub$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$get_insights <- securityhub_get_insights

#' Returns the count of all Security Hub membership invitations that were
#' sent to the current member account, not including the currently accepted
#' invitation
#'
#' Returns the count of all Security Hub membership invitations that were
#' sent to the current member account, not including the currently accepted
#' invitation.
#'
#' @usage
#' securityhub_get_invitations_count()
#'
#' @section Request syntax:
#' ```
#' svc$get_invitations_count()
#' ```
#'
#' @keywords internal
#'
#' @rdname securityhub_get_invitations_count
securityhub_get_invitations_count <- function() {
  op <- new_operation(
    name = "GetInvitationsCount",
    http_method = "GET",
    http_path = "/invitations/count",
    paginator = list()
  )
  input <- .securityhub$get_invitations_count_input()
  output <- .securityhub$get_invitations_count_output()
  svc <- .securityhub$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$get_invitations_count <- securityhub_get_invitations_count

#' Provides the details for the Security Hub master account to the current
#' member account
#'
#' Provides the details for the Security Hub master account to the current
#' member account.
#'
#' @usage
#' securityhub_get_master_account()
#'
#' @section Request syntax:
#' ```
#' svc$get_master_account()
#' ```
#'
#' @keywords internal
#'
#' @rdname securityhub_get_master_account
securityhub_get_master_account <- function() {
  op <- new_operation(
    name = "GetMasterAccount",
    http_method = "GET",
    http_path = "/master",
    paginator = list()
  )
  input <- .securityhub$get_master_account_input()
  output <- .securityhub$get_master_account_output()
  svc <- .securityhub$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$get_master_account <- securityhub_get_master_account

#' Returns the details on the Security Hub member accounts that are
#' specified by the account IDs
#'
#' Returns the details on the Security Hub member accounts that are
#' specified by the account IDs.
#'
#' @usage
#' securityhub_get_members(AccountIds)
#'
#' @param AccountIds &#91;required&#93; A list of account IDs for the Security Hub member accounts on which you
#' want to return the details.
#'
#' @section Request syntax:
#' ```
#' svc$get_members(
#'   AccountIds = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname securityhub_get_members
securityhub_get_members <- function(AccountIds) {
  op <- new_operation(
    name = "GetMembers",
    http_method = "POST",
    http_path = "/members/get",
    paginator = list()
  )
  input <- .securityhub$get_members_input(AccountIds = AccountIds)
  output <- .securityhub$get_members_output()
  svc <- .securityhub$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$get_members <- securityhub_get_members

#' Invites other AWS accounts to enable Security Hub and become Security
#' Hub member accounts
#'
#' Invites other AWS accounts to enable Security Hub and become Security
#' Hub member accounts. When an account accepts the invitation and becomes
#' a member account, the master account can view Security Hub findings of
#' the member account.
#'
#' @usage
#' securityhub_invite_members(AccountIds)
#'
#' @param AccountIds A list of IDs of the AWS accounts that you want to invite to Security
#' Hub as members.
#'
#' @section Request syntax:
#' ```
#' svc$invite_members(
#'   AccountIds = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname securityhub_invite_members
securityhub_invite_members <- function(AccountIds = NULL) {
  op <- new_operation(
    name = "InviteMembers",
    http_method = "POST",
    http_path = "/members/invite",
    paginator = list()
  )
  input <- .securityhub$invite_members_input(AccountIds = AccountIds)
  output <- .securityhub$invite_members_output()
  svc <- .securityhub$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$invite_members <- securityhub_invite_members

#' Lists all Security Hub-integrated third-party findings providers
#'
#' Lists all Security Hub-integrated third-party findings providers.
#'
#' @usage
#' securityhub_list_enabled_products_for_import(NextToken, MaxResults)
#'
#' @param NextToken Paginates results. Set the value of this parameter to NULL on your first
#' call to the ListEnabledProductsForImport operation. For subsequent calls
#' to the operation, fill nextToken in the request with the value of
#' NextToken from the previous response to continue listing data.
#' @param MaxResults Indicates the maximum number of items that you want in the response.
#'
#' @section Request syntax:
#' ```
#' svc$list_enabled_products_for_import(
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname securityhub_list_enabled_products_for_import
securityhub_list_enabled_products_for_import <- function(NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListEnabledProductsForImport",
    http_method = "GET",
    http_path = "/productSubscriptions",
    paginator = list()
  )
  input <- .securityhub$list_enabled_products_for_import_input(NextToken = NextToken, MaxResults = MaxResults)
  output <- .securityhub$list_enabled_products_for_import_output()
  svc <- .securityhub$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$list_enabled_products_for_import <- securityhub_list_enabled_products_for_import

#' Lists all Security Hub membership invitations that were sent to the
#' current AWS account
#'
#' Lists all Security Hub membership invitations that were sent to the
#' current AWS account.
#'
#' @usage
#' securityhub_list_invitations(MaxResults, NextToken)
#'
#' @param MaxResults Indicates the maximum number of items that you want in the response.
#' @param NextToken Paginates results. Set the value of this parameter to NULL on your first
#' call to the ListInvitations operation. For subsequent calls to the
#' operation, fill nextToken in the request with the value of NextToken
#' from the previous response to continue listing data.
#'
#' @section Request syntax:
#' ```
#' svc$list_invitations(
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname securityhub_list_invitations
securityhub_list_invitations <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListInvitations",
    http_method = "GET",
    http_path = "/invitations",
    paginator = list()
  )
  input <- .securityhub$list_invitations_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .securityhub$list_invitations_output()
  svc <- .securityhub$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$list_invitations <- securityhub_list_invitations

#' Lists details about all member accounts for the current Security Hub
#' master account
#'
#' Lists details about all member accounts for the current Security Hub
#' master account.
#'
#' @usage
#' securityhub_list_members(OnlyAssociated, MaxResults, NextToken)
#'
#' @param OnlyAssociated Specifies what member accounts the response includes based on their
#' relationship status with the master account. The default value is TRUE.
#' If onlyAssociated is set to TRUE, the response includes member accounts
#' whose relationship status with the master is set to ENABLED or DISABLED.
#' If onlyAssociated is set to FALSE, the response includes all existing
#' member accounts.
#' @param MaxResults Indicates the maximum number of items that you want in the response.
#' @param NextToken Paginates results. Set the value of this parameter to NULL on your first
#' call to the ListMembers operation. For subsequent calls to the
#' operation, fill nextToken in the request with the value of NextToken
#' from the previous response to continue listing data.
#'
#' @section Request syntax:
#' ```
#' svc$list_members(
#'   OnlyAssociated = TRUE|FALSE,
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname securityhub_list_members
securityhub_list_members <- function(OnlyAssociated = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListMembers",
    http_method = "GET",
    http_path = "/members",
    paginator = list()
  )
  input <- .securityhub$list_members_input(OnlyAssociated = OnlyAssociated, MaxResults = MaxResults, NextToken = NextToken)
  output <- .securityhub$list_members_output()
  svc <- .securityhub$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$list_members <- securityhub_list_members

#' Updates the AWS Security Hub-aggregated findings specified by the filter
#' attributes
#'
#' Updates the AWS Security Hub-aggregated findings specified by the filter
#' attributes.
#'
#' @usage
#' securityhub_update_findings(Filters, Note, RecordState)
#'
#' @param Filters &#91;required&#93; A collection of attributes that specify what findings you want to
#' update.
#' @param Note The updated note for the finding.
#' @param RecordState The updated record state for the finding.
#'
#' @section Request syntax:
#' ```
#' svc$update_findings(
#'   Filters = list(
#'     ProductArn = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     AwsAccountId = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     Id = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     GeneratorId = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     Type = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     FirstObservedAt = list(
#'       list(
#'         Start = "string",
#'         End = "string",
#'         DateRange = list(
#'           Value = 123,
#'           Unit = "DAYS"
#'         )
#'       )
#'     ),
#'     LastObservedAt = list(
#'       list(
#'         Start = "string",
#'         End = "string",
#'         DateRange = list(
#'           Value = 123,
#'           Unit = "DAYS"
#'         )
#'       )
#'     ),
#'     CreatedAt = list(
#'       list(
#'         Start = "string",
#'         End = "string",
#'         DateRange = list(
#'           Value = 123,
#'           Unit = "DAYS"
#'         )
#'       )
#'     ),
#'     UpdatedAt = list(
#'       list(
#'         Start = "string",
#'         End = "string",
#'         DateRange = list(
#'           Value = 123,
#'           Unit = "DAYS"
#'         )
#'       )
#'     ),
#'     SeverityProduct = list(
#'       list(
#'         Gte = 123.0,
#'         Lte = 123.0,
#'         Eq = 123.0
#'       )
#'     ),
#'     SeverityNormalized = list(
#'       list(
#'         Gte = 123.0,
#'         Lte = 123.0,
#'         Eq = 123.0
#'       )
#'     ),
#'     SeverityLabel = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     Confidence = list(
#'       list(
#'         Gte = 123.0,
#'         Lte = 123.0,
#'         Eq = 123.0
#'       )
#'     ),
#'     Criticality = list(
#'       list(
#'         Gte = 123.0,
#'         Lte = 123.0,
#'         Eq = 123.0
#'       )
#'     ),
#'     Title = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     Description = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     RecommendationText = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     SourceUrl = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     ProductFields = list(
#'       list(
#'         Key = "string",
#'         Value = "string",
#'         Comparison = "CONTAINS"
#'       )
#'     ),
#'     ProductName = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     CompanyName = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     UserDefinedFields = list(
#'       list(
#'         Key = "string",
#'         Value = "string",
#'         Comparison = "CONTAINS"
#'       )
#'     ),
#'     MalwareName = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     MalwareType = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     MalwarePath = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     MalwareState = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     NetworkDirection = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     NetworkProtocol = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     NetworkSourceIpV4 = list(
#'       list(
#'         Cidr = "string"
#'       )
#'     ),
#'     NetworkSourceIpV6 = list(
#'       list(
#'         Cidr = "string"
#'       )
#'     ),
#'     NetworkSourcePort = list(
#'       list(
#'         Gte = 123.0,
#'         Lte = 123.0,
#'         Eq = 123.0
#'       )
#'     ),
#'     NetworkSourceDomain = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     NetworkSourceMac = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     NetworkDestinationIpV4 = list(
#'       list(
#'         Cidr = "string"
#'       )
#'     ),
#'     NetworkDestinationIpV6 = list(
#'       list(
#'         Cidr = "string"
#'       )
#'     ),
#'     NetworkDestinationPort = list(
#'       list(
#'         Gte = 123.0,
#'         Lte = 123.0,
#'         Eq = 123.0
#'       )
#'     ),
#'     NetworkDestinationDomain = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     ProcessName = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     ProcessPath = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     ProcessPid = list(
#'       list(
#'         Gte = 123.0,
#'         Lte = 123.0,
#'         Eq = 123.0
#'       )
#'     ),
#'     ProcessParentPid = list(
#'       list(
#'         Gte = 123.0,
#'         Lte = 123.0,
#'         Eq = 123.0
#'       )
#'     ),
#'     ProcessLaunchedAt = list(
#'       list(
#'         Start = "string",
#'         End = "string",
#'         DateRange = list(
#'           Value = 123,
#'           Unit = "DAYS"
#'         )
#'       )
#'     ),
#'     ProcessTerminatedAt = list(
#'       list(
#'         Start = "string",
#'         End = "string",
#'         DateRange = list(
#'           Value = 123,
#'           Unit = "DAYS"
#'         )
#'       )
#'     ),
#'     ThreatIntelIndicatorType = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     ThreatIntelIndicatorValue = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     ThreatIntelIndicatorCategory = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     ThreatIntelIndicatorLastObservedAt = list(
#'       list(
#'         Start = "string",
#'         End = "string",
#'         DateRange = list(
#'           Value = 123,
#'           Unit = "DAYS"
#'         )
#'       )
#'     ),
#'     ThreatIntelIndicatorSource = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     ThreatIntelIndicatorSourceUrl = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     ResourceType = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     ResourceId = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     ResourcePartition = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     ResourceRegion = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     ResourceTags = list(
#'       list(
#'         Key = "string",
#'         Value = "string",
#'         Comparison = "CONTAINS"
#'       )
#'     ),
#'     ResourceAwsEc2InstanceType = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     ResourceAwsEc2InstanceImageId = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     ResourceAwsEc2InstanceIpV4Addresses = list(
#'       list(
#'         Cidr = "string"
#'       )
#'     ),
#'     ResourceAwsEc2InstanceIpV6Addresses = list(
#'       list(
#'         Cidr = "string"
#'       )
#'     ),
#'     ResourceAwsEc2InstanceKeyName = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     ResourceAwsEc2InstanceIamInstanceProfileArn = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     ResourceAwsEc2InstanceVpcId = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     ResourceAwsEc2InstanceSubnetId = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     ResourceAwsEc2InstanceLaunchedAt = list(
#'       list(
#'         Start = "string",
#'         End = "string",
#'         DateRange = list(
#'           Value = 123,
#'           Unit = "DAYS"
#'         )
#'       )
#'     ),
#'     ResourceAwsS3BucketOwnerId = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     ResourceAwsS3BucketOwnerName = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     ResourceAwsIamAccessKeyUserName = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     ResourceAwsIamAccessKeyStatus = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     ResourceAwsIamAccessKeyCreatedAt = list(
#'       list(
#'         Start = "string",
#'         End = "string",
#'         DateRange = list(
#'           Value = 123,
#'           Unit = "DAYS"
#'         )
#'       )
#'     ),
#'     ResourceContainerName = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     ResourceContainerImageId = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     ResourceContainerImageName = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     ResourceContainerLaunchedAt = list(
#'       list(
#'         Start = "string",
#'         End = "string",
#'         DateRange = list(
#'           Value = 123,
#'           Unit = "DAYS"
#'         )
#'       )
#'     ),
#'     ResourceDetailsOther = list(
#'       list(
#'         Key = "string",
#'         Value = "string",
#'         Comparison = "CONTAINS"
#'       )
#'     ),
#'     ComplianceStatus = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     VerificationState = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     WorkflowState = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     RecordState = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     RelatedFindingsProductArn = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     RelatedFindingsId = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     NoteText = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     NoteUpdatedAt = list(
#'       list(
#'         Start = "string",
#'         End = "string",
#'         DateRange = list(
#'           Value = 123,
#'           Unit = "DAYS"
#'         )
#'       )
#'     ),
#'     NoteUpdatedBy = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     Keyword = list(
#'       list(
#'         Value = "string"
#'       )
#'     )
#'   ),
#'   Note = list(
#'     Text = "string",
#'     UpdatedBy = "string"
#'   ),
#'   RecordState = "ACTIVE"|"ARCHIVED"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname securityhub_update_findings
securityhub_update_findings <- function(Filters, Note = NULL, RecordState = NULL) {
  op <- new_operation(
    name = "UpdateFindings",
    http_method = "PATCH",
    http_path = "/findings",
    paginator = list()
  )
  input <- .securityhub$update_findings_input(Filters = Filters, Note = Note, RecordState = RecordState)
  output <- .securityhub$update_findings_output()
  svc <- .securityhub$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$update_findings <- securityhub_update_findings

#' Updates the AWS Security Hub insight specified by the insight ARN
#'
#' Updates the AWS Security Hub insight specified by the insight ARN.
#'
#' @usage
#' securityhub_update_insight(InsightArn, Name, Filters, GroupByAttribute)
#'
#' @param InsightArn &#91;required&#93; The ARN of the insight that you want to update.
#' @param Name The updated name for the insight.
#' @param Filters The updated filters that define this insight.
#' @param GroupByAttribute The updated GroupBy attribute that defines this insight.
#'
#' @section Request syntax:
#' ```
#' svc$update_insight(
#'   InsightArn = "string",
#'   Name = "string",
#'   Filters = list(
#'     ProductArn = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     AwsAccountId = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     Id = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     GeneratorId = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     Type = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     FirstObservedAt = list(
#'       list(
#'         Start = "string",
#'         End = "string",
#'         DateRange = list(
#'           Value = 123,
#'           Unit = "DAYS"
#'         )
#'       )
#'     ),
#'     LastObservedAt = list(
#'       list(
#'         Start = "string",
#'         End = "string",
#'         DateRange = list(
#'           Value = 123,
#'           Unit = "DAYS"
#'         )
#'       )
#'     ),
#'     CreatedAt = list(
#'       list(
#'         Start = "string",
#'         End = "string",
#'         DateRange = list(
#'           Value = 123,
#'           Unit = "DAYS"
#'         )
#'       )
#'     ),
#'     UpdatedAt = list(
#'       list(
#'         Start = "string",
#'         End = "string",
#'         DateRange = list(
#'           Value = 123,
#'           Unit = "DAYS"
#'         )
#'       )
#'     ),
#'     SeverityProduct = list(
#'       list(
#'         Gte = 123.0,
#'         Lte = 123.0,
#'         Eq = 123.0
#'       )
#'     ),
#'     SeverityNormalized = list(
#'       list(
#'         Gte = 123.0,
#'         Lte = 123.0,
#'         Eq = 123.0
#'       )
#'     ),
#'     SeverityLabel = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     Confidence = list(
#'       list(
#'         Gte = 123.0,
#'         Lte = 123.0,
#'         Eq = 123.0
#'       )
#'     ),
#'     Criticality = list(
#'       list(
#'         Gte = 123.0,
#'         Lte = 123.0,
#'         Eq = 123.0
#'       )
#'     ),
#'     Title = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     Description = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     RecommendationText = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     SourceUrl = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     ProductFields = list(
#'       list(
#'         Key = "string",
#'         Value = "string",
#'         Comparison = "CONTAINS"
#'       )
#'     ),
#'     ProductName = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     CompanyName = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     UserDefinedFields = list(
#'       list(
#'         Key = "string",
#'         Value = "string",
#'         Comparison = "CONTAINS"
#'       )
#'     ),
#'     MalwareName = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     MalwareType = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     MalwarePath = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     MalwareState = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     NetworkDirection = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     NetworkProtocol = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     NetworkSourceIpV4 = list(
#'       list(
#'         Cidr = "string"
#'       )
#'     ),
#'     NetworkSourceIpV6 = list(
#'       list(
#'         Cidr = "string"
#'       )
#'     ),
#'     NetworkSourcePort = list(
#'       list(
#'         Gte = 123.0,
#'         Lte = 123.0,
#'         Eq = 123.0
#'       )
#'     ),
#'     NetworkSourceDomain = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     NetworkSourceMac = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     NetworkDestinationIpV4 = list(
#'       list(
#'         Cidr = "string"
#'       )
#'     ),
#'     NetworkDestinationIpV6 = list(
#'       list(
#'         Cidr = "string"
#'       )
#'     ),
#'     NetworkDestinationPort = list(
#'       list(
#'         Gte = 123.0,
#'         Lte = 123.0,
#'         Eq = 123.0
#'       )
#'     ),
#'     NetworkDestinationDomain = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     ProcessName = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     ProcessPath = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     ProcessPid = list(
#'       list(
#'         Gte = 123.0,
#'         Lte = 123.0,
#'         Eq = 123.0
#'       )
#'     ),
#'     ProcessParentPid = list(
#'       list(
#'         Gte = 123.0,
#'         Lte = 123.0,
#'         Eq = 123.0
#'       )
#'     ),
#'     ProcessLaunchedAt = list(
#'       list(
#'         Start = "string",
#'         End = "string",
#'         DateRange = list(
#'           Value = 123,
#'           Unit = "DAYS"
#'         )
#'       )
#'     ),
#'     ProcessTerminatedAt = list(
#'       list(
#'         Start = "string",
#'         End = "string",
#'         DateRange = list(
#'           Value = 123,
#'           Unit = "DAYS"
#'         )
#'       )
#'     ),
#'     ThreatIntelIndicatorType = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     ThreatIntelIndicatorValue = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     ThreatIntelIndicatorCategory = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     ThreatIntelIndicatorLastObservedAt = list(
#'       list(
#'         Start = "string",
#'         End = "string",
#'         DateRange = list(
#'           Value = 123,
#'           Unit = "DAYS"
#'         )
#'       )
#'     ),
#'     ThreatIntelIndicatorSource = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     ThreatIntelIndicatorSourceUrl = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     ResourceType = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     ResourceId = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     ResourcePartition = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     ResourceRegion = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     ResourceTags = list(
#'       list(
#'         Key = "string",
#'         Value = "string",
#'         Comparison = "CONTAINS"
#'       )
#'     ),
#'     ResourceAwsEc2InstanceType = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     ResourceAwsEc2InstanceImageId = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     ResourceAwsEc2InstanceIpV4Addresses = list(
#'       list(
#'         Cidr = "string"
#'       )
#'     ),
#'     ResourceAwsEc2InstanceIpV6Addresses = list(
#'       list(
#'         Cidr = "string"
#'       )
#'     ),
#'     ResourceAwsEc2InstanceKeyName = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     ResourceAwsEc2InstanceIamInstanceProfileArn = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     ResourceAwsEc2InstanceVpcId = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     ResourceAwsEc2InstanceSubnetId = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     ResourceAwsEc2InstanceLaunchedAt = list(
#'       list(
#'         Start = "string",
#'         End = "string",
#'         DateRange = list(
#'           Value = 123,
#'           Unit = "DAYS"
#'         )
#'       )
#'     ),
#'     ResourceAwsS3BucketOwnerId = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     ResourceAwsS3BucketOwnerName = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     ResourceAwsIamAccessKeyUserName = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     ResourceAwsIamAccessKeyStatus = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     ResourceAwsIamAccessKeyCreatedAt = list(
#'       list(
#'         Start = "string",
#'         End = "string",
#'         DateRange = list(
#'           Value = 123,
#'           Unit = "DAYS"
#'         )
#'       )
#'     ),
#'     ResourceContainerName = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     ResourceContainerImageId = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     ResourceContainerImageName = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     ResourceContainerLaunchedAt = list(
#'       list(
#'         Start = "string",
#'         End = "string",
#'         DateRange = list(
#'           Value = 123,
#'           Unit = "DAYS"
#'         )
#'       )
#'     ),
#'     ResourceDetailsOther = list(
#'       list(
#'         Key = "string",
#'         Value = "string",
#'         Comparison = "CONTAINS"
#'       )
#'     ),
#'     ComplianceStatus = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     VerificationState = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     WorkflowState = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     RecordState = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     RelatedFindingsProductArn = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     RelatedFindingsId = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     NoteText = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     NoteUpdatedAt = list(
#'       list(
#'         Start = "string",
#'         End = "string",
#'         DateRange = list(
#'           Value = 123,
#'           Unit = "DAYS"
#'         )
#'       )
#'     ),
#'     NoteUpdatedBy = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
#'       )
#'     ),
#'     Keyword = list(
#'       list(
#'         Value = "string"
#'       )
#'     )
#'   ),
#'   GroupByAttribute = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname securityhub_update_insight
securityhub_update_insight <- function(InsightArn, Name = NULL, Filters = NULL, GroupByAttribute = NULL) {
  op <- new_operation(
    name = "UpdateInsight",
    http_method = "PATCH",
    http_path = "/insights/{InsightArn+}",
    paginator = list()
  )
  input <- .securityhub$update_insight_input(InsightArn = InsightArn, Name = Name, Filters = Filters, GroupByAttribute = GroupByAttribute)
  output <- .securityhub$update_insight_output()
  svc <- .securityhub$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$update_insight <- securityhub_update_insight
