% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kms_operations.R
\name{kms_revoke_grant}
\alias{kms_revoke_grant}
\title{Revokes the specified grant for the specified customer master key (CMK)}
\usage{
kms_revoke_grant(KeyId, GrantId)
}
\arguments{
\item{KeyId}{[required] A unique identifier for the customer master key associated with the
grant.

Specify the key ID or the Amazon Resource Name (ARN) of the CMK. To
specify a CMK in a different AWS account, you must use the key ARN.

For example:
\itemize{
\item Key ID: \verb{1234abcd-12ab-34cd-56ef-1234567890ab}
\item Key ARN:
\verb{arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab}
}

To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey.}

\item{GrantId}{[required] Identifier of the grant to be revoked.}
}
\description{
Revokes the specified grant for the specified customer master key (CMK).
You can revoke a grant to actively deny operations that depend on it.

\strong{Cross-account use}: Yes. To perform this operation on a CMK in a
different AWS account, specify the key ARN in the value of the \code{KeyId}
parameter.

\strong{Required permissions}:
\href{https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html}{kms:RevokeGrant}
(key policy)

\strong{Related operations:}
\itemize{
\item CreateGrant
\item ListGrants
\item ListRetirableGrants
\item RetireGrant
}
}
\section{Request syntax}{
\preformatted{svc$revoke_grant(
  KeyId = "string",
  GrantId = "string"
)
}
}

\examples{
\dontrun{
# The following example revokes a grant.
svc$revoke_grant(
  GrantId = "0c237476b39f8bc44e45212e08498fbe3151305030726c0590dd8d3e9f3d6a60",
  KeyId = "1234abcd-12ab-34cd-56ef-1234567890ab"
)
}

}
\keyword{internal}
