% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/securityhub_operations.R
\name{securityhub_get_findings}
\alias{securityhub_get_findings}
\title{Returns a list of findings that match the specified criteria}
\usage{
securityhub_get_findings(Filters, SortCriteria, NextToken, MaxResults)
}
\arguments{
\item{Filters}{The finding attributes used to define a condition to filter the returned
findings.

You can filter by up to 10 finding attributes. For each attribute, you
can provide up to 20 filter values.

Note that in the available filter fields, \code{WorkflowState} is deprecated.
To search for a finding based on its workflow status, use
\code{WorkflowStatus}.}

\item{SortCriteria}{The finding attributes used to sort the list of returned findings.}

\item{NextToken}{The token that is required for pagination. On your first call to the
\code{GetFindings} operation, set the value of this parameter to \code{NULL}.

For subsequent calls to the operation, to continue listing data, set the
value of this parameter to the value returned from the previous
response.}

\item{MaxResults}{The maximum number of findings to return.}
}
\description{
Returns a list of findings that match the specified criteria.
}
\section{Request syntax}{
\preformatted{svc$get_findings(
  Filters = list(
    ProductArn = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    AwsAccountId = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    Id = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    GeneratorId = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    Type = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    FirstObservedAt = list(
      list(
        Start = "string",
        End = "string",
        DateRange = list(
          Value = 123,
          Unit = "DAYS"
        )
      )
    ),
    LastObservedAt = list(
      list(
        Start = "string",
        End = "string",
        DateRange = list(
          Value = 123,
          Unit = "DAYS"
        )
      )
    ),
    CreatedAt = list(
      list(
        Start = "string",
        End = "string",
        DateRange = list(
          Value = 123,
          Unit = "DAYS"
        )
      )
    ),
    UpdatedAt = list(
      list(
        Start = "string",
        End = "string",
        DateRange = list(
          Value = 123,
          Unit = "DAYS"
        )
      )
    ),
    SeverityProduct = list(
      list(
        Gte = 123.0,
        Lte = 123.0,
        Eq = 123.0
      )
    ),
    SeverityNormalized = list(
      list(
        Gte = 123.0,
        Lte = 123.0,
        Eq = 123.0
      )
    ),
    SeverityLabel = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    Confidence = list(
      list(
        Gte = 123.0,
        Lte = 123.0,
        Eq = 123.0
      )
    ),
    Criticality = list(
      list(
        Gte = 123.0,
        Lte = 123.0,
        Eq = 123.0
      )
    ),
    Title = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    Description = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    RecommendationText = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    SourceUrl = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    ProductFields = list(
      list(
        Key = "string",
        Value = "string",
        Comparison = "EQUALS"|"NOT_EQUALS"
      )
    ),
    ProductName = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    CompanyName = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    UserDefinedFields = list(
      list(
        Key = "string",
        Value = "string",
        Comparison = "EQUALS"|"NOT_EQUALS"
      )
    ),
    MalwareName = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    MalwareType = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    MalwarePath = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    MalwareState = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    NetworkDirection = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    NetworkProtocol = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    NetworkSourceIpV4 = list(
      list(
        Cidr = "string"
      )
    ),
    NetworkSourceIpV6 = list(
      list(
        Cidr = "string"
      )
    ),
    NetworkSourcePort = list(
      list(
        Gte = 123.0,
        Lte = 123.0,
        Eq = 123.0
      )
    ),
    NetworkSourceDomain = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    NetworkSourceMac = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    NetworkDestinationIpV4 = list(
      list(
        Cidr = "string"
      )
    ),
    NetworkDestinationIpV6 = list(
      list(
        Cidr = "string"
      )
    ),
    NetworkDestinationPort = list(
      list(
        Gte = 123.0,
        Lte = 123.0,
        Eq = 123.0
      )
    ),
    NetworkDestinationDomain = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    ProcessName = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    ProcessPath = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    ProcessPid = list(
      list(
        Gte = 123.0,
        Lte = 123.0,
        Eq = 123.0
      )
    ),
    ProcessParentPid = list(
      list(
        Gte = 123.0,
        Lte = 123.0,
        Eq = 123.0
      )
    ),
    ProcessLaunchedAt = list(
      list(
        Start = "string",
        End = "string",
        DateRange = list(
          Value = 123,
          Unit = "DAYS"
        )
      )
    ),
    ProcessTerminatedAt = list(
      list(
        Start = "string",
        End = "string",
        DateRange = list(
          Value = 123,
          Unit = "DAYS"
        )
      )
    ),
    ThreatIntelIndicatorType = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    ThreatIntelIndicatorValue = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    ThreatIntelIndicatorCategory = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    ThreatIntelIndicatorLastObservedAt = list(
      list(
        Start = "string",
        End = "string",
        DateRange = list(
          Value = 123,
          Unit = "DAYS"
        )
      )
    ),
    ThreatIntelIndicatorSource = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    ThreatIntelIndicatorSourceUrl = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    ResourceType = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    ResourceId = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    ResourcePartition = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    ResourceRegion = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    ResourceTags = list(
      list(
        Key = "string",
        Value = "string",
        Comparison = "EQUALS"|"NOT_EQUALS"
      )
    ),
    ResourceAwsEc2InstanceType = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    ResourceAwsEc2InstanceImageId = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    ResourceAwsEc2InstanceIpV4Addresses = list(
      list(
        Cidr = "string"
      )
    ),
    ResourceAwsEc2InstanceIpV6Addresses = list(
      list(
        Cidr = "string"
      )
    ),
    ResourceAwsEc2InstanceKeyName = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    ResourceAwsEc2InstanceIamInstanceProfileArn = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    ResourceAwsEc2InstanceVpcId = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    ResourceAwsEc2InstanceSubnetId = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    ResourceAwsEc2InstanceLaunchedAt = list(
      list(
        Start = "string",
        End = "string",
        DateRange = list(
          Value = 123,
          Unit = "DAYS"
        )
      )
    ),
    ResourceAwsS3BucketOwnerId = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    ResourceAwsS3BucketOwnerName = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    ResourceAwsIamAccessKeyUserName = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    ResourceAwsIamAccessKeyStatus = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    ResourceAwsIamAccessKeyCreatedAt = list(
      list(
        Start = "string",
        End = "string",
        DateRange = list(
          Value = 123,
          Unit = "DAYS"
        )
      )
    ),
    ResourceContainerName = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    ResourceContainerImageId = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    ResourceContainerImageName = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    ResourceContainerLaunchedAt = list(
      list(
        Start = "string",
        End = "string",
        DateRange = list(
          Value = 123,
          Unit = "DAYS"
        )
      )
    ),
    ResourceDetailsOther = list(
      list(
        Key = "string",
        Value = "string",
        Comparison = "EQUALS"|"NOT_EQUALS"
      )
    ),
    ComplianceStatus = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    VerificationState = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    WorkflowState = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    WorkflowStatus = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    RecordState = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    RelatedFindingsProductArn = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    RelatedFindingsId = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    NoteText = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    NoteUpdatedAt = list(
      list(
        Start = "string",
        End = "string",
        DateRange = list(
          Value = 123,
          Unit = "DAYS"
        )
      )
    ),
    NoteUpdatedBy = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    Keyword = list(
      list(
        Value = "string"
      )
    )
  ),
  SortCriteria = list(
    list(
      Field = "string",
      SortOrder = "asc"|"desc"
    )
  ),
  NextToken = "string",
  MaxResults = 123
)
}
}

\keyword{internal}
