% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shield_operations.R
\name{shield_describe_attack}
\alias{shield_describe_attack}
\title{Describes the details of a DDoS attack}
\usage{
shield_describe_attack(AttackId)
}
\arguments{
\item{AttackId}{[required] The unique identifier (ID) for the attack that to be described.}
}
\value{
A list with the following syntax:\preformatted{list(
  Attack = list(
    AttackId = "string",
    ResourceArn = "string",
    SubResources = list(
      list(
        Type = "IP"|"URL",
        Id = "string",
        AttackVectors = list(
          list(
            VectorType = "string",
            VectorCounters = list(
              list(
                Name = "string",
                Max = 123.0,
                Average = 123.0,
                Sum = 123.0,
                N = 123,
                Unit = "string"
              )
            )
          )
        ),
        Counters = list(
          list(
            Name = "string",
            Max = 123.0,
            Average = 123.0,
            Sum = 123.0,
            N = 123,
            Unit = "string"
          )
        )
      )
    ),
    StartTime = as.POSIXct(
      "2015-01-01"
    ),
    EndTime = as.POSIXct(
      "2015-01-01"
    ),
    AttackCounters = list(
      list(
        Name = "string",
        Max = 123.0,
        Average = 123.0,
        Sum = 123.0,
        N = 123,
        Unit = "string"
      )
    ),
    AttackProperties = list(
      list(
        AttackLayer = "NETWORK"|"APPLICATION",
        AttackPropertyIdentifier = "DESTINATION_URL"|"REFERRER"|"SOURCE_ASN"|"SOURCE_COUNTRY"|"SOURCE_IP_ADDRESS"|"SOURCE_USER_AGENT"|"WORDPRESS_PINGBACK_REFLECTOR"|"WORDPRESS_PINGBACK_SOURCE",
        TopContributors = list(
          list(
            Name = "string",
            Value = 123
          )
        ),
        Unit = "BITS"|"BYTES"|"PACKETS"|"REQUESTS",
        Total = 123
      )
    ),
    Mitigations = list(
      list(
        MitigationName = "string"
      )
    )
  )
)
}
}
\description{
Describes the details of a DDoS attack.
}
\section{Request syntax}{
\preformatted{svc$describe_attack(
  AttackId = "string"
)
}
}

\keyword{internal}
