# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_operation new_request send_request
#' @include cloudhsm_service.R
NULL

#' This is documentation for AWS CLOUDHSM CLASSIC
#'
#' This is documentation for **AWS CloudHSM Classic**. For more
#' information, see [AWS CloudHSM Classic
#' FAQs](http://aws.amazon.com/cloudhsm/faqs-classic/), the [AWS CloudHSM
#' Classic User
#' Guide](http://docs.aws.amazon.com/cloudhsm/classic/userguide/), and the
#' [AWS CloudHSM Classic API
#' Reference](http://docs.aws.amazon.com/cloudhsm/classic/APIReference/).
#' 
#' **For information about the current version of AWS CloudHSM**, see [AWS
#' CloudHSM](http://aws.amazon.com/cloudhsm/), the [AWS CloudHSM User
#' Guide](http://docs.aws.amazon.com/cloudhsm/latest/userguide/), and the
#' [AWS CloudHSM API
#' Reference](http://docs.aws.amazon.com/cloudhsm/latest/APIReference/).
#' 
#' Adds or overwrites one or more tags for the specified AWS CloudHSM
#' resource.
#' 
#' Each tag consists of a key and a value. Tag keys must be unique to each
#' resource.
#'
#' @usage
#' cloudhsm_add_tags_to_resource(ResourceArn, TagList)
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the AWS CloudHSM resource to tag.
#' @param TagList &#91;required&#93; One or more tags.
#'
#' @section Request syntax:
#' ```
#' svc$add_tags_to_resource(
#'   ResourceArn = "string",
#'   TagList = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudhsm_add_tags_to_resource
cloudhsm_add_tags_to_resource <- function(ResourceArn, TagList) {
  op <- new_operation(
    name = "AddTagsToResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudhsm$add_tags_to_resource_input(ResourceArn = ResourceArn, TagList = TagList)
  output <- .cloudhsm$add_tags_to_resource_output()
  svc <- .cloudhsm$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudhsm$operations$add_tags_to_resource <- cloudhsm_add_tags_to_resource

#' This is documentation for AWS CLOUDHSM CLASSIC
#'
#' This is documentation for **AWS CloudHSM Classic**. For more
#' information, see [AWS CloudHSM Classic
#' FAQs](http://aws.amazon.com/cloudhsm/faqs-classic/), the [AWS CloudHSM
#' Classic User
#' Guide](http://docs.aws.amazon.com/cloudhsm/classic/userguide/), and the
#' [AWS CloudHSM Classic API
#' Reference](http://docs.aws.amazon.com/cloudhsm/classic/APIReference/).
#' 
#' **For information about the current version of AWS CloudHSM**, see [AWS
#' CloudHSM](http://aws.amazon.com/cloudhsm/), the [AWS CloudHSM User
#' Guide](http://docs.aws.amazon.com/cloudhsm/latest/userguide/), and the
#' [AWS CloudHSM API
#' Reference](http://docs.aws.amazon.com/cloudhsm/latest/APIReference/).
#' 
#' Creates a high-availability partition group. A high-availability
#' partition group is a group of partitions that spans multiple physical
#' HSMs.
#'
#' @usage
#' cloudhsm_create_hapg(Label)
#'
#' @param Label &#91;required&#93; The label of the new high-availability partition group.
#'
#' @section Request syntax:
#' ```
#' svc$create_hapg(
#'   Label = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudhsm_create_hapg
cloudhsm_create_hapg <- function(Label) {
  op <- new_operation(
    name = "CreateHapg",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudhsm$create_hapg_input(Label = Label)
  output <- .cloudhsm$create_hapg_output()
  svc <- .cloudhsm$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudhsm$operations$create_hapg <- cloudhsm_create_hapg

#' This is documentation for AWS CLOUDHSM CLASSIC
#'
#' This is documentation for **AWS CloudHSM Classic**. For more
#' information, see [AWS CloudHSM Classic
#' FAQs](http://aws.amazon.com/cloudhsm/faqs-classic/), the [AWS CloudHSM
#' Classic User
#' Guide](http://docs.aws.amazon.com/cloudhsm/classic/userguide/), and the
#' [AWS CloudHSM Classic API
#' Reference](http://docs.aws.amazon.com/cloudhsm/classic/APIReference/).
#' 
#' **For information about the current version of AWS CloudHSM**, see [AWS
#' CloudHSM](http://aws.amazon.com/cloudhsm/), the [AWS CloudHSM User
#' Guide](http://docs.aws.amazon.com/cloudhsm/latest/userguide/), and the
#' [AWS CloudHSM API
#' Reference](http://docs.aws.amazon.com/cloudhsm/latest/APIReference/).
#' 
#' Creates an uninitialized HSM instance.
#' 
#' There is an upfront fee charged for each HSM instance that you create
#' with the `CreateHsm` operation. If you accidentally provision an HSM and
#' want to request a refund, delete the instance using the DeleteHsm
#' operation, go to the [AWS Support
#' Center](https://console.aws.amazon.com/support/home), create a new case,
#' and select **Account and Billing Support**.
#' 
#' It can take up to 20 minutes to create and provision an HSM. You can
#' monitor the status of the HSM with the DescribeHsm operation. The HSM is
#' ready to be initialized when the status changes to `RUNNING`.
#'
#' @usage
#' cloudhsm_create_hsm(SubnetId, SshKey, EniIp, IamRoleArn, ExternalId,
#'   SubscriptionType, ClientToken, SyslogIp)
#'
#' @param SubnetId &#91;required&#93; The identifier of the subnet in your VPC in which to place the HSM.
#' @param SshKey &#91;required&#93; The SSH public key to install on the HSM.
#' @param EniIp The IP address to assign to the HSM\'s ENI.
#' 
#' If an IP address is not specified, an IP address will be randomly chosen
#' from the CIDR range of the subnet.
#' @param IamRoleArn &#91;required&#93; The ARN of an IAM role to enable the AWS CloudHSM service to allocate an
#' ENI on your behalf.
#' @param ExternalId The external ID from `IamRoleArn`, if present.
#' @param SubscriptionType &#91;required&#93; 
#' @param ClientToken A user-defined token to ensure idempotence. Subsequent calls to this
#' operation with the same token will be ignored.
#' @param SyslogIp The IP address for the syslog monitoring server. The AWS CloudHSM
#' service only supports one syslog monitoring server.
#'
#' @section Request syntax:
#' ```
#' svc$create_hsm(
#'   SubnetId = "string",
#'   SshKey = "string",
#'   EniIp = "string",
#'   IamRoleArn = "string",
#'   ExternalId = "string",
#'   SubscriptionType = "PRODUCTION",
#'   ClientToken = "string",
#'   SyslogIp = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudhsm_create_hsm
cloudhsm_create_hsm <- function(SubnetId, SshKey, EniIp = NULL, IamRoleArn, ExternalId = NULL, SubscriptionType, ClientToken = NULL, SyslogIp = NULL) {
  op <- new_operation(
    name = "CreateHsm",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudhsm$create_hsm_input(SubnetId = SubnetId, SshKey = SshKey, EniIp = EniIp, IamRoleArn = IamRoleArn, ExternalId = ExternalId, SubscriptionType = SubscriptionType, ClientToken = ClientToken, SyslogIp = SyslogIp)
  output <- .cloudhsm$create_hsm_output()
  svc <- .cloudhsm$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudhsm$operations$create_hsm <- cloudhsm_create_hsm

#' This is documentation for AWS CLOUDHSM CLASSIC
#'
#' This is documentation for **AWS CloudHSM Classic**. For more
#' information, see [AWS CloudHSM Classic
#' FAQs](http://aws.amazon.com/cloudhsm/faqs-classic/), the [AWS CloudHSM
#' Classic User
#' Guide](http://docs.aws.amazon.com/cloudhsm/classic/userguide/), and the
#' [AWS CloudHSM Classic API
#' Reference](http://docs.aws.amazon.com/cloudhsm/classic/APIReference/).
#' 
#' **For information about the current version of AWS CloudHSM**, see [AWS
#' CloudHSM](http://aws.amazon.com/cloudhsm/), the [AWS CloudHSM User
#' Guide](http://docs.aws.amazon.com/cloudhsm/latest/userguide/), and the
#' [AWS CloudHSM API
#' Reference](http://docs.aws.amazon.com/cloudhsm/latest/APIReference/).
#' 
#' Creates an HSM client.
#'
#' @usage
#' cloudhsm_create_luna_client(Label, Certificate)
#'
#' @param Label The label for the client.
#' @param Certificate &#91;required&#93; The contents of a Base64-Encoded X.509 v3 certificate to be installed on
#' the HSMs used by this client.
#'
#' @section Request syntax:
#' ```
#' svc$create_luna_client(
#'   Label = "string",
#'   Certificate = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudhsm_create_luna_client
cloudhsm_create_luna_client <- function(Label = NULL, Certificate) {
  op <- new_operation(
    name = "CreateLunaClient",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudhsm$create_luna_client_input(Label = Label, Certificate = Certificate)
  output <- .cloudhsm$create_luna_client_output()
  svc <- .cloudhsm$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudhsm$operations$create_luna_client <- cloudhsm_create_luna_client

#' This is documentation for AWS CLOUDHSM CLASSIC
#'
#' This is documentation for **AWS CloudHSM Classic**. For more
#' information, see [AWS CloudHSM Classic
#' FAQs](http://aws.amazon.com/cloudhsm/faqs-classic/), the [AWS CloudHSM
#' Classic User
#' Guide](http://docs.aws.amazon.com/cloudhsm/classic/userguide/), and the
#' [AWS CloudHSM Classic API
#' Reference](http://docs.aws.amazon.com/cloudhsm/classic/APIReference/).
#' 
#' **For information about the current version of AWS CloudHSM**, see [AWS
#' CloudHSM](http://aws.amazon.com/cloudhsm/), the [AWS CloudHSM User
#' Guide](http://docs.aws.amazon.com/cloudhsm/latest/userguide/), and the
#' [AWS CloudHSM API
#' Reference](http://docs.aws.amazon.com/cloudhsm/latest/APIReference/).
#' 
#' Deletes a high-availability partition group.
#'
#' @usage
#' cloudhsm_delete_hapg(HapgArn)
#'
#' @param HapgArn &#91;required&#93; The ARN of the high-availability partition group to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_hapg(
#'   HapgArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudhsm_delete_hapg
cloudhsm_delete_hapg <- function(HapgArn) {
  op <- new_operation(
    name = "DeleteHapg",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudhsm$delete_hapg_input(HapgArn = HapgArn)
  output <- .cloudhsm$delete_hapg_output()
  svc <- .cloudhsm$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudhsm$operations$delete_hapg <- cloudhsm_delete_hapg

#' This is documentation for AWS CLOUDHSM CLASSIC
#'
#' This is documentation for **AWS CloudHSM Classic**. For more
#' information, see [AWS CloudHSM Classic
#' FAQs](http://aws.amazon.com/cloudhsm/faqs-classic/), the [AWS CloudHSM
#' Classic User
#' Guide](http://docs.aws.amazon.com/cloudhsm/classic/userguide/), and the
#' [AWS CloudHSM Classic API
#' Reference](http://docs.aws.amazon.com/cloudhsm/classic/APIReference/).
#' 
#' **For information about the current version of AWS CloudHSM**, see [AWS
#' CloudHSM](http://aws.amazon.com/cloudhsm/), the [AWS CloudHSM User
#' Guide](http://docs.aws.amazon.com/cloudhsm/latest/userguide/), and the
#' [AWS CloudHSM API
#' Reference](http://docs.aws.amazon.com/cloudhsm/latest/APIReference/).
#' 
#' Deletes an HSM. After completion, this operation cannot be undone and
#' your key material cannot be recovered.
#'
#' @usage
#' cloudhsm_delete_hsm(HsmArn)
#'
#' @param HsmArn &#91;required&#93; The ARN of the HSM to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_hsm(
#'   HsmArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudhsm_delete_hsm
cloudhsm_delete_hsm <- function(HsmArn) {
  op <- new_operation(
    name = "DeleteHsm",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudhsm$delete_hsm_input(HsmArn = HsmArn)
  output <- .cloudhsm$delete_hsm_output()
  svc <- .cloudhsm$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudhsm$operations$delete_hsm <- cloudhsm_delete_hsm

#' This is documentation for AWS CLOUDHSM CLASSIC
#'
#' This is documentation for **AWS CloudHSM Classic**. For more
#' information, see [AWS CloudHSM Classic
#' FAQs](http://aws.amazon.com/cloudhsm/faqs-classic/), the [AWS CloudHSM
#' Classic User
#' Guide](http://docs.aws.amazon.com/cloudhsm/classic/userguide/), and the
#' [AWS CloudHSM Classic API
#' Reference](http://docs.aws.amazon.com/cloudhsm/classic/APIReference/).
#' 
#' **For information about the current version of AWS CloudHSM**, see [AWS
#' CloudHSM](http://aws.amazon.com/cloudhsm/), the [AWS CloudHSM User
#' Guide](http://docs.aws.amazon.com/cloudhsm/latest/userguide/), and the
#' [AWS CloudHSM API
#' Reference](http://docs.aws.amazon.com/cloudhsm/latest/APIReference/).
#' 
#' Deletes a client.
#'
#' @usage
#' cloudhsm_delete_luna_client(ClientArn)
#'
#' @param ClientArn &#91;required&#93; The ARN of the client to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_luna_client(
#'   ClientArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudhsm_delete_luna_client
cloudhsm_delete_luna_client <- function(ClientArn) {
  op <- new_operation(
    name = "DeleteLunaClient",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudhsm$delete_luna_client_input(ClientArn = ClientArn)
  output <- .cloudhsm$delete_luna_client_output()
  svc <- .cloudhsm$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudhsm$operations$delete_luna_client <- cloudhsm_delete_luna_client

#' This is documentation for AWS CLOUDHSM CLASSIC
#'
#' This is documentation for **AWS CloudHSM Classic**. For more
#' information, see [AWS CloudHSM Classic
#' FAQs](http://aws.amazon.com/cloudhsm/faqs-classic/), the [AWS CloudHSM
#' Classic User
#' Guide](http://docs.aws.amazon.com/cloudhsm/classic/userguide/), and the
#' [AWS CloudHSM Classic API
#' Reference](http://docs.aws.amazon.com/cloudhsm/classic/APIReference/).
#' 
#' **For information about the current version of AWS CloudHSM**, see [AWS
#' CloudHSM](http://aws.amazon.com/cloudhsm/), the [AWS CloudHSM User
#' Guide](http://docs.aws.amazon.com/cloudhsm/latest/userguide/), and the
#' [AWS CloudHSM API
#' Reference](http://docs.aws.amazon.com/cloudhsm/latest/APIReference/).
#' 
#' Retrieves information about a high-availability partition group.
#'
#' @usage
#' cloudhsm_describe_hapg(HapgArn)
#'
#' @param HapgArn &#91;required&#93; The ARN of the high-availability partition group to describe.
#'
#' @section Request syntax:
#' ```
#' svc$describe_hapg(
#'   HapgArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudhsm_describe_hapg
cloudhsm_describe_hapg <- function(HapgArn) {
  op <- new_operation(
    name = "DescribeHapg",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudhsm$describe_hapg_input(HapgArn = HapgArn)
  output <- .cloudhsm$describe_hapg_output()
  svc <- .cloudhsm$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudhsm$operations$describe_hapg <- cloudhsm_describe_hapg

#' This is documentation for AWS CLOUDHSM CLASSIC
#'
#' This is documentation for **AWS CloudHSM Classic**. For more
#' information, see [AWS CloudHSM Classic
#' FAQs](http://aws.amazon.com/cloudhsm/faqs-classic/), the [AWS CloudHSM
#' Classic User
#' Guide](http://docs.aws.amazon.com/cloudhsm/classic/userguide/), and the
#' [AWS CloudHSM Classic API
#' Reference](http://docs.aws.amazon.com/cloudhsm/classic/APIReference/).
#' 
#' **For information about the current version of AWS CloudHSM**, see [AWS
#' CloudHSM](http://aws.amazon.com/cloudhsm/), the [AWS CloudHSM User
#' Guide](http://docs.aws.amazon.com/cloudhsm/latest/userguide/), and the
#' [AWS CloudHSM API
#' Reference](http://docs.aws.amazon.com/cloudhsm/latest/APIReference/).
#' 
#' Retrieves information about an HSM. You can identify the HSM by its ARN
#' or its serial number.
#'
#' @usage
#' cloudhsm_describe_hsm(HsmArn, HsmSerialNumber)
#'
#' @param HsmArn The ARN of the HSM. Either the `HsmArn` or the `SerialNumber` parameter
#' must be specified.
#' @param HsmSerialNumber The serial number of the HSM. Either the `HsmArn` or the
#' `HsmSerialNumber` parameter must be specified.
#'
#' @section Request syntax:
#' ```
#' svc$describe_hsm(
#'   HsmArn = "string",
#'   HsmSerialNumber = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudhsm_describe_hsm
cloudhsm_describe_hsm <- function(HsmArn = NULL, HsmSerialNumber = NULL) {
  op <- new_operation(
    name = "DescribeHsm",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudhsm$describe_hsm_input(HsmArn = HsmArn, HsmSerialNumber = HsmSerialNumber)
  output <- .cloudhsm$describe_hsm_output()
  svc <- .cloudhsm$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudhsm$operations$describe_hsm <- cloudhsm_describe_hsm

#' This is documentation for AWS CLOUDHSM CLASSIC
#'
#' This is documentation for **AWS CloudHSM Classic**. For more
#' information, see [AWS CloudHSM Classic
#' FAQs](http://aws.amazon.com/cloudhsm/faqs-classic/), the [AWS CloudHSM
#' Classic User
#' Guide](http://docs.aws.amazon.com/cloudhsm/classic/userguide/), and the
#' [AWS CloudHSM Classic API
#' Reference](http://docs.aws.amazon.com/cloudhsm/classic/APIReference/).
#' 
#' **For information about the current version of AWS CloudHSM**, see [AWS
#' CloudHSM](http://aws.amazon.com/cloudhsm/), the [AWS CloudHSM User
#' Guide](http://docs.aws.amazon.com/cloudhsm/latest/userguide/), and the
#' [AWS CloudHSM API
#' Reference](http://docs.aws.amazon.com/cloudhsm/latest/APIReference/).
#' 
#' Retrieves information about an HSM client.
#'
#' @usage
#' cloudhsm_describe_luna_client(ClientArn, CertificateFingerprint)
#'
#' @param ClientArn The ARN of the client.
#' @param CertificateFingerprint The certificate fingerprint.
#'
#' @section Request syntax:
#' ```
#' svc$describe_luna_client(
#'   ClientArn = "string",
#'   CertificateFingerprint = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudhsm_describe_luna_client
cloudhsm_describe_luna_client <- function(ClientArn = NULL, CertificateFingerprint = NULL) {
  op <- new_operation(
    name = "DescribeLunaClient",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudhsm$describe_luna_client_input(ClientArn = ClientArn, CertificateFingerprint = CertificateFingerprint)
  output <- .cloudhsm$describe_luna_client_output()
  svc <- .cloudhsm$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudhsm$operations$describe_luna_client <- cloudhsm_describe_luna_client

#' This is documentation for AWS CLOUDHSM CLASSIC
#'
#' This is documentation for **AWS CloudHSM Classic**. For more
#' information, see [AWS CloudHSM Classic
#' FAQs](http://aws.amazon.com/cloudhsm/faqs-classic/), the [AWS CloudHSM
#' Classic User
#' Guide](http://docs.aws.amazon.com/cloudhsm/classic/userguide/), and the
#' [AWS CloudHSM Classic API
#' Reference](http://docs.aws.amazon.com/cloudhsm/classic/APIReference/).
#' 
#' **For information about the current version of AWS CloudHSM**, see [AWS
#' CloudHSM](http://aws.amazon.com/cloudhsm/), the [AWS CloudHSM User
#' Guide](http://docs.aws.amazon.com/cloudhsm/latest/userguide/), and the
#' [AWS CloudHSM API
#' Reference](http://docs.aws.amazon.com/cloudhsm/latest/APIReference/).
#' 
#' Gets the configuration files necessary to connect to all high
#' availability partition groups the client is associated with.
#'
#' @usage
#' cloudhsm_get_config(ClientArn, ClientVersion, HapgList)
#'
#' @param ClientArn &#91;required&#93; The ARN of the client.
#' @param ClientVersion &#91;required&#93; The client version.
#' @param HapgList &#91;required&#93; A list of ARNs that identify the high-availability partition groups that
#' are associated with the client.
#'
#' @section Request syntax:
#' ```
#' svc$get_config(
#'   ClientArn = "string",
#'   ClientVersion = "5.1"|"5.3",
#'   HapgList = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudhsm_get_config
cloudhsm_get_config <- function(ClientArn, ClientVersion, HapgList) {
  op <- new_operation(
    name = "GetConfig",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudhsm$get_config_input(ClientArn = ClientArn, ClientVersion = ClientVersion, HapgList = HapgList)
  output <- .cloudhsm$get_config_output()
  svc <- .cloudhsm$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudhsm$operations$get_config <- cloudhsm_get_config

#' This is documentation for AWS CLOUDHSM CLASSIC
#'
#' This is documentation for **AWS CloudHSM Classic**. For more
#' information, see [AWS CloudHSM Classic
#' FAQs](http://aws.amazon.com/cloudhsm/faqs-classic/), the [AWS CloudHSM
#' Classic User
#' Guide](http://docs.aws.amazon.com/cloudhsm/classic/userguide/), and the
#' [AWS CloudHSM Classic API
#' Reference](http://docs.aws.amazon.com/cloudhsm/classic/APIReference/).
#' 
#' **For information about the current version of AWS CloudHSM**, see [AWS
#' CloudHSM](http://aws.amazon.com/cloudhsm/), the [AWS CloudHSM User
#' Guide](http://docs.aws.amazon.com/cloudhsm/latest/userguide/), and the
#' [AWS CloudHSM API
#' Reference](http://docs.aws.amazon.com/cloudhsm/latest/APIReference/).
#' 
#' Lists the Availability Zones that have available AWS CloudHSM capacity.
#'
#' @usage
#' cloudhsm_list_available_zones()
#'
#' @section Request syntax:
#' ```
#' svc$list_available_zones()
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudhsm_list_available_zones
cloudhsm_list_available_zones <- function() {
  op <- new_operation(
    name = "ListAvailableZones",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudhsm$list_available_zones_input()
  output <- .cloudhsm$list_available_zones_output()
  svc <- .cloudhsm$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudhsm$operations$list_available_zones <- cloudhsm_list_available_zones

#' This is documentation for AWS CLOUDHSM CLASSIC
#'
#' This is documentation for **AWS CloudHSM Classic**. For more
#' information, see [AWS CloudHSM Classic
#' FAQs](http://aws.amazon.com/cloudhsm/faqs-classic/), the [AWS CloudHSM
#' Classic User
#' Guide](http://docs.aws.amazon.com/cloudhsm/classic/userguide/), and the
#' [AWS CloudHSM Classic API
#' Reference](http://docs.aws.amazon.com/cloudhsm/classic/APIReference/).
#' 
#' **For information about the current version of AWS CloudHSM**, see [AWS
#' CloudHSM](http://aws.amazon.com/cloudhsm/), the [AWS CloudHSM User
#' Guide](http://docs.aws.amazon.com/cloudhsm/latest/userguide/), and the
#' [AWS CloudHSM API
#' Reference](http://docs.aws.amazon.com/cloudhsm/latest/APIReference/).
#' 
#' Lists the high-availability partition groups for the account.
#' 
#' This operation supports pagination with the use of the `NextToken`
#' member. If more results are available, the `NextToken` member of the
#' response contains a token that you pass in the next call to `ListHapgs`
#' to retrieve the next set of items.
#'
#' @usage
#' cloudhsm_list_hapgs(NextToken)
#'
#' @param NextToken The `NextToken` value from a previous call to `ListHapgs`. Pass null if
#' this is the first call.
#'
#' @section Request syntax:
#' ```
#' svc$list_hapgs(
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudhsm_list_hapgs
cloudhsm_list_hapgs <- function(NextToken = NULL) {
  op <- new_operation(
    name = "ListHapgs",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudhsm$list_hapgs_input(NextToken = NextToken)
  output <- .cloudhsm$list_hapgs_output()
  svc <- .cloudhsm$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudhsm$operations$list_hapgs <- cloudhsm_list_hapgs

#' This is documentation for AWS CLOUDHSM CLASSIC
#'
#' This is documentation for **AWS CloudHSM Classic**. For more
#' information, see [AWS CloudHSM Classic
#' FAQs](http://aws.amazon.com/cloudhsm/faqs-classic/), the [AWS CloudHSM
#' Classic User
#' Guide](http://docs.aws.amazon.com/cloudhsm/classic/userguide/), and the
#' [AWS CloudHSM Classic API
#' Reference](http://docs.aws.amazon.com/cloudhsm/classic/APIReference/).
#' 
#' **For information about the current version of AWS CloudHSM**, see [AWS
#' CloudHSM](http://aws.amazon.com/cloudhsm/), the [AWS CloudHSM User
#' Guide](http://docs.aws.amazon.com/cloudhsm/latest/userguide/), and the
#' [AWS CloudHSM API
#' Reference](http://docs.aws.amazon.com/cloudhsm/latest/APIReference/).
#' 
#' Retrieves the identifiers of all of the HSMs provisioned for the current
#' customer.
#' 
#' This operation supports pagination with the use of the `NextToken`
#' member. If more results are available, the `NextToken` member of the
#' response contains a token that you pass in the next call to `ListHsms`
#' to retrieve the next set of items.
#'
#' @usage
#' cloudhsm_list_hsms(NextToken)
#'
#' @param NextToken The `NextToken` value from a previous call to `ListHsms`. Pass null if
#' this is the first call.
#'
#' @section Request syntax:
#' ```
#' svc$list_hsms(
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudhsm_list_hsms
cloudhsm_list_hsms <- function(NextToken = NULL) {
  op <- new_operation(
    name = "ListHsms",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudhsm$list_hsms_input(NextToken = NextToken)
  output <- .cloudhsm$list_hsms_output()
  svc <- .cloudhsm$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudhsm$operations$list_hsms <- cloudhsm_list_hsms

#' This is documentation for AWS CLOUDHSM CLASSIC
#'
#' This is documentation for **AWS CloudHSM Classic**. For more
#' information, see [AWS CloudHSM Classic
#' FAQs](http://aws.amazon.com/cloudhsm/faqs-classic/), the [AWS CloudHSM
#' Classic User
#' Guide](http://docs.aws.amazon.com/cloudhsm/classic/userguide/), and the
#' [AWS CloudHSM Classic API
#' Reference](http://docs.aws.amazon.com/cloudhsm/classic/APIReference/).
#' 
#' **For information about the current version of AWS CloudHSM**, see [AWS
#' CloudHSM](http://aws.amazon.com/cloudhsm/), the [AWS CloudHSM User
#' Guide](http://docs.aws.amazon.com/cloudhsm/latest/userguide/), and the
#' [AWS CloudHSM API
#' Reference](http://docs.aws.amazon.com/cloudhsm/latest/APIReference/).
#' 
#' Lists all of the clients.
#' 
#' This operation supports pagination with the use of the `NextToken`
#' member. If more results are available, the `NextToken` member of the
#' response contains a token that you pass in the next call to
#' `ListLunaClients` to retrieve the next set of items.
#'
#' @usage
#' cloudhsm_list_luna_clients(NextToken)
#'
#' @param NextToken The `NextToken` value from a previous call to `ListLunaClients`. Pass
#' null if this is the first call.
#'
#' @section Request syntax:
#' ```
#' svc$list_luna_clients(
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudhsm_list_luna_clients
cloudhsm_list_luna_clients <- function(NextToken = NULL) {
  op <- new_operation(
    name = "ListLunaClients",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudhsm$list_luna_clients_input(NextToken = NextToken)
  output <- .cloudhsm$list_luna_clients_output()
  svc <- .cloudhsm$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudhsm$operations$list_luna_clients <- cloudhsm_list_luna_clients

#' This is documentation for AWS CLOUDHSM CLASSIC
#'
#' This is documentation for **AWS CloudHSM Classic**. For more
#' information, see [AWS CloudHSM Classic
#' FAQs](http://aws.amazon.com/cloudhsm/faqs-classic/), the [AWS CloudHSM
#' Classic User
#' Guide](http://docs.aws.amazon.com/cloudhsm/classic/userguide/), and the
#' [AWS CloudHSM Classic API
#' Reference](http://docs.aws.amazon.com/cloudhsm/classic/APIReference/).
#' 
#' **For information about the current version of AWS CloudHSM**, see [AWS
#' CloudHSM](http://aws.amazon.com/cloudhsm/), the [AWS CloudHSM User
#' Guide](http://docs.aws.amazon.com/cloudhsm/latest/userguide/), and the
#' [AWS CloudHSM API
#' Reference](http://docs.aws.amazon.com/cloudhsm/latest/APIReference/).
#' 
#' Returns a list of all tags for the specified AWS CloudHSM resource.
#'
#' @usage
#' cloudhsm_list_tags_for_resource(ResourceArn)
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the AWS CloudHSM resource.
#'
#' @section Request syntax:
#' ```
#' svc$list_tags_for_resource(
#'   ResourceArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudhsm_list_tags_for_resource
cloudhsm_list_tags_for_resource <- function(ResourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudhsm$list_tags_for_resource_input(ResourceArn = ResourceArn)
  output <- .cloudhsm$list_tags_for_resource_output()
  svc <- .cloudhsm$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudhsm$operations$list_tags_for_resource <- cloudhsm_list_tags_for_resource

#' This is documentation for AWS CLOUDHSM CLASSIC
#'
#' This is documentation for **AWS CloudHSM Classic**. For more
#' information, see [AWS CloudHSM Classic
#' FAQs](http://aws.amazon.com/cloudhsm/faqs-classic/), the [AWS CloudHSM
#' Classic User
#' Guide](http://docs.aws.amazon.com/cloudhsm/classic/userguide/), and the
#' [AWS CloudHSM Classic API
#' Reference](http://docs.aws.amazon.com/cloudhsm/classic/APIReference/).
#' 
#' **For information about the current version of AWS CloudHSM**, see [AWS
#' CloudHSM](http://aws.amazon.com/cloudhsm/), the [AWS CloudHSM User
#' Guide](http://docs.aws.amazon.com/cloudhsm/latest/userguide/), and the
#' [AWS CloudHSM API
#' Reference](http://docs.aws.amazon.com/cloudhsm/latest/APIReference/).
#' 
#' Modifies an existing high-availability partition group.
#'
#' @usage
#' cloudhsm_modify_hapg(HapgArn, Label, PartitionSerialList)
#'
#' @param HapgArn &#91;required&#93; The ARN of the high-availability partition group to modify.
#' @param Label The new label for the high-availability partition group.
#' @param PartitionSerialList The list of partition serial numbers to make members of the
#' high-availability partition group.
#'
#' @section Request syntax:
#' ```
#' svc$modify_hapg(
#'   HapgArn = "string",
#'   Label = "string",
#'   PartitionSerialList = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudhsm_modify_hapg
cloudhsm_modify_hapg <- function(HapgArn, Label = NULL, PartitionSerialList = NULL) {
  op <- new_operation(
    name = "ModifyHapg",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudhsm$modify_hapg_input(HapgArn = HapgArn, Label = Label, PartitionSerialList = PartitionSerialList)
  output <- .cloudhsm$modify_hapg_output()
  svc <- .cloudhsm$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudhsm$operations$modify_hapg <- cloudhsm_modify_hapg

#' This is documentation for AWS CLOUDHSM CLASSIC
#'
#' This is documentation for **AWS CloudHSM Classic**. For more
#' information, see [AWS CloudHSM Classic
#' FAQs](http://aws.amazon.com/cloudhsm/faqs-classic/), the [AWS CloudHSM
#' Classic User
#' Guide](http://docs.aws.amazon.com/cloudhsm/classic/userguide/), and the
#' [AWS CloudHSM Classic API
#' Reference](http://docs.aws.amazon.com/cloudhsm/classic/APIReference/).
#' 
#' **For information about the current version of AWS CloudHSM**, see [AWS
#' CloudHSM](http://aws.amazon.com/cloudhsm/), the [AWS CloudHSM User
#' Guide](http://docs.aws.amazon.com/cloudhsm/latest/userguide/), and the
#' [AWS CloudHSM API
#' Reference](http://docs.aws.amazon.com/cloudhsm/latest/APIReference/).
#' 
#' Modifies an HSM.
#' 
#' This operation can result in the HSM being offline for up to 15 minutes
#' while the AWS CloudHSM service is reconfigured. If you are modifying a
#' production HSM, you should ensure that your AWS CloudHSM service is
#' configured for high availability, and consider executing this operation
#' during a maintenance window.
#'
#' @usage
#' cloudhsm_modify_hsm(HsmArn, SubnetId, EniIp, IamRoleArn, ExternalId,
#'   SyslogIp)
#'
#' @param HsmArn &#91;required&#93; The ARN of the HSM to modify.
#' @param SubnetId The new identifier of the subnet that the HSM is in. The new subnet must
#' be in the same Availability Zone as the current subnet.
#' @param EniIp The new IP address for the elastic network interface (ENI) attached to
#' the HSM.
#' 
#' If the HSM is moved to a different subnet, and an IP address is not
#' specified, an IP address will be randomly chosen from the CIDR range of
#' the new subnet.
#' @param IamRoleArn The new IAM role ARN.
#' @param ExternalId The new external ID.
#' @param SyslogIp The new IP address for the syslog monitoring server. The AWS CloudHSM
#' service only supports one syslog monitoring server.
#'
#' @section Request syntax:
#' ```
#' svc$modify_hsm(
#'   HsmArn = "string",
#'   SubnetId = "string",
#'   EniIp = "string",
#'   IamRoleArn = "string",
#'   ExternalId = "string",
#'   SyslogIp = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudhsm_modify_hsm
cloudhsm_modify_hsm <- function(HsmArn, SubnetId = NULL, EniIp = NULL, IamRoleArn = NULL, ExternalId = NULL, SyslogIp = NULL) {
  op <- new_operation(
    name = "ModifyHsm",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudhsm$modify_hsm_input(HsmArn = HsmArn, SubnetId = SubnetId, EniIp = EniIp, IamRoleArn = IamRoleArn, ExternalId = ExternalId, SyslogIp = SyslogIp)
  output <- .cloudhsm$modify_hsm_output()
  svc <- .cloudhsm$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudhsm$operations$modify_hsm <- cloudhsm_modify_hsm

#' This is documentation for AWS CLOUDHSM CLASSIC
#'
#' This is documentation for **AWS CloudHSM Classic**. For more
#' information, see [AWS CloudHSM Classic
#' FAQs](http://aws.amazon.com/cloudhsm/faqs-classic/), the [AWS CloudHSM
#' Classic User
#' Guide](http://docs.aws.amazon.com/cloudhsm/classic/userguide/), and the
#' [AWS CloudHSM Classic API
#' Reference](http://docs.aws.amazon.com/cloudhsm/classic/APIReference/).
#' 
#' **For information about the current version of AWS CloudHSM**, see [AWS
#' CloudHSM](http://aws.amazon.com/cloudhsm/), the [AWS CloudHSM User
#' Guide](http://docs.aws.amazon.com/cloudhsm/latest/userguide/), and the
#' [AWS CloudHSM API
#' Reference](http://docs.aws.amazon.com/cloudhsm/latest/APIReference/).
#' 
#' Modifies the certificate used by the client.
#' 
#' This action can potentially start a workflow to install the new
#' certificate on the client\'s HSMs.
#'
#' @usage
#' cloudhsm_modify_luna_client(ClientArn, Certificate)
#'
#' @param ClientArn &#91;required&#93; The ARN of the client.
#' @param Certificate &#91;required&#93; The new certificate for the client.
#'
#' @section Request syntax:
#' ```
#' svc$modify_luna_client(
#'   ClientArn = "string",
#'   Certificate = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudhsm_modify_luna_client
cloudhsm_modify_luna_client <- function(ClientArn, Certificate) {
  op <- new_operation(
    name = "ModifyLunaClient",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudhsm$modify_luna_client_input(ClientArn = ClientArn, Certificate = Certificate)
  output <- .cloudhsm$modify_luna_client_output()
  svc <- .cloudhsm$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudhsm$operations$modify_luna_client <- cloudhsm_modify_luna_client

#' This is documentation for AWS CLOUDHSM CLASSIC
#'
#' This is documentation for **AWS CloudHSM Classic**. For more
#' information, see [AWS CloudHSM Classic
#' FAQs](http://aws.amazon.com/cloudhsm/faqs-classic/), the [AWS CloudHSM
#' Classic User
#' Guide](http://docs.aws.amazon.com/cloudhsm/classic/userguide/), and the
#' [AWS CloudHSM Classic API
#' Reference](http://docs.aws.amazon.com/cloudhsm/classic/APIReference/).
#' 
#' **For information about the current version of AWS CloudHSM**, see [AWS
#' CloudHSM](http://aws.amazon.com/cloudhsm/), the [AWS CloudHSM User
#' Guide](http://docs.aws.amazon.com/cloudhsm/latest/userguide/), and the
#' [AWS CloudHSM API
#' Reference](http://docs.aws.amazon.com/cloudhsm/latest/APIReference/).
#' 
#' Removes one or more tags from the specified AWS CloudHSM resource.
#' 
#' To remove a tag, specify only the tag key to remove (not the value). To
#' overwrite the value for an existing tag, use AddTagsToResource.
#'
#' @usage
#' cloudhsm_remove_tags_from_resource(ResourceArn, TagKeyList)
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the AWS CloudHSM resource.
#' @param TagKeyList &#91;required&#93; The tag key or keys to remove.
#' 
#' Specify only the tag key to remove (not the value). To overwrite the
#' value for an existing tag, use AddTagsToResource.
#'
#' @section Request syntax:
#' ```
#' svc$remove_tags_from_resource(
#'   ResourceArn = "string",
#'   TagKeyList = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudhsm_remove_tags_from_resource
cloudhsm_remove_tags_from_resource <- function(ResourceArn, TagKeyList) {
  op <- new_operation(
    name = "RemoveTagsFromResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudhsm$remove_tags_from_resource_input(ResourceArn = ResourceArn, TagKeyList = TagKeyList)
  output <- .cloudhsm$remove_tags_from_resource_output()
  svc <- .cloudhsm$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudhsm$operations$remove_tags_from_resource <- cloudhsm_remove_tags_from_resource
