% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_get_context_keys_for_principal_policy}
\alias{iam_get_context_keys_for_principal_policy}
\title{Gets a list of all of the context keys referenced in all the IAM
policies that are attached to the specified IAM entity}
\usage{
iam_get_context_keys_for_principal_policy(PolicySourceArn,
  PolicyInputList)
}
\arguments{
\item{PolicySourceArn}{[required] The ARN of a user, group, or role whose policies contain the context
keys that you want listed. If you specify a user, the list includes
context keys that are found in all policies that are attached to the
user. The list also includes all groups that the user is a member of. If
you pick a group or a role, then it includes only those context keys
that are found in policies attached to that entity. Note that all
parameters are shown in unencoded form here for clarity, but must be URL
encoded to be included as a part of a real HTML request.

For more information about ARNs, see \href{https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html}{Amazon Resource Names (ARNs) and AWS Service Namespaces}
in the \emph{AWS General Reference}.}

\item{PolicyInputList}{An optional list of additional policies for which you want the list of
context keys that are referenced.

The \href{http://wikipedia.org/wiki/regex}{regex pattern} used to validate
this parameter is a string of characters consisting of the following:
\itemize{
\item Any printable ASCII character ranging from the space character
(\code{U+0020}) through the end of the ASCII character range
\item The printable characters in the Basic Latin and Latin-1 Supplement
character set (through \code{U+00FF})
\item The special characters tab (\code{U+0009}), line feed (\code{U+000A}), and
carriage return (\code{U+000D})
}}
}
\description{
Gets a list of all of the context keys referenced in all the IAM
policies that are attached to the specified IAM entity. The entity can
be an IAM user, group, or role. If you specify a user, then the request
also includes all of the policies attached to groups that the user is a
member of.
}
\details{
You can optionally include a list of one or more additional policies,
specified as strings. If you want to include \emph{only} a list of policies
by string, use GetContextKeysForCustomPolicy instead.

\strong{Note:} This API discloses information about the permissions granted
to other users. If you do not want users to see other user's
permissions, then consider allowing them to use
GetContextKeysForCustomPolicy instead.

Context keys are variables maintained by AWS and its services that
provide details about the context of an API query request. Context keys
can be evaluated by testing against a value in an IAM policy. Use
GetContextKeysForPrincipalPolicy to understand what key names and values
you must supply when you call SimulatePrincipalPolicy.
}
\section{Request syntax}{
\preformatted{svc$get_context_keys_for_principal_policy(
  PolicySourceArn = "string",
  PolicyInputList = list(
    "string"
  )
)
}
}

\keyword{internal}
