% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wafregional_operations.R
\name{wafregional_update_rule}
\alias{wafregional_update_rule}
\title{Inserts or deletes Predicate objects in a Rule}
\usage{
wafregional_update_rule(RuleId, ChangeToken, Updates)
}
\arguments{
\item{RuleId}{[required] The \code{RuleId} of the \code{Rule} that you want to update. \code{RuleId} is returned
by \code{CreateRule} and by ListRules.}

\item{ChangeToken}{[required] The value returned by the most recent call to GetChangeToken.}

\item{Updates}{[required] An array of \code{RuleUpdate} objects that you want to insert into or delete
from a Rule. For more information, see the applicable data types:
\itemize{
\item RuleUpdate: Contains \code{Action} and \code{Predicate}
\item Predicate: Contains \code{DataId}, \code{Negated}, and \code{Type}
\item FieldToMatch: Contains \code{Data} and \code{Type}
}}
}
\description{
Inserts or deletes Predicate objects in a \code{Rule}. Each \code{Predicate}
object identifies a predicate, such as a ByteMatchSet or an IPSet, that
specifies the web requests that you want to allow, block, or count. If
you add more than one predicate to a \code{Rule}, a request must match all of
the specifications to be allowed, blocked, or counted. For example,
suppose that you add the following to a \code{Rule}:
}
\details{
\itemize{
\item A \code{ByteMatchSet} that matches the value \code{BadBot} in the \code{User-Agent}
header
\item An \code{IPSet} that matches the IP address \verb{192.0.2.44}
}

You then add the \code{Rule} to a \code{WebACL} and specify that you want to block
requests that satisfy the \code{Rule}. For a request to be blocked, the
\code{User-Agent} header in the request must contain the value \code{BadBot} \emph{and}
the request must originate from the IP address 192.0.2.44.

To create and configure a \code{Rule}, perform the following steps:
\enumerate{
\item Create and update the predicates that you want to include in the
\code{Rule}.
\item Create the \code{Rule}. See CreateRule.
\item Use \code{GetChangeToken} to get the change token that you provide in the
\code{ChangeToken} parameter of an UpdateRule request.
\item Submit an \code{UpdateRule} request to add predicates to the \code{Rule}.
\item Create and update a \code{WebACL} that contains the \code{Rule}. See
CreateWebACL.
}

If you want to replace one \code{ByteMatchSet} or \code{IPSet} with another, you
delete the existing one and add the new one.

For more information about how to use the AWS WAF API to allow or block
HTTP requests, see the \href{https://docs.aws.amazon.com/waf/latest/developerguide/}{AWS WAF Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$update_rule(
  RuleId = "string",
  ChangeToken = "string",
  Updates = list(
    list(
      Action = "INSERT"|"DELETE",
      Predicate = list(
        Negated = TRUE|FALSE,
        Type = "IPMatch"|"ByteMatch"|"SqlInjectionMatch"|"GeoMatch"|"SizeConstraint"|"XssMatch"|"RegexMatch",
        DataId = "string"
      )
    )
  )
)
}
}

\examples{
# The following example deletes a Predicate object in a rule with the ID
# example1ds3t-46da-4fdb-b8d5-abc321j569j5.
\donttest{svc$update_rule(
  ChangeToken = "abcd12f2-46da-4fdb-b8d5-fbd4c466928f",
  RuleId = "example1ds3t-46da-4fdb-b8d5-abc321j569j5",
  Updates = list(
    list(
      Action = "DELETE",
      Predicate = list(
        DataId = "MyByteMatchSetID",
        Negated = FALSE,
        Type = "ByteMatch"
      )
    )
  )
)}

}
\keyword{internal}
