% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_get_ssh_public_key}
\alias{iam_get_ssh_public_key}
\title{Retrieves the specified SSH public key, including metadata about the key}
\usage{
iam_get_ssh_public_key(UserName, SSHPublicKeyId, Encoding)
}
\arguments{
\item{UserName}{[required] The name of the IAM user associated with the SSH public key.

This parameter allows (through its \href{http://wikipedia.org/wiki/regex}{regex pattern}) a string of characters
consisting of upper and lowercase alphanumeric characters with no
spaces. You can also include any of the following characters: \\_+=,.@-}

\item{SSHPublicKeyId}{[required] The unique identifier for the SSH public key.

This parameter allows (through its \href{http://wikipedia.org/wiki/regex}{regex pattern}) a string of characters that
can consist of any upper or lowercased letter or digit.}

\item{Encoding}{[required] Specifies the public key encoding format to use in the response. To
retrieve the public key in ssh-rsa format, use \code{SSH}. To retrieve the
public key in PEM format, use \code{PEM}.}
}
\description{
Retrieves the specified SSH public key, including metadata about the
key.
}
\details{
The SSH public key retrieved by this operation is used only for
authenticating the associated IAM user to an AWS CodeCommit repository.
For more information about using SSH keys to authenticate to an AWS
CodeCommit repository, see \href{https://docs.aws.amazon.com/codecommit/latest/userguide/setting-up-credentials-ssh.html}{Set up AWS CodeCommit for SSH Connections}
in the \emph{AWS CodeCommit User Guide}.
}
\section{Request syntax}{
\preformatted{svc$get_ssh_public_key(
  UserName = "string",
  SSHPublicKeyId = "string",
  Encoding = "SSH"|"PEM"
)
}
}

\keyword{internal}
