% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/waf_operations.R
\name{waf_list_rules}
\alias{waf_list_rules}
\title{Returns an array of RuleSummary objects}
\usage{
waf_list_rules(NextMarker, Limit)
}
\arguments{
\item{NextMarker}{If you specify a value for \code{Limit} and you have more \code{Rules} than the
value of \code{Limit}, AWS WAF returns a \code{NextMarker} value in the response
that allows you to list another group of \code{Rules}. For the second and
subsequent \code{ListRules} requests, specify the value of \code{NextMarker} from
the previous response to get information about another batch of \code{Rules}.}

\item{Limit}{Specifies the number of \code{Rules} that you want AWS WAF to return for this
request. If you have more \code{Rules} than the number that you specify for
\code{Limit}, the response includes a \code{NextMarker} value that you can use to
get another batch of \code{Rules}.}
}
\description{
Returns an array of RuleSummary objects.
}
\section{Request syntax}{
\preformatted{svc$list_rules(
  NextMarker = "string",
  Limit = 123
)
}
}

\examples{
# The following example returns an array of up to 100 rules.
\dontrun{svc$list_rules(
  Limit = 100L
)}

}
\keyword{internal}
