% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_update_saml_provider}
\alias{iam_update_saml_provider}
\title{Updates the metadata document for an existing SAML provider resource
object}
\usage{
iam_update_saml_provider(SAMLMetadataDocument, SAMLProviderArn)
}
\arguments{
\item{SAMLMetadataDocument}{[required] An XML document generated by an identity provider (IdP) that supports
SAML 2.0. The document includes the issuer's name, expiration
information, and keys that can be used to validate the SAML
authentication response (assertions) that are received from the IdP. You
must generate the metadata document using the identity management
software that is used as your organization's IdP.}

\item{SAMLProviderArn}{[required] The Amazon Resource Name (ARN) of the SAML provider to update.

For more information about ARNs, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html}{Amazon Resource Names (ARNs)}
in the \emph{Amazon Web Services General Reference}.}
}
\description{
Updates the metadata document for an existing SAML provider resource object.

See \url{https://www.paws-r-sdk.com/docs/iam_update_saml_provider/} for full documentation.
}
\keyword{internal}
