% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssoadmin_operations.R
\name{ssoadmin_describe_application_assignment}
\alias{ssoadmin_describe_application_assignment}
\title{Retrieves a direct assignment of a user or group to an application}
\usage{
ssoadmin_describe_application_assignment(
  ApplicationArn,
  PrincipalId,
  PrincipalType
)
}
\arguments{
\item{ApplicationArn}{[required] Specifies the ARN of the application. For more information about ARNs,
see Amazon Resource Names (ARNs) and Amazon Web Services Service
Namespaces in the \emph{Amazon Web Services General Reference}.}

\item{PrincipalId}{[required] An identifier for an object in IAM Identity Center, such as a user or
group. PrincipalIds are GUIDs (For example,
f81d4fae-7dec-11d0-a765-00a0c91e6bf6). For more information about
PrincipalIds in IAM Identity Center, see the IAM Identity Center
Identity Store API Reference.}

\item{PrincipalType}{[required] The entity type for which the assignment will be created.}
}
\description{
Retrieves a direct assignment of a user or group to an application. If the user doesn’t have a direct assignment to the application, the user may still have access to the application through a group. Therefore, don’t use this API to test access to an application for a user. Instead use \code{\link[=ssoadmin_list_application_assignments_for_principal]{list_application_assignments_for_principal}}.

See \url{https://www.paws-r-sdk.com/docs/ssoadmin_describe_application_assignment/} for full documentation.
}
\keyword{internal}
