% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/identitystore_operations.R
\name{identitystore_list_groups}
\alias{identitystore_list_groups}
\title{Lists all groups in the identity store}
\usage{
identitystore_list_groups(
  IdentityStoreId,
  MaxResults = NULL,
  NextToken = NULL,
  Filters = NULL
)
}
\arguments{
\item{IdentityStoreId}{[required] The globally unique identifier for the identity store, such as
\code{d-1234567890}. In this example, \verb{d-} is a fixed prefix, and
\code{1234567890} is a randomly generated string that contains numbers and
lower case letters. This value is generated at the time that a new
identity store is created.}

\item{MaxResults}{The maximum number of results to be returned per request. This parameter
is used in the \code{\link[=identitystore_list_users]{list_users}} and
\code{\link[=identitystore_list_groups]{list_groups}} requests to specify how many
results to return in one page. The length limit is 50 characters.}

\item{NextToken}{The pagination token used for the
\code{\link[=identitystore_list_users]{list_users}} and
\code{\link[=identitystore_list_groups]{list_groups}} API operations. This value is
generated by the identity store service. It is returned in the API
response if the total results are more than the size of one page. This
token is also returned when it is used in the API request to search for
the next page.}

\item{Filters}{A list of \code{Filter} objects, which is used in the
\code{\link[=identitystore_list_users]{list_users}} and
\code{\link[=identitystore_list_groups]{list_groups}} requests.}
}
\description{
Lists all groups in the identity store. Returns a paginated list of complete \code{Group} objects. Filtering for a \code{Group} by the \code{DisplayName} attribute is deprecated. Instead, use the \code{\link[=identitystore_get_group_id]{get_group_id}} API action.

See \url{https://www.paws-r-sdk.com/docs/identitystore_list_groups/} for full documentation.
}
\keyword{internal}
