% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glacier_operations.R
\name{glacier_upload_archive}
\alias{glacier_upload_archive}
\title{This operation adds an archive to a vault}
\usage{
glacier_upload_archive(vaultName, accountId, archiveDescription,
  checksum, body)
}
\arguments{
\item{vaultName}{[required] The name of the vault.}

\item{accountId}{[required] The \code{AccountId} value is the AWS account ID of the account that owns the
vault. You can either specify an AWS account ID or optionally a single
'\code{-}' (hyphen), in which case Amazon S3 Glacier uses the AWS account ID
associated with the credentials used to sign the request. If you use an
account ID, do not include any hyphens ('-') in the ID.}

\item{archiveDescription}{The optional description of the archive you are uploading.}

\item{checksum}{The SHA256 tree hash of the data being uploaded.}

\item{body}{The data to upload.}
}
\description{
This operation adds an archive to a vault. This is a synchronous
operation, and for a successful upload, your data is durably persisted.
Amazon S3 Glacier returns the archive ID in the \code{x-amz-archive-id}
header of the response.

You must use the archive ID to access your data in Amazon S3 Glacier.
After you upload an archive, you should save the archive ID returned so
that you can retrieve or delete the archive later. Besides saving the
archive ID, you can also index it and give it a friendly name to allow
for better searching. You can also use the optional archive description
field to specify how the archive is referred to in an external index of
archives, such as you might create in Amazon DynamoDB. You can also get
the vault inventory to obtain a list of archive IDs in a vault. For more
information, see InitiateJob.

You must provide a SHA256 tree hash of the data you are uploading. For
information about computing a SHA256 tree hash, see \href{https://docs.aws.amazon.com/amazonglacier/latest/dev/checksum-calculations.html}{Computing Checksums}.

You can optionally specify an archive description of up to 1,024
printable ASCII characters. You can get the archive description when you
either retrieve the archive or get the vault inventory. For more
information, see InitiateJob. Amazon Glacier does not interpret the
description in any way. An archive description does not need to be
unique. You cannot use the description to retrieve or sort the archive
list.

Archives are immutable. After you upload an archive, you cannot edit the
archive or its description.

An AWS account has full permission to perform all operations (actions).
However, AWS Identity and Access Management (IAM) users don't have any
permissions by default. You must grant them explicit permission to
perform specific actions. For more information, see \href{https://docs.aws.amazon.com/amazonglacier/latest/dev/auth-and-access-control.html}{Access Control Using AWS Identity and Access Management (IAM)}.

For conceptual information and underlying REST API, see \href{https://docs.aws.amazon.com/amazonglacier/latest/dev/uploading-an-archive.html}{Uploading an Archive in Amazon Glacier}
and \href{https://docs.aws.amazon.com/amazonglacier/latest/dev/api-archive-post.html}{Upload Archive}
in the \emph{Amazon Glacier Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$upload_archive(
  vaultName = "string",
  accountId = "string",
  archiveDescription = "string",
  checksum = "string",
  body = raw
)
}
}

\examples{
\dontrun{
# The example adds an archive to a vault.
svc$upload_archive(
  accountId = "-",
  archiveDescription = "",
  body = "example-data-to-upload",
  checksum = "",
  vaultName = "my-vault"
)
}

}
\keyword{internal}
