% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/storagegateway_operations.R
\name{storagegateway_create_tapes}
\alias{storagegateway_create_tapes}
\title{Creates one or more virtual tapes}
\usage{
storagegateway_create_tapes(GatewayARN, TapeSizeInBytes, ClientToken,
  NumTapesToCreate, TapeBarcodePrefix, KMSEncrypted, KMSKey, PoolId, Worm,
  Tags)
}
\arguments{
\item{GatewayARN}{[required] The unique Amazon Resource Name (ARN) that represents the gateway to
associate the virtual tapes with. Use the ListGateways operation to
return a list of gateways for your account and AWS Region.}

\item{TapeSizeInBytes}{[required] The size, in bytes, of the virtual tapes that you want to create.

The size must be aligned by gigabyte (1024\emph{1024}1024 bytes).}

\item{ClientToken}{[required] A unique identifier that you use to retry a request. If you retry a
request, use the same \code{ClientToken} you specified in the initial
request.

Using the same \code{ClientToken} prevents creating the tape multiple times.}

\item{NumTapesToCreate}{[required] The number of virtual tapes that you want to create.}

\item{TapeBarcodePrefix}{[required] A prefix that you append to the barcode of the virtual tape you are
creating. This prefix makes the barcode unique.

The prefix must be 1 to 4 characters in length and must be one of the
uppercase letters from A to Z.}

\item{KMSEncrypted}{Set to \code{true} to use Amazon S3 server-side encryption with your own AWS
KMS key, or \code{false} to use a key managed by Amazon S3. Optional.

Valid Values: \code{true} | \code{false}}

\item{KMSKey}{The Amazon Resource Name (ARN) of a symmetric customer master key (CMK)
used for Amazon S3 server-side encryption. Storage Gateway does not
support asymmetric CMKs. This value can only be set when \code{KMSEncrypted}
is \code{true}. Optional.}

\item{PoolId}{The ID of the pool that you want to add your tape to for archiving. The
tape in this pool is archived in the S3 storage class that is associated
with the pool. When you use your backup application to eject the tape,
the tape is archived directly into the storage class (S3 Glacier or S3
Glacier Deep Archive) that corresponds to the pool.

Valid Values: \code{GLACIER} | \code{DEEP_ARCHIVE}}

\item{Worm}{Set to \code{TRUE} if the tape you are creating is to be configured as a
write-once-read-many (WORM) tape.}

\item{Tags}{A list of up to 50 tags that can be assigned to a virtual tape. Each tag
is a key-value pair.

Valid characters for key and value are letters, spaces, and numbers
representable in UTF-8 format, and the following special characters: + -
= . \\_ : / @. The maximum length of a tag's key is 128 characters, and
the maximum length for a tag's value is 256.}
}
\description{
Creates one or more virtual tapes. You write data to the virtual tapes
and then archive the tapes. This operation is only supported in the tape
gateway type.

Cache storage must be allocated to the gateway before you can create
virtual tapes. Use the AddCache operation to add cache storage to a
gateway.
}
\section{Request syntax}{
\preformatted{svc$create_tapes(
  GatewayARN = "string",
  TapeSizeInBytes = 123,
  ClientToken = "string",
  NumTapesToCreate = 123,
  TapeBarcodePrefix = "string",
  KMSEncrypted = TRUE|FALSE,
  KMSKey = "string",
  PoolId = "string",
  Worm = TRUE|FALSE,
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\examples{
\dontrun{
# Creates one or more virtual tapes.
svc$create_tapes(
  ClientToken = "77777",
  GatewayARN = "arn:aws:storagegateway:us-east-1:999999999999:gateway/sgw-12A3456B",
  NumTapesToCreate = 3L,
  TapeBarcodePrefix = "TEST",
  TapeSizeInBytes = 107374182400
)
}

}
\keyword{internal}
