% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_put_bucket_lifecycle_configuration}
\alias{s3_put_bucket_lifecycle_configuration}
\title{Creates a new lifecycle configuration for the bucket or replaces an
existing lifecycle configuration}
\usage{
s3_put_bucket_lifecycle_configuration(Bucket, LifecycleConfiguration,
  ExpectedBucketOwner)
}
\arguments{
\item{Bucket}{[required] The name of the bucket for which to set the configuration.}

\item{LifecycleConfiguration}{Container for lifecycle rules. You can add as many as 1,000 rules.}

\item{ExpectedBucketOwner}{The account id of the expected bucket owner. If the bucket is owned by a
different account, the request will fail with an HTTP
\verb{403 (Access Denied)} error.}
}
\value{
An empty list.
}
\description{
Creates a new lifecycle configuration for the bucket or replaces an
existing lifecycle configuration. For information about lifecycle
configuration, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html}{Managing Access Permissions to Your Amazon S3 Resources}.

Bucket lifecycle configuration now supports specifying a lifecycle rule
using an object key name prefix, one or more object tags, or a
combination of both. Accordingly, this section describes the latest API.
The previous version of the API supported filtering based only on an
object key name prefix, which is supported for backward compatibility.
For the related API description, see
\code{\link[=s3_put_bucket_lifecycle]{put_bucket_lifecycle}}.

\strong{Rules}

You specify the lifecycle configuration in your request body. The
lifecycle configuration is specified as XML consisting of one or more
rules. Each rule consists of the following:
\itemize{
\item Filter identifying a subset of objects to which the rule applies.
The filter can be based on a key name prefix, object tags, or a
combination of both.
\item Status whether the rule is in effect.
\item One or more lifecycle transition and expiration actions that you
want Amazon S3 to perform on the objects identified by the filter.
If the state of your bucket is versioning-enabled or
versioning-suspended, you can have many versions of the same object
(one current version and zero or more noncurrent versions). Amazon
S3 provides predefined actions that you can specify for current and
noncurrent object versions.
}

For more information, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-lifecycle-mgmt.html}{Object Lifecycle Management}
and \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/intro-lifecycle-rules.html}{Lifecycle Configuration Elements}.

\strong{Permissions}

By default, all Amazon S3 resources are private, including buckets,
objects, and related subresources (for example, lifecycle configuration
and website configuration). Only the resource owner (that is, the AWS
account that created it) can access the resource. The resource owner can
optionally grant access permissions to others by writing an access
policy. For this operation, a user must get the
s3:PutLifecycleConfiguration permission.

You can also explicitly deny permissions. Explicit deny also supersedes
any other permissions. If you want to block users or accounts from
removing or deleting objects from your bucket, you must deny them
permissions for the following actions:
\itemize{
\item s3:DeleteObject
\item s3:DeleteObjectVersion
\item s3:PutLifecycleConfiguration
}

For more information about permissions, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html}{Managing Access Permissions to Your Amazon S3 Resources}.

The following are related to
\code{\link[=s3_put_bucket_lifecycle_configuration]{put_bucket_lifecycle_configuration}}:
\itemize{
\item \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/lifecycle-configuration-examples.html}{Examples of Lifecycle Configuration}
\item \code{\link[=s3_get_bucket_lifecycle_configuration]{get_bucket_lifecycle_configuration}}
\item \code{\link[=s3_delete_bucket_lifecycle]{delete_bucket_lifecycle}}
}
}
\section{Request syntax}{
\preformatted{svc$put_bucket_lifecycle_configuration(
  Bucket = "string",
  LifecycleConfiguration = list(
    Rules = list(
      list(
        Expiration = list(
          Date = as.POSIXct(
            "2015-01-01"
          ),
          Days = 123,
          ExpiredObjectDeleteMarker = TRUE|FALSE
        ),
        ID = "string",
        Prefix = "string",
        Filter = list(
          Prefix = "string",
          Tag = list(
            Key = "string",
            Value = "string"
          ),
          And = list(
            Prefix = "string",
            Tags = list(
              list(
                Key = "string",
                Value = "string"
              )
            )
          )
        ),
        Status = "Enabled"|"Disabled",
        Transitions = list(
          list(
            Date = as.POSIXct(
              "2015-01-01"
            ),
            Days = 123,
            StorageClass = "GLACIER"|"STANDARD_IA"|"ONEZONE_IA"|"INTELLIGENT_TIERING"|"DEEP_ARCHIVE"
          )
        ),
        NoncurrentVersionTransitions = list(
          list(
            NoncurrentDays = 123,
            StorageClass = "GLACIER"|"STANDARD_IA"|"ONEZONE_IA"|"INTELLIGENT_TIERING"|"DEEP_ARCHIVE"
          )
        ),
        NoncurrentVersionExpiration = list(
          NoncurrentDays = 123
        ),
        AbortIncompleteMultipartUpload = list(
          DaysAfterInitiation = 123
        )
      )
    )
  ),
  ExpectedBucketOwner = "string"
)
}
}

\examples{
\dontrun{
# The following example replaces existing lifecycle configuration, if any,
# on the specified bucket.
svc$put_bucket_lifecycle_configuration(
  Bucket = "examplebucket",
  LifecycleConfiguration = list(
    Rules = list(
      list(
        Expiration = list(
          Days = 3650L
        ),
        Filter = list(
          Prefix = "documents/"
        ),
        ID = "TestOnly",
        Status = "Enabled",
        Transitions = list(
          list(
            Days = 365L,
            StorageClass = "GLACIER"
          )
        )
      )
    )
  )
)
}

}
\keyword{internal}
