% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/storagegateway_operations.R
\name{storagegateway_set_smb_guest_password}
\alias{storagegateway_set_smb_guest_password}
\title{Sets the password for the guest user smbguest}
\usage{
storagegateway_set_smb_guest_password(GatewayARN, Password)
}
\arguments{
\item{GatewayARN}{[required] The Amazon Resource Name (ARN) of the file gateway the SMB file share is
associated with.}

\item{Password}{[required] The password that you want to set for your SMB server.}
}
\value{
A list with the following syntax:\preformatted{list(
  GatewayARN = "string"
)
}
}
\description{
Sets the password for the guest user \code{smbguest}. The \code{smbguest} user is
the user when the authentication method for the file share is set to
\code{GuestAccess}.
}
\section{Request syntax}{
\preformatted{svc$set_smb_guest_password(
  GatewayARN = "string",
  Password = "string"
)
}
}

\keyword{internal}
