% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_get_bucket_replication}
\alias{s3_get_bucket_replication}
\title{Returns the replication configuration of a bucket}
\usage{
s3_get_bucket_replication(Bucket)
}
\arguments{
\item{Bucket}{[required]}
}
\description{
Returns the replication configuration of a bucket.
}
\details{
It can take a while to propagate the put or delete a replication
configuration to all Amazon S3 systems. Therefore, a get request soon
after put or delete can return a wrong result.
}
\section{Request syntax}{
\preformatted{svc$get_bucket_replication(
  Bucket = "string"
)
}
}

\examples{
# The following example returns replication configuration set on a bucket.
\donttest{svc$get_bucket_replication(
  Bucket = "examplebucket"
)}

}
\keyword{internal}
