% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/storagegateway_operations.R
\name{storagegateway_describe_tape_archives}
\alias{storagegateway_describe_tape_archives}
\title{Returns a description of specified virtual tapes in the virtual tape
shelf (VTS)}
\usage{
storagegateway_describe_tape_archives(TapeARNs, Marker, Limit)
}
\arguments{
\item{TapeARNs}{Specifies one or more unique Amazon Resource Names (ARNs) that represent
the virtual tapes you want to describe.}

\item{Marker}{An opaque string that indicates the position at which to begin
describing virtual tapes.}

\item{Limit}{Specifies that the number of virtual tapes descried be limited to the
specified number.}
}
\description{
Returns a description of specified virtual tapes in the virtual tape
shelf (VTS). This operation is only supported in the tape gateway type.
}
\details{
If a specific \code{TapeARN} is not specified, AWS Storage Gateway returns a
description of all virtual tapes found in the VTS associated with your
account.
}
\section{Request syntax}{
\preformatted{svc$describe_tape_archives(
  TapeARNs = list(
    "string"
  ),
  Marker = "string",
  Limit = 123
)
}
}

\examples{
# Returns a description of specified virtual tapes in the virtual tape
# shelf (VTS).
\donttest{svc$describe_tape_archives(
  Limit = 123L,
  Marker = "1",
  TapeARNs = list(
    "arn:aws:storagegateway:us-east-1:999999999999:tape/AM08A1AD",
    "arn:aws:storagegateway:us-east-1:999999999999:tape/AMZN01A2A4"
  )
)}

}
\keyword{internal}
