% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_put_bucket_logging}
\alias{s3_put_bucket_logging}
\title{Set the logging parameters for a bucket and to specify permissions for
who can view and modify the logging parameters}
\usage{
s3_put_bucket_logging(Bucket, BucketLoggingStatus, ContentMD5)
}
\arguments{
\item{Bucket}{[required]}

\item{BucketLoggingStatus}{[required]}

\item{ContentMD5}{}
}
\description{
Set the logging parameters for a bucket and to specify permissions for
who can view and modify the logging parameters. To set the logging
status of a bucket, you must be the bucket owner.
}
\section{Request syntax}{
\preformatted{svc$put_bucket_logging(
  Bucket = "string",
  BucketLoggingStatus = list(
    LoggingEnabled = list(
      TargetBucket = "string",
      TargetGrants = list(
        list(
          Grantee = list(
            DisplayName = "string",
            EmailAddress = "string",
            ID = "string",
            Type = "CanonicalUser"|"AmazonCustomerByEmail"|"Group",
            URI = "string"
          ),
          Permission = "FULL_CONTROL"|"READ"|"WRITE"
        )
      ),
      TargetPrefix = "string"
    )
  ),
  ContentMD5 = "string"
)
}
}

\examples{
# The following example sets logging policy on a bucket. For the Log
# Delivery group to deliver logs to the destination bucket, it needs
# permission for the READ_ACP action which the policy grants.
\donttest{svc$put_bucket_logging(
  Bucket = "sourcebucket",
  BucketLoggingStatus = list(
    LoggingEnabled = list(
      TargetBucket = "targetbucket",
      TargetGrants = list(
        list(
          Grantee = list(
            Type = "Group",
            URI = "http://acs.amazonaws.com/groups/global/AllUsers"
          ),
          Permission = "READ"
        )
      ),
      TargetPrefix = "MyBucketLogs/"
    )
  )
)}

}
\keyword{internal}
