% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_restore_object}
\alias{s3_restore_object}
\title{Restores an archived copy of an object back into Amazon S3}
\usage{
s3_restore_object(Bucket, Key, VersionId, RestoreRequest, RequestPayer)
}
\arguments{
\item{Bucket}{[required]}

\item{Key}{[required]}

\item{VersionId}{}

\item{RestoreRequest}{}

\item{RequestPayer}{}
}
\description{
Restores an archived copy of an object back into Amazon S3
}
\section{Request syntax}{
\preformatted{svc$restore_object(
  Bucket = "string",
  Key = "string",
  VersionId = "string",
  RestoreRequest = list(
    Days = 123,
    GlacierJobParameters = list(
      Tier = "Standard"|"Bulk"|"Expedited"
    ),
    Type = "SELECT",
    Tier = "Standard"|"Bulk"|"Expedited",
    Description = "string",
    SelectParameters = list(
      InputSerialization = list(
        CSV = list(
          FileHeaderInfo = "USE"|"IGNORE"|"NONE",
          Comments = "string",
          QuoteEscapeCharacter = "string",
          RecordDelimiter = "string",
          FieldDelimiter = "string",
          QuoteCharacter = "string",
          AllowQuotedRecordDelimiter = TRUE|FALSE
        ),
        CompressionType = "NONE"|"GZIP"|"BZIP2",
        JSON = list(
          Type = "DOCUMENT"|"LINES"
        ),
        Parquet = list()
      ),
      ExpressionType = "SQL",
      Expression = "string",
      OutputSerialization = list(
        CSV = list(
          QuoteFields = "ALWAYS"|"ASNEEDED",
          QuoteEscapeCharacter = "string",
          RecordDelimiter = "string",
          FieldDelimiter = "string",
          QuoteCharacter = "string"
        ),
        JSON = list(
          RecordDelimiter = "string"
        )
      )
    ),
    OutputLocation = list(
      S3 = list(
        BucketName = "string",
        Prefix = "string",
        Encryption = list(
          EncryptionType = "AES256"|"aws:kms",
          KMSKeyId = "string",
          KMSContext = "string"
        ),
        CannedACL = "private"|"public-read"|"public-read-write"|"authenticated-read"|"aws-exec-read"|"bucket-owner-read"|"bucket-owner-full-control",
        AccessControlList = list(
          list(
            Grantee = list(
              DisplayName = "string",
              EmailAddress = "string",
              ID = "string",
              Type = "CanonicalUser"|"AmazonCustomerByEmail"|"Group",
              URI = "string"
            ),
            Permission = "FULL_CONTROL"|"WRITE"|"WRITE_ACP"|"READ"|"READ_ACP"
          )
        ),
        Tagging = list(
          TagSet = list(
            list(
              Key = "string",
              Value = "string"
            )
          )
        ),
        UserMetadata = list(
          list(
            Name = "string",
            Value = "string"
          )
        ),
        StorageClass = "STANDARD"|"REDUCED_REDUNDANCY"|"STANDARD_IA"|"ONEZONE_IA"|"INTELLIGENT_TIERING"|"GLACIER"|"DEEP_ARCHIVE"
      )
    )
  ),
  RequestPayer = "requester"
)
}
}

\examples{
# The following example restores for one day an archived copy of an object
# back into Amazon S3 bucket.
\donttest{svc$restore_object(
  Bucket = "examplebucket",
  Key = "archivedobjectkey",
  RestoreRequest = list(
    Days = 1L,
    GlacierJobParameters = list(
      Tier = "Expedited"
    )
  )
)}

}
\keyword{internal}
