% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_head_bucket}
\alias{s3_head_bucket}
\title{This operation is useful to determine if a bucket exists and you have
permission to access it}
\usage{
s3_head_bucket(Bucket)
}
\arguments{
\item{Bucket}{[required] The bucket name.}
}
\description{
This operation is useful to determine if a bucket exists and you have
permission to access it. The operation returns a \verb{200 OK} if the bucket
exists and you have permission to access it. Otherwise, the operation
might return responses such as \verb{404 Not Found} and \verb{403 Forbidden}.
}
\details{
To use this operation, you must have permissions to perform the
\code{s3:ListBucket} action. The bucket owner has this permission by default
and can grant this permission to others. For more information about
permissions, see \href{https://docs.aws.amazon.com/AmazonS3/latest/dev/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources}{Permissions Related to Bucket Subresource Operations}
and \href{https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-access-control.html}{Managing Access Permissions to Your Amazon S3 Resources}.
}
\section{Request syntax}{
\preformatted{svc$head_bucket(
  Bucket = "string"
)
}
}

\examples{
# This operation checks to see if a bucket exists.
\donttest{svc$head_bucket(
  Bucket = "acl1"
)}

}
\keyword{internal}
