% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_get_bucket_policy}
\alias{s3_get_bucket_policy}
\title{Returns the policy of a specified bucket}
\usage{
s3_get_bucket_policy(Bucket)
}
\arguments{
\item{Bucket}{[required] The bucket name for which to get the bucket policy.}
}
\description{
Returns the policy of a specified bucket. If you are using an identity
other than the root user of the AWS account that owns the bucket, the
calling identity must have the \code{GetBucketPolicy} permissions on the
specified bucket and belong to the bucket owner\'s account in order to
use this operation.
}
\details{
If you don\'t have \code{GetBucketPolicy} permissions, Amazon S3 returns a
\verb{403 Access Denied} error. If you have the correct permissions, but
you\'re not using an identity that belongs to the bucket owner\'s
account, Amazon S3 returns a \verb{405 Method Not Allowed} error.

As a security precaution, the root user of the AWS account that owns a
bucket can always use this operation, even if the policy explicitly
denies the root user the ability to perform this action.

For more information about bucket policies, see \href{https://docs.aws.amazon.com/AmazonS3/latest/dev/using-iam-policies.html}{Using Bucket Policies and User Policies}.

The following operation is related to \code{GetBucketPolicy}:
\itemize{
\item GetObject
}
}
\section{Request syntax}{
\preformatted{svc$get_bucket_policy(
  Bucket = "string"
)
}
}

\examples{
# The following example returns bucket policy associated with a bucket.
\dontrun{svc$get_bucket_policy(
  Bucket = "examplebucket"
)}

}
\keyword{internal}
