% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/storagegateway_operations.R
\name{storagegateway_add_cache}
\alias{storagegateway_add_cache}
\title{Configures one or more gateway local disks as cache for a gateway}
\usage{
storagegateway_add_cache(GatewayARN, DiskIds)
}
\arguments{
\item{GatewayARN}{[required]}

\item{DiskIds}{[required] An array of strings that identify disks that are to be configured as
working storage. Each string have a minimum length of 1 and maximum
length of 300. You can get the disk IDs from the ListLocalDisks API.}
}
\description{
Configures one or more gateway local disks as cache for a gateway. This
operation is only supported in the cached volume, tape and file gateway
type (see \href{https://docs.aws.amazon.com/storagegateway/latest/userguide/StorageGatewayConcepts.html}{Storage Gateway Concepts}).
}
\details{
In the request, you specify the gateway Amazon Resource Name (ARN) to
which you want to add cache, and one or more disk IDs that you want to
configure as cache.
}
\section{Request syntax}{
\preformatted{svc$add_cache(
  GatewayARN = "string",
  DiskIds = list(
    "string"
  )
)
}
}

\examples{
# The following example shows a request that activates a gateway-stored
# volume.
\dontrun{svc$add_cache(
  DiskIds = list(
    "pci-0000:03:00.0-scsi-0:0:0:0",
    "pci-0000:03:00.0-scsi-0:0:1:0"
  ),
  GatewayARN = "arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-12A3456B"
)}

}
\keyword{internal}
