% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backup_operations.R
\name{backup_put_backup_vault_notifications}
\alias{backup_put_backup_vault_notifications}
\title{Turns on notifications on a backup vault for the specified topic and
events}
\usage{
backup_put_backup_vault_notifications(
  BackupVaultName,
  SNSTopicArn,
  BackupVaultEvents
)
}
\arguments{
\item{BackupVaultName}{[required] The name of a logical container where backups are stored. Backup vaults
are identified by names that are unique to the account used to create
them and the Amazon Web Services Region where they are created. They
consist of lowercase letters, numbers, and hyphens.}

\item{SNSTopicArn}{[required] The Amazon Resource Name (ARN) that specifies the topic for a backup
vault’s events; for example,
\code{arn:aws:sns:us-west-2:111122223333:MyVaultTopic}.}

\item{BackupVaultEvents}{[required] An array of events that indicate the status of jobs to back up resources
to the backup vault.

For common use cases and code samples, see \href{https://docs.aws.amazon.com/aws-backup/latest/devguide/}{Using Amazon SNS to track Backup events}.

The following events are supported:
\itemize{
\item \code{BACKUP_JOB_STARTED} | \code{BACKUP_JOB_COMPLETED}
\item \code{COPY_JOB_STARTED} | \code{COPY_JOB_SUCCESSFUL} | \code{COPY_JOB_FAILED}
\item \code{RESTORE_JOB_STARTED} | \code{RESTORE_JOB_COMPLETED} |
\code{RECOVERY_POINT_MODIFIED}
\item \code{S3_BACKUP_OBJECT_FAILED} | \code{S3_RESTORE_OBJECT_FAILED}
}

The list below shows items that are deprecated events (for reference)
and are no longer in use. They are no longer supported and will not
return statuses or notifications. Refer to the list above for current
supported events.}
}
\description{
Turns on notifications on a backup vault for the specified topic and events.

See \url{https://www.paws-r-sdk.com/docs/backup_put_backup_vault_notifications/} for full documentation.
}
\keyword{internal}
