% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paws.R
\name{resourcegroupstaggingapi}
\alias{resourcegroupstaggingapi}
\title{AWS Resource Groups Tagging API}
\usage{
resourcegroupstaggingapi()
}
\description{
Resource Groups Tagging API

This guide describes the API operations for the resource groups tagging.

A tag is a label that you assign to an AWS resource. A tag consists of a
key and a value, both of which you define. For example, if you have two
Amazon EC2 instances, you might assign both a tag key of "Stack." But
the value of "Stack" might be "Testing" for one and "Production"
for the other.

Tagging can help you organize your resources and enables you to simplify
resource management, access management and cost allocation.

You can use the resource groups tagging API operations to complete the
following tasks:
\itemize{
\item Tag and untag supported resources located in the specified region
for the AWS account
\item Use tag-based filters to search for resources located in the
specified region for the AWS account
\item List all existing tag keys in the specified region for the AWS
account
\item List all existing values for the specified key in the specified
region for the AWS account
}

To make full use of the resource groups tagging API operations, you
might need additional IAM permissions, including permission to access
the resources of individual services as well as permission to view and
apply tags to those resources. For more information, see \href{http://docs.aws.amazon.com/awsconsolehelpdocs/latest/gsg/obtaining-permissions-for-resource-groups.html}{Obtaining Permissions for Resource Groups and Tag Editor}.

You can use the Resource Groups Tagging API to tag resources for the
following AWS services.
\itemize{
\item Alexa for Business (a4b)
\item API Gateway
\item AWS AppStream
\item AWS AppSync
\item Amazon Athena
\item Amazon Aurora
\item AWS Certificate Manager
\item AWS Certificate Manager Private CA
\item Amazon Cloud Directory
\item AWS CloudFormation
\item Amazon CloudFront
\item AWS CloudHSM
\item AWS CloudTrail
\item Amazon CloudWatch (alarms only)
\item Amazon CloudWatch Events
\item Amazon CloudWatch Logs
\item AWS CodeBuild
\item AWS CodeStar
\item Amazon Cognito Identity
\item Amazon Cognito User Pools
\item Amazon Comprehend
\item AWS Config
\item AWS Data Pipeline
\item AWS Database Migration Service
\item AWS Datasync
\item AWS Direct Connect
\item AWS Directory Service
\item Amazon DynamoDB
\item Amazon EBS
\item Amazon EC2
\item Amazon ECR
\item Amazon ECS
\item AWS Elastic Beanstalk
\item Amazon Elastic File System
\item Elastic Load Balancing
\item Amazon ElastiCache
\item Amazon Elasticsearch Service
\item AWS Elemental MediaLive
\item AWS Elemental MediaPackage
\item AWS Elemental MediaTailor
\item Amazon EMR
\item Amazon FSx
\item Amazon Glacier
\item AWS Glue
\item Amazon Inspector
\item AWS IoT Analytics
\item AWS IoT Core
\item AWS IoT Device Defender
\item AWS IoT Device Management
\item AWS IoT Greengrass
\item AWS Key Management Service
\item Amazon Kinesis
\item Amazon Kinesis Data Analytics
\item Amazon Kinesis Data Firehose
\item AWS Lambda
\item AWS License Manager
\item Amazon Machine Learning
\item Amazon MQ
\item Amazon MSK
\item Amazon Neptune
\item AWS OpsWorks
\item Amazon RDS
\item Amazon Redshift
\item AWS Resource Access Manager
\item AWS Resource Groups
\item AWS RoboMaker
\item Amazon Route 53
\item Amazon Route 53 Resolver
\item Amazon S3 (buckets only)
\item Amazon SageMaker
\item AWS Secrets Manager
\item AWS Service Catalog
\item Amazon Simple Notification Service (SNS)
\item Amazon Simple Queue Service (SQS)
\item AWS Simple System Manager (SSM)
\item AWS Step Functions
\item AWS Storage Gateway
\item AWS Transfer for SFTP
\item Amazon VPC
\item Amazon WorkSpaces
}
}
\section{Operations}{

\tabular{ll}{
\link[=resourcegroupstaggingapi_get_resources]{get_resources} \tab Returns all the tagged or previously tagged resources that are located in the specified region for the AWS account\cr
\link[=resourcegroupstaggingapi_get_tag_keys]{get_tag_keys} \tab Returns all tag keys in the specified region for the AWS account \cr
\link[=resourcegroupstaggingapi_get_tag_values]{get_tag_values} \tab Returns all tag values for the specified key in the specified region for the AWS account \cr
\link[=resourcegroupstaggingapi_tag_resources]{tag_resources} \tab Applies one or more tags to the specified resources \cr
\link[=resourcegroupstaggingapi_untag_resources]{untag_resources} \tab Removes the specified tags from the specified resources
}
}

\examples{
\donttest{svc <- resourcegroupstaggingapi()
svc$get_resources(
  Foo = 123
)}

}
