% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paws.R
\name{imagebuilder}
\alias{imagebuilder}
\title{EC2 Image Builder}
\usage{
imagebuilder(config = list())
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.
\itemize{
\item{\strong{access_key_id}:} {AWS access key ID}
\item{\strong{secret_access_key}:} {AWS secret access key}
\item{\strong{session_token}:} {AWS temporary session token}
\item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}:} {Set anonymous credentials.}
\item{\strong{endpoint}:} {The complete URL to use for the constructed client.}
\item{\strong{region}:} {The AWS Region used in instantiating the client.}
\item{\strong{close_connection}:} {Immediately close all HTTP connections.}
\item{\strong{timeout}:} {The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
\item{\strong{s3_force_path_style}:} {Set this to \code{true} to force the request to use path-style addressing, i.e., \verb{http://s3.amazonaws.com/BUCKET/KEY}.}
}}
}
\value{
A client for the service. You can call the service's operations using
syntax like \code{svc$operation(...)}, where \code{svc} is the name you've assigned
to the client. The available operations are listed in the
Operations section.
}
\description{
EC2 Image Builder is a fully managed Amazon Web Services service that
makes it easier to automate the creation, management, and deployment of
customized, secure, and up-to-date "golden" server images that are
pre-installed and pre-configured with software and settings to meet
specific IT standards.
}
\section{Service syntax}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{svc <- imagebuilder(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string",
      anonymous = "logical"
    ),
    endpoint = "string",
    region = "string",
    close_connection = "logical",
    timeout = "numeric",
    s3_force_path_style = "logical"
  )
)
}\if{html}{\out{</div>}}
}

\section{Operations}{

\tabular{ll}{
\link[paws.compute:imagebuilder_cancel_image_creation]{cancel_image_creation} \tab CancelImageCreation cancels the creation of Image\cr
\link[paws.compute:imagebuilder_create_component]{create_component} \tab Creates a new component that can be used to build, validate, test, and assess your image\cr
\link[paws.compute:imagebuilder_create_container_recipe]{create_container_recipe} \tab Creates a new container recipe\cr
\link[paws.compute:imagebuilder_create_distribution_configuration]{create_distribution_configuration} \tab Creates a new distribution configuration\cr
\link[paws.compute:imagebuilder_create_image]{create_image} \tab Creates a new image\cr
\link[paws.compute:imagebuilder_create_image_pipeline]{create_image_pipeline} \tab Creates a new image pipeline\cr
\link[paws.compute:imagebuilder_create_image_recipe]{create_image_recipe} \tab Creates a new image recipe\cr
\link[paws.compute:imagebuilder_create_infrastructure_configuration]{create_infrastructure_configuration} \tab Creates a new infrastructure configuration\cr
\link[paws.compute:imagebuilder_delete_component]{delete_component} \tab Deletes a component build version\cr
\link[paws.compute:imagebuilder_delete_container_recipe]{delete_container_recipe} \tab Deletes a container recipe\cr
\link[paws.compute:imagebuilder_delete_distribution_configuration]{delete_distribution_configuration} \tab Deletes a distribution configuration\cr
\link[paws.compute:imagebuilder_delete_image]{delete_image} \tab Deletes an Image Builder image resource\cr
\link[paws.compute:imagebuilder_delete_image_pipeline]{delete_image_pipeline} \tab Deletes an image pipeline\cr
\link[paws.compute:imagebuilder_delete_image_recipe]{delete_image_recipe} \tab Deletes an image recipe\cr
\link[paws.compute:imagebuilder_delete_infrastructure_configuration]{delete_infrastructure_configuration} \tab Deletes an infrastructure configuration\cr
\link[paws.compute:imagebuilder_get_component]{get_component} \tab Gets a component object\cr
\link[paws.compute:imagebuilder_get_component_policy]{get_component_policy} \tab Gets a component policy\cr
\link[paws.compute:imagebuilder_get_container_recipe]{get_container_recipe} \tab Retrieves a container recipe\cr
\link[paws.compute:imagebuilder_get_container_recipe_policy]{get_container_recipe_policy} \tab Retrieves the policy for a container recipe\cr
\link[paws.compute:imagebuilder_get_distribution_configuration]{get_distribution_configuration} \tab Gets a distribution configuration\cr
\link[paws.compute:imagebuilder_get_image]{get_image} \tab Gets an image\cr
\link[paws.compute:imagebuilder_get_image_pipeline]{get_image_pipeline} \tab Gets an image pipeline\cr
\link[paws.compute:imagebuilder_get_image_policy]{get_image_policy} \tab Gets an image policy\cr
\link[paws.compute:imagebuilder_get_image_recipe]{get_image_recipe} \tab Gets an image recipe\cr
\link[paws.compute:imagebuilder_get_image_recipe_policy]{get_image_recipe_policy} \tab Gets an image recipe policy\cr
\link[paws.compute:imagebuilder_get_infrastructure_configuration]{get_infrastructure_configuration} \tab Gets an infrastructure configuration\cr
\link[paws.compute:imagebuilder_import_component]{import_component} \tab Imports a component and transforms its data into a component document\cr
\link[paws.compute:imagebuilder_import_vm_image]{import_vm_image} \tab When you export your virtual machine (VM) from its virtualization environment, that process creates a set of one or more disk container files that act as snapshots of your VM’s environment, settings, and data\cr
\link[paws.compute:imagebuilder_list_component_build_versions]{list_component_build_versions} \tab Returns the list of component build versions for the specified semantic version\cr
\link[paws.compute:imagebuilder_list_components]{list_components} \tab Returns the list of component build versions for the specified semantic version\cr
\link[paws.compute:imagebuilder_list_container_recipes]{list_container_recipes} \tab Returns a list of container recipes\cr
\link[paws.compute:imagebuilder_list_distribution_configurations]{list_distribution_configurations} \tab Returns a list of distribution configurations\cr
\link[paws.compute:imagebuilder_list_image_build_versions]{list_image_build_versions} \tab Returns a list of image build versions\cr
\link[paws.compute:imagebuilder_list_image_packages]{list_image_packages} \tab List the Packages that are associated with an Image Build Version, as determined by Amazon Web Services Systems Manager Inventory at build time\cr
\link[paws.compute:imagebuilder_list_image_pipeline_images]{list_image_pipeline_images} \tab Returns a list of images created by the specified pipeline\cr
\link[paws.compute:imagebuilder_list_image_pipelines]{list_image_pipelines} \tab Returns a list of image pipelines\cr
\link[paws.compute:imagebuilder_list_image_recipes]{list_image_recipes} \tab Returns a list of image recipes\cr
\link[paws.compute:imagebuilder_list_images]{list_images} \tab Returns the list of images that you have access to\cr
\link[paws.compute:imagebuilder_list_infrastructure_configurations]{list_infrastructure_configurations} \tab Returns a list of infrastructure configurations\cr
\link[paws.compute:imagebuilder_list_tags_for_resource]{list_tags_for_resource} \tab Returns the list of tags for the specified resource\cr
\link[paws.compute:imagebuilder_put_component_policy]{put_component_policy} \tab Applies a policy to a component\cr
\link[paws.compute:imagebuilder_put_container_recipe_policy]{put_container_recipe_policy} \tab Applies a policy to a container image\cr
\link[paws.compute:imagebuilder_put_image_policy]{put_image_policy} \tab Applies a policy to an image\cr
\link[paws.compute:imagebuilder_put_image_recipe_policy]{put_image_recipe_policy} \tab Applies a policy to an image recipe\cr
\link[paws.compute:imagebuilder_start_image_pipeline_execution]{start_image_pipeline_execution} \tab Manually triggers a pipeline to create an image\cr
\link[paws.compute:imagebuilder_tag_resource]{tag_resource} \tab Adds a tag to a resource\cr
\link[paws.compute:imagebuilder_untag_resource]{untag_resource} \tab Removes a tag from a resource\cr
\link[paws.compute:imagebuilder_update_distribution_configuration]{update_distribution_configuration} \tab Updates a new distribution configuration\cr
\link[paws.compute:imagebuilder_update_image_pipeline]{update_image_pipeline} \tab Updates an image pipeline\cr
\link[paws.compute:imagebuilder_update_infrastructure_configuration]{update_infrastructure_configuration} \tab Updates a new infrastructure configuration
}
}

\examples{
\dontrun{
svc <- imagebuilder()
svc$cancel_image_creation(
  Foo = 123
)
}

}
