% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paws.R
\name{lakeformation}
\alias{lakeformation}
\title{AWS Lake Formation}
\usage{
lakeformation(
  config = list(),
  credentials = list(),
  endpoint = NULL,
  region = NULL
)
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.
\itemize{
\item{\strong{credentials}:} {\itemize{
\item{\strong{creds}:} {\itemize{
\item{\strong{access_key_id}:} {AWS access key ID}
\item{\strong{secret_access_key}:} {AWS secret access key}
\item{\strong{session_token}:} {AWS temporary session token}
}}
\item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}:} {Set anonymous credentials.}
\item{\strong{endpoint}:} {The complete URL to use for the constructed client.}
\item{\strong{region}:} {The AWS Region used in instantiating the client.}
}}
\item{\strong{close_connection}:} {Immediately close all HTTP connections.}
\item{\strong{timeout}:} {The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
\item{\strong{s3_force_path_style}:} {Set this to \code{true} to force the request to use path-style addressing, i.e. \verb{http://s3.amazonaws.com/BUCKET/KEY}.}
\item{\strong{sts_regional_endpoint}:} {Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
}}

\item{credentials}{Optional credentials shorthand for the config parameter
\itemize{
\item{\strong{creds}:} {\itemize{
\item{\strong{access_key_id}:} {AWS access key ID}
\item{\strong{secret_access_key}:} {AWS secret access key}
\item{\strong{session_token}:} {AWS temporary session token}
}}
\item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}:} {Set anonymous credentials.}
}}

\item{endpoint}{Optional shorthand for complete URL to use for the constructed client.}

\item{region}{Optional shorthand for AWS Region used in instantiating the client.}
}
\value{
A client for the service. You can call the service's operations using
syntax like \code{svc$operation(...)}, where \code{svc} is the name you've assigned
to the client. The available operations are listed in the
Operations section.
}
\description{
Lake Formation

Defines the public endpoint for the Lake Formation service.
}
\section{Service syntax}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{svc <- lakeformation(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string",
      anonymous = "logical"
    ),
    endpoint = "string",
    region = "string",
    close_connection = "logical",
    timeout = "numeric",
    s3_force_path_style = "logical",
    sts_regional_endpoint = "string"
  ),
  credentials = list(
    creds = list(
      access_key_id = "string",
      secret_access_key = "string",
      session_token = "string"
    ),
    profile = "string",
    anonymous = "logical"
  ),
  endpoint = "string",
  region = "string"
)
}\if{html}{\out{</div>}}
}

\section{Operations}{

\tabular{ll}{
\link[paws.database:lakeformation_add_lf_tags_to_resource]{add_lf_tags_to_resource} \tab Attaches one or more LF-tags to an existing resource\cr
\link[paws.database:lakeformation_assume_decorated_role_with_saml]{assume_decorated_role_with_saml} \tab Allows a caller to assume an IAM role decorated as the SAML user specified in the SAML assertion included in the request\cr
\link[paws.database:lakeformation_batch_grant_permissions]{batch_grant_permissions} \tab Batch operation to grant permissions to the principal\cr
\link[paws.database:lakeformation_batch_revoke_permissions]{batch_revoke_permissions} \tab Batch operation to revoke permissions from the principal\cr
\link[paws.database:lakeformation_cancel_transaction]{cancel_transaction} \tab Attempts to cancel the specified transaction\cr
\link[paws.database:lakeformation_commit_transaction]{commit_transaction} \tab Attempts to commit the specified transaction\cr
\link[paws.database:lakeformation_create_data_cells_filter]{create_data_cells_filter} \tab Creates a data cell filter to allow one to grant access to certain columns on certain rows\cr
\link[paws.database:lakeformation_create_lf_tag]{create_lf_tag} \tab Creates an LF-tag with the specified name and values\cr
\link[paws.database:lakeformation_delete_data_cells_filter]{delete_data_cells_filter} \tab Deletes a data cell filter\cr
\link[paws.database:lakeformation_delete_lf_tag]{delete_lf_tag} \tab Deletes the specified LF-tag given a key name\cr
\link[paws.database:lakeformation_delete_objects_on_cancel]{delete_objects_on_cancel} \tab For a specific governed table, provides a list of Amazon S3 objects that will be written during the current transaction and that can be automatically deleted if the transaction is canceled\cr
\link[paws.database:lakeformation_deregister_resource]{deregister_resource} \tab Deregisters the resource as managed by the Data Catalog\cr
\link[paws.database:lakeformation_describe_resource]{describe_resource} \tab Retrieves the current data access role for the given resource registered in Lake Formation\cr
\link[paws.database:lakeformation_describe_transaction]{describe_transaction} \tab Returns the details of a single transaction\cr
\link[paws.database:lakeformation_extend_transaction]{extend_transaction} \tab Indicates to the service that the specified transaction is still active and should not be treated as idle and aborted\cr
\link[paws.database:lakeformation_get_data_cells_filter]{get_data_cells_filter} \tab Returns a data cells filter\cr
\link[paws.database:lakeformation_get_data_lake_settings]{get_data_lake_settings} \tab Retrieves the list of the data lake administrators of a Lake Formation-managed data lake\cr
\link[paws.database:lakeformation_get_effective_permissions_for_path]{get_effective_permissions_for_path} \tab Returns the Lake Formation permissions for a specified table or database resource located at a path in Amazon S3\cr
\link[paws.database:lakeformation_get_lf_tag]{get_lf_tag} \tab Returns an LF-tag definition\cr
\link[paws.database:lakeformation_get_query_state]{get_query_state} \tab Returns the state of a query previously submitted\cr
\link[paws.database:lakeformation_get_query_statistics]{get_query_statistics} \tab Retrieves statistics on the planning and execution of a query\cr
\link[paws.database:lakeformation_get_resource_lf_tags]{get_resource_lf_tags} \tab Returns the LF-tags applied to a resource\cr
\link[paws.database:lakeformation_get_table_objects]{get_table_objects} \tab Returns the set of Amazon S3 objects that make up the specified governed table\cr
\link[paws.database:lakeformation_get_temporary_glue_partition_credentials]{get_temporary_glue_partition_credentials} \tab This API is identical to GetTemporaryTableCredentials except that this is used when the target Data Catalog resource is of type Partition\cr
\link[paws.database:lakeformation_get_temporary_glue_table_credentials]{get_temporary_glue_table_credentials} \tab Allows a caller in a secure environment to assume a role with permission to access Amazon S3\cr
\link[paws.database:lakeformation_get_work_unit_results]{get_work_unit_results} \tab Returns the work units resulting from the query\cr
\link[paws.database:lakeformation_get_work_units]{get_work_units} \tab Retrieves the work units generated by the StartQueryPlanning operation\cr
\link[paws.database:lakeformation_grant_permissions]{grant_permissions} \tab Grants permissions to the principal to access metadata in the Data Catalog and data organized in underlying data storage such as Amazon S3\cr
\link[paws.database:lakeformation_list_data_cells_filter]{list_data_cells_filter} \tab Lists all the data cell filters on a table\cr
\link[paws.database:lakeformation_list_lf_tags]{list_lf_tags} \tab Lists LF-tags that the requester has permission to view\cr
\link[paws.database:lakeformation_list_permissions]{list_permissions} \tab Returns a list of the principal permissions on the resource, filtered by the permissions of the caller\cr
\link[paws.database:lakeformation_list_resources]{list_resources} \tab Lists the resources registered to be managed by the Data Catalog\cr
\link[paws.database:lakeformation_list_table_storage_optimizers]{list_table_storage_optimizers} \tab Returns the configuration of all storage optimizers associated with a specified table\cr
\link[paws.database:lakeformation_list_transactions]{list_transactions} \tab Returns metadata about transactions and their status\cr
\link[paws.database:lakeformation_put_data_lake_settings]{put_data_lake_settings} \tab Sets the list of data lake administrators who have admin privileges on all resources managed by Lake Formation\cr
\link[paws.database:lakeformation_register_resource]{register_resource} \tab Registers the resource as managed by the Data Catalog\cr
\link[paws.database:lakeformation_remove_lf_tags_from_resource]{remove_lf_tags_from_resource} \tab Removes an LF-tag from the resource\cr
\link[paws.database:lakeformation_revoke_permissions]{revoke_permissions} \tab Revokes permissions to the principal to access metadata in the Data Catalog and data organized in underlying data storage such as Amazon S3\cr
\link[paws.database:lakeformation_search_databases_by_lf_tags]{search_databases_by_lf_tags} \tab This operation allows a search on DATABASE resources by TagCondition\cr
\link[paws.database:lakeformation_search_tables_by_lf_tags]{search_tables_by_lf_tags} \tab This operation allows a search on TABLE resources by LFTags\cr
\link[paws.database:lakeformation_start_query_planning]{start_query_planning} \tab Submits a request to process a query statement\cr
\link[paws.database:lakeformation_start_transaction]{start_transaction} \tab Starts a new transaction and returns its transaction ID\cr
\link[paws.database:lakeformation_update_data_cells_filter]{update_data_cells_filter} \tab Updates a data cell filter\cr
\link[paws.database:lakeformation_update_lf_tag]{update_lf_tag} \tab Updates the list of possible values for the specified LF-tag key\cr
\link[paws.database:lakeformation_update_resource]{update_resource} \tab Updates the data access role used for vending access to the given (registered) resource in Lake Formation\cr
\link[paws.database:lakeformation_update_table_objects]{update_table_objects} \tab Updates the manifest of Amazon S3 objects that make up the specified governed table\cr
\link[paws.database:lakeformation_update_table_storage_optimizer]{update_table_storage_optimizer} \tab Updates the configuration of the storage optimizers for a table
}
}

\examples{
\dontrun{
svc <- lakeformation()
svc$add_lf_tags_to_resource(
  Foo = 123
)
}

}
